;
; tit			(string)	['CCD_A']
; ptit (plot title)	(string)	['April 2007']
; outf			(string)	['$HOME/work/localdata/log/status/trends/ccd_temp_200704_ccda']
; nel			(integer)	[Number of elements in each data array]
; mins			(float array)
; maxs			(float array)
; avgs			(float array)
; units			(string)	['Degrees C']
;
;pro eis_plot_trend_data, tit, ptit, outf, mins, maxs, avgs, units, std=std
pro eis_plot_trend_data, tit, ptit, outf, mins, maxs, avgs, units, std=std,start=start,finish=finish

    nel = n_elements(mins)
    x   = bindgen(nel)
    x = x + 1

    c = 0

    dmins = float(mins)
    dmaxs = float(maxs)
    davgs = float(avgs)        

    ; Get all the non-missing data
    good_values = where(finite(dmins), count)
    if count ne 0 then begin
        ymin = min(mins[good_values])
        ymax = max(maxs[good_values])

        cs = 1.6

        if keyword_set(start) then begin
            set_plot, 'ps'
            device, xoff = 2.5, yoff = 6, xs = 16, ys = 18, file = outf+'.ps'
            
;        else begin
;        device, xoff = 2.5, yoff = 6, xs = 16, ys = 18
            !p.multi = [0,1,3]

        endif

        plot,  x, dmins, xrange = [1, nel], yrange = [ymin, ymax], xstyle = 3, psym = 10, xtitle = ptit, title = tit, ytitle = units, charsize = cs
        oplot, x, dmins, psym = 2
        oplot, x, dmaxs, psym = 10
        oplot, x, dmaxs, psym = 4
        oplot, x, davgs, psym = 10
        oplot, x, davgs, psym = 7

            plots,0.98,0.97,psym=4,/normal
            plots,0.98,0.94,psym=7,/normal
            plots,0.98,0.91,psym=2,/normal
            xyouts,0.995,0.97,'Maximum',/normal
            xyouts,0.995,0.94,'Average',/normal
            xyouts,0.995,0.91,'Minimum',/normal

        if keyword_set(finish) then begin

            device, /close
            set_plot, 'X'
            !p.multi = 0
        endif

    endif
end
