pro raster_db_dump, quiet=quiet

  status = eis_open_db(/RASTER)
  n1      = db_info('entries')
  n = n1[0]
  dbclose

  slit_table = [1, 266, 2, 40]	; Slit/slot indices

  openw, lu, getenv('HOME') + '/data/staging/dump/raster_db_dump'+'.txt', /get_lun
;;;  openw, lu, 'raster_db_dump.txt', /get_lun
  printf, lu, format='(A5, A22, A7, A7, A7, A7)', 'Id', 'Acronym', 'Type', 'nExps', 'Sla'

;;;  for i = 0, n - 1 do begin
  for i = 0, n do begin
     raster = db_read_raster_entry(i)
     if n_tags(raster) eq 0 then begin
        if not keyword_set(quiet) then print, 'No database entry for raster id ' + strtrim(string(i),2)
     endif else begin

        id = raster.id
        acronym = raster.acronym
        raster_type = raster.rasterType
        raster_type_string = raster_type eq 0 ? 'Scan' : 'SNS'
        num_exposures = raster_type eq 0 ? raster.scan_FM_nSteps + 1 : raster.sns_nExps
        nexp = raster.nexp
        num_exposures = num_exposures * nexp

        index = raster.slitindex
        if index ge 0 and index le 3 then sla = slit_table[index] else sla = -1

        if not keyword_set(quiet) then print, format='(A9, I5, A22, I5, A5, I5, I5)', 'Raster id ', id, acronym, raster_type, raster_type_string, num_exposures, sla
        printf, lu, format='(I5, A22, A7, I7, I7)',  id, acronym, raster_type_string, num_exposures, sla

     endelse

  endfor

  close, lu
  free_lun, lu

end
