pro study_db_dump, quiet=quiet

  status = eis_open_db(/STUDY)
  n1      = db_info('entries')
  n = n1[0]
  dbclose

  slit_table = [1, 266, 2, 40]  ; Slit/slot indices

  openw, lu, getenv('HOME') + '/data/staging/dump/study_db_dump'+'.txt', /get_lun
;;;  openw, lu, 'study_db_dump.txt', /get_lun
  printf, lu, format='(A5, A22, A10, A30)', 'Id', 'Acronym', 'nRasters', 'Raster Ids'

  for i = 0, n do begin
     study = db_read_study_entry(i)
     if n_tags(study) eq 0 then begin
         if not keyword_set(quiet) then print, 'No database entry for study id ' + strtrim(string(i),2)
     endif else begin
        
         id = study.id
         acronym = study.acronym
         nrasters = study.nrasters
         studyrasters_string = ''
         if nrasters gt 0 then begin
             studyrasters = study.studyrasters
             limit = nrasters - 1
             for r = 0,limit do begin
                 studyrasters_string = studyrasters_string + strtrim(string(studyrasters[r].ra_id),2)
                 if r ne limit then studyrasters_string = studyrasters_string + ', '
             endfor
         endif
        
         if not keyword_set(quiet) then print, format='(A9, I5, A22, I5, A, A-50)', 'study id ', id, acronym, nrasters, ' ', studyrasters_string
         printf, lu, format='(I5, A22, I7, A, A-50)',  id, acronym, nrasters, ' ', studyrasters_string

     endelse
    
 endfor

 close, lu
 free_lun, lu

end

