;+
; NAME: base_object__define.pro
;
; PURPOSE: Definition of the base object which is the base for all EIS components
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: None
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: None
;
; CALLS: None
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-

;pro sys_if_object::perform, cmd_str, logger=logger
;  print, 'sys_if_object::perform: ' + cmd_str
;;  if n_elements(logger) ne 0 then logger->log('sys_if_object::perform: ' + cmd_str)
;;  spawn, cmd_str, /noshell
;end

;pro sys_if_object::trace, msg
;  self->base_object::trace, msg
;end

;pro sys_if_object::debug
;  print, 'sys_if_object::debug'
;;  print, 'base_object.io_error     : ', strtrim(string(self.io_error), 2)
;;  print, 'base_object.sys_err_code : ', strtrim(string(self.sys_err_code[0]), 2) + ' ' + strtrim(string(self.sys_err_code[1]), 2)
;;  print, 'base_object.sys_err_str  : ', self.sys_err_str[0]
;;  print, 'base_object.name         : ', self.name
;;  print, 'base_object.version      : ', self.version
;end

;function sys_if_object::INIT
;print, 'sys_if_object::INIT'
;  self->clear_errors
;  self.set_name, 'sys_if_object'
;  self.set_version, '0.0'
;  self.set_base_version, '0.0'
;  self.verbose = 0
;  return, 1
;end

pro sys_if_object__define
;  print,'base_object__define'
  struct = { sys_if_object,              $
             inherits base_object }
end
