@include "abs.awk"

BEGIN {
    FS=","
    str1  = "v28_min,v28_max,v28_avg,v28_range,"
    str2  = "v28i_min,v28i_max,v28i_avg,v28i_range,"
    str3  = "v28_pwr_min,v28_pwr_max,v28_pwr_avg,v28_pwr_range,"
    str4  = "v28_std_min,v28_std_max,v28_std_avg,v28_std_range,"
    str5  = "v28i_std_min,v28i_std_max,v28i_std_avg,v28i_std_range,"
    str6  = "v28_pwr_std_min,v28_pwr_std_max,v28_pwr_std_avg,v28_pwr_std_range,"

    fmt = "%s,%s,\
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f\n"
}

function title (sd, ed) {
    printf("%s,%s,%s%s%s%s%s%s\n",sd,ed,str1,str2,str3,str4,str5,str6)
}

/^start_date/       { title($1, $2) ; next }
                    { printf(fmt, $1, $2, \
			     $3,  $4,  $5,  abs($4  - $3),  \
			     $6,  $7,  $8,  abs($7  - $6),  \
			     $9,  $10, $11, abs($10 - $9),  \
			     $12, $13, $14, abs($13 - $12), \
			     $15, $16, $17, abs($16 - $15), \
			     $18, $19, $20, abs($19 - $18)) ; next }
