@include "abs.awk"

BEGIN {
    FS=","
    str1  = "htra_min,htra_max,htra_avg,htra_range,"
    str2  = "htrb_min,htrb_max,htrb_avg,htrb_range,"
    str3  = "htrc_min,htrc_max,htrc_avg,htrc_range,"
    str4  = "icu1_min,icu1_max,icu1_avg,icu1_range,"
    str5  = "icu2_min,icu2_max,icu2_avg,icu2_range,"
    str6  = "str1_min,str1_max,str1_avg,str1_range,"
    str7  = "str2_min,str2_max,str2_avg,str2_range,"
    str8  = "str3_min,str3_max,str3_avg,str3_range,"
    str9  = "str4_min,str4_max,str4_avg,str4_range,"
    str10 = "str5_min,str5_max,str5_avg,str5_range,"
    str11 = "str6_min,str6_max,str6_avg,str6_range,"
    str12 = "str7_min,str7_max,str7_avg,str7_range"

    fmt = "%s,%s,\
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f,	 \
%s,%s,%s,%6.2f\n"
}

function title (sd, ed) {
    printf("%s,%s,%s%s%s%s%s%s%s%s%s%s%s%s\n",sd,ed,str1,str2,str3,str4,str5,str6,str7,str8,str9,str10,str11,str12)
}

/^start_date/       { title($1, $2) ; next }
/^No date/          { print $0 ; next }
                    { printf(fmt, $1, $2, \
			     $3,  $4,  $5,  abs($4  - $3),  \
			     $6,  $7,  $8,  abs($7  - $6),  \
			     $9,  $10, $11, abs($10 - $9),  \
			     $12, $13, $14, abs($13 - $12), \
			     $15, $16, $17, abs($16 - $15), \
			     $18, $19, $20, abs($19 - $18), \
			     $21, $22, $23, abs($22 - $21), \
			     $24, $25, $26, abs($25 - $24), \
			     $27, $28, $29, abs($28 - $27), \
			     $30, $31, $32, abs($31 - $30), \
			     $33, $34, $35, abs($34 - $33), \
			     $36, $37, $38, abs($37 - $36)) ; next }
