#!/usr/bin/perl -W

#require "CcsdsInterface.pl";

use Env qw(EGSE_SW_LIB);
#do "$EGSE_SW_LIB/next_date.pl" || die "Can't find next_date.pl: $!\n";

use lib "$EGSE_SW_LIB/perllib/CcsdsLib";

use CcsdsInterface;

#print "\@ARGV: ", @ARGV, "\n";

if($#ARGV == 0) {
    $filename = $ARGV[0];
}
elsif($#ARGV == 1) {
#    $summary = ("-s" eq shift);
#    $filename = shift;
    $summary = ("-s" eq $ARGV[0]);
    $filename = $ARGV[1];
#    print STDERR "Summary: $summary\n";
}
else {
    message("Supply filename to process");
    exit -1;
}

$first = 1;
print STDOUT "Filename: $filename\n";
$archive = CcsdsInterface->new();
if($archive->openForReading($filename)) {
    $archive->setPrimaryHeaderLength(6);
    $archive->setSecondaryHeaderLength(4);
    $archive->setEndian("big");		# Not necessary, big is default
    if($summary) {
	while($archive->nextPacket()) {
	    if($first) {
		$archive->printHeaders();
		$first = 0;
	    }
	}
	$archive->printHeaders();
    }
    else {
	while($archive->nextPacket()) {
	    $archive->printHeaders();
	}
	$archive->report();
    }
}
else {
    print STDERR "Failed to open file\n";
}

sub message {
    my $message = shift;

    print STDOUT "$message\n";
}
