#!/usr/bin/perl

use Env qw(EGSE_SW_LIB);
use lib "$EGSE_SW_LIB/perllib/CcsdsLib";
use MdInterface;
use File::Basename;

$num_args = $#ARGV;
if($num_args == 0) {
    $filename = $ARGV[0];
}
else {
    if($num_args == 1) {
	$filename = $ARGV[1];
	$verbose = $ARGV[0];
	if($verbose ne "-v") {
	    print STDERR "verbose flag is $verbose\n";
	    exit;
	}
	else { $verbose = 1; }
    }
    else {
	print STDERR "Too many arguments\n"; write_log($filename, "Too many args"); exit;
    }
}

$md_archive = MdInterface->new();
print STDOUT "\nFile: $filename\n" if($verbose);
$ret = 0;
$md_headers = 0;
if($md_archive->openForReading($filename)) {
    if($md_archive->get_bigendian_header_packet()) {
	++$md_headers;
	if(check_start_flags($md_archive)) {
	    print "Start flags ok ",$md_archive->sequenceFlags(), "\n" if($verbose);
	    while($md_archive->nextPacket()) {
		last if($md_archive->isLastPacketOfSequence());
	    }
	    while(1) {
		last unless $md_archive->get_bigendian_header_packet();
		while($md_archive->nextPacket()) {
		    last if($md_archive->isLastPacketOfSequence());
		}
	    }
	    if(check_end_flags($md_archive)) {
		print "End flags ok ",$md_archive->sequenceFlags(),  "\n" if($verbose);
	    }
	    else {
		print "End flags incorrect ",$md_archive->sequenceFlags(), "\n" if($verbose);
		$ret = 4;
	    }
	}
	else {
	    $ret = 3;
	    $last;
	}
    }
    else {
	$ret = ($md_headers == 0) ? 2 : 0;
	last;
    }
#    $md_archive->report();
}
else {
    $ret = 1;
}
exit($ret);

sub check_start_flags {
    my $archive = shift;
    return 1 if($archive->isFirstExposurePacket());
    return 0;
}

sub check_end_flags {
    my $archive = shift;
    if($archive->isEndExposurePacket()) {
	my $flags = $archive->sequenceFlags();
	return 1 if($flags == 2);
	return 0;
    }

}
