#!/usr/bin/perl -W

use lib "/home/solarb/perllib/CcsdsLib";
use MdInterface;
use Raster;
use CcsdsPacket;

use File::Basename;

my %decomp_method = ('0000' => "/bin/ls",
		     '3B28' => "/home/solarb/dpcm.new/dpcmtopnm");


#if($#ARGV >= 0) {foreach $i (0 .. $#ARGV) { $filename = $ARGV[$i]; print "Filename: $filename\n"; } }
#if($#ARGV >= 0) {foreach $i (0 .. $#ARGV) { $filename = shift; print "Filename: $filename\n"; } }
#if($#ARGV >= 0) {while($filename = shift) { print "Filename: $filename\n"; } }
#exit;

if($#ARGV == 0) { $filename = $ARGV[0]; }
else { print STDOUT "Supply filename to process\n"; write_log($filename, "No file supplied"); exit; }

$mdArchive = MdInterface->new();
$mdArchive->setEndian("small");	# Should be big for data from isas...

$outputDir = "/tmp/";
$outputFile = basename($filename);
$outputFilenameBase = $outputDir . $outputFile;
print STDOUT "File: $outputFilenameBase\n";

# msf,ssf
#
# Multiple rasters
# 1,1 -> (1,0) -> 1,2 -> 0,1 -> (0,0) -> 0,2 -> 2,1 -> (2,0) -> 2,2
# 1,1 ->          1,2 -> 0,1 ->          0,2 -> 2,1          -> 2,2
# 1,1 -> (1,0) -> 1,2 -> 2,1 -> (2,0) -> 2,2
# 1,1 ->          1,2 -> 2,1          -> 2,2
#
# 1,3 -> (0,3) -> 2,3
# 1,3 ->          2,3
#
# Standalone rasters
# 3,1 -> (3,0) -> 3,2
# 3,1 ->          3,2
#
# 3,3
#
if($mdArchive->openForReading($filename)) {
    $mdArchive->setEndian("big");
    if($mdArchive->get_bigendian_header_packet()) {
	if($mdArchive->isCompressed()) {
	    print STDOUT "Processing...\n";
	    $processed = 0;
	    $raster = Raster->new();
	    $raster->openOutput($outputFilenameBase, "_decomp");
	    $raster->ccsdsStuff($mdArchive->packetApid(), $mdArchive->firstSequenceCount());
	    $processed = process_1_1() if($mdArchive->flags_1_1());
	    $processed = process_1_3() if($mdArchive->flags_1_3());
	    $processed = process_3_1() if($mdArchive->flags_3_1());
	    $processed = process_3_3() if($mdArchive->flags_3_3());
	    write_log($filename, "Processed") if($processed > 0);
	    processing_error() if($processed <= 0);
	}
	else {
	    write_log($filename, "Not processed (uncompressed data)");
	}
    }
    else {
	write_log($filename, "Unable to get header packet");
    }
}
else {
    write_log($filename, "Error opening file : $!");
}

sub processing_error {
    write_log($filename, "Error");
}

sub write_log {
    my $filename = shift;
    my $message = shift;

    print STDOUT "$filename : $message\n";
}

# Multiple exposure raster with each exposure in 2 to 8 md packets
sub process_1_1 {
   print STDOUT "process_1_1\n";
   while(process_3_1()) {
   }
   return 11;
}

# Multiple exposure raster with each exposure in a single md packet
sub process_1_3 {
    print STDOUT "process_1_3\n";
    process_3_3();
    while($mdArchive->get_bigendian_header_packet()) {
	process_3_3();
    }
    return 13;
}

# One exposure raster in 2 to 8 md packets
# Read in each packet and decompress
#
# for all md packets in this exposure
#	read in exposure data
#	decompress
#	rebuild
#
# Entry: $mdArchive has read the header packet in
sub process_3_1 {
    my $res;
    my $return_val;
    my $packet_size;

    print STDOUT "process_3_1\n";
    $packet_size = sprintf "%u", hex($mdArchive->{_packetSize});
    $packet_size -= 256;
    while(1) {
	$raster->storeHeaders($mdArchive->ccsdsHeaders(), $mdArchive->userData(), $mdArchive->firstSequenceCount, $mdArchive->packetSize());

	# Read in all the packets for 1 exposure and write to 1 file
	$compressedExposureDataFile = $outputFilenameBase . "_comp_exposure";
	print "FILE = $compressedExposureDataFile\n";

	open COMPFILE, ">$compressedExposureDataFile" || die "Can't open file : $!";
	while($mdArchive->nextPacket()) {
	    syswrite COMPFILE, $mdArchive->{_userData};
	    last if($mdArchive->isLastPacketOfSequence());
	}
	close COMPFILE;

	# Now decompress the data in the uncompressed exposure file
	if(($decompMethod = canDecompress())) {
	    $decompFile = $outputFilenameBase . "_decomp_exposure"; 
	    $inputFile  = $compressedExposureDataFile;
	    print STDOUT "DECOMPRESSING $inputFile to $decompFile)\n";
###	    $res = system("$decompMethod -v -o$packet_size $inputFile > $decompFile");
	    $res = system("$decompMethod -o$packet_size $inputFile > $decompFile");
	    $res = 0;
	    print STDOUT "Decomp Error\n" if($res != 0);
	    last if($res != 0);
	}
	# Now re-assemble the mission data packets
	if($res == 0) {
	    $raster->openInput($outputFilenameBase, "_decomp_exposure");
	    $raster->writeExposureHeader();
	    $raster->writeExposureData();
	    $raster->closeInputFile();
	}
	else {
	    print STDOUT "Unable to decompress\n";
	}

	$return_val = 0;
	last unless($mdArchive->get_bigendian_header_packet());
	if($mdArchive->isFirstExposurePacket()) {
	    $return_val = 1;
	    last;
	}
    }
###    return 31;
    return $return_val;
}

# One exposure raster in 2 to 8 md packets
#sub process_3_1 {
#    my $packetCounter = 0;
#    my $res;
#    my $return_val;
#
##################################    $packetCounter = 0;
#    print STDOUT "process_3_1\n";
#    $raster->storeHeaders($mdArchive->ccsdsHeaders(), $mdArchive->userData(), $mdArchive->firstSequenceCount, $mdArchive->packetSize());
#
#    # Read in all the packets for 1 exposure
#    while(1) {
#	$return_val = 0;
#	writeExposurePacketToFile($outputFilenameBase . "_$packetCounter");
#	++$packetCounter;
#	last unless($mdArchive->get_bigendian_header_packet());
#	if($mdArchive->isFirstExposurePacket()) {
#	    $return_val = 1;
#	    last;
#	}
#	$raster->storeHeaders($mdArchive->ccsdsHeaders(), $mdArchive->userData(), $mdArchive->firstSequenceCount, $mdArchive->packetSize());
#    }
#    # Now decompress the data
#    if(($decompMethod = canDecompress())) {
#	foreach $i (0 .. ($packetCounter - 1)) {
#	    $decompFile = $outputFilenameBase . "_$i" . "_decomp"; 
#	    $inputFile  = $outputFilenameBase . "_$i";
#	    print STDOUT "DECOMPRESSING $packetCounter packets (in: $inputFile, out:$decompFile)\n";
#	    $res = system("$decompMethod -v $inputFile > $decompFile");
#	    $res = 0;
#	    print STDOUT "Decomp Error\n" if($res != 0);
#	    last if($res != 0);
#	}
#
#	# Now re-assemble the mission data packets
#	if($res == 0) {
#	    foreach $i (0 .. ($packetCounter - 1)) {
#		$insuffix = "_" . $i . "_decomp";
#		$raster->openInput($outputFilenameBase, "_$i");
#		$raster->openInput($outputFilenameBase, $insuffix);
#		$raster->writeExposureHeader();
#		$raster->writeExposureData();
#	    }
#	    $raster->closeInputFile();
#	}
#    }
#    else {
#	print STDOUT "Unable to decompress\n";
#    }
####    return 31;
#    return $return_val;
#}

# Single exposure raster in 1 md packet
sub process_3_3 {
    my $decompMethod;
    my $res;

    print "process_3_3\n";
    $raster->storeHeaders($mdArchive->ccsdsHeaders(), $mdArchive->userData(), $mdArchive->firstSequenceCount, $mdArchive->packetSize());
    writeExposurePacketToFile($outputFilenameBase . "_0");
    if(($decompMethod = canDecompress())) {
	$decompFile = $outputFilenameBase . "_decomp"; 
	$inputFile  = $outputFilenameBase . "_0";
	print STDOUT "DECOMP METHD : $decompMethod\n";
########	$res = system("$decompMethod -l $outputFilenameBase");
	$res = system("$decompMethod -v $inputFile > $decompFile");
	$res = 0;
    }
    # Now re-assemble the mission data packet
    print STDOUT "RES = $res\n";
    if($res == 0) {
	print STDOUT "RE-ASSEMBLE\n";
	$raster->openInput($outputFilenameBase, "_0");
#	$raster->writeRaster();
	$raster->writeExposureHeader();
	$raster->writeExposureData();
	$raster->closeInputFile();
    }
    return 33;
}


sub no_header {
    print STDOUT "Didn't get header\n";
    print STDOUT "Sub Sequence Flag = ", $mdArchive->subSequenceFlag(), "\n";
    if($mdArchive->isLastExposurePacket()) {
	print STDOUT "End of raster\n";
    }
    else {
	print STDOUT "Raster aborted\n";
    }
}


sub writeExposurePacketToFile {
#    my $compInfo = $mdArchive->tableInfo();
#    print STDOUT "COMP TABLE: $compInfo\n";
    open FILE, '>', $_[0];
#    syswrite FILE, $compInfo;
    while($mdArchive->nextPacket()) {
	syswrite FILE, $mdArchive->{_userData};
	last if($mdArchive->isLastPacketOfSequence());
    }
    close FILE;
}

sub canDecompress {
    my $decomp_method;

    if(defined($decomp_method{$mdArchive->{_compression}})) {
	$decomp_method = $decomp_method{$mdArchive->{_compression}};
	if((-e $decomp_method) && (-X $decomp_method)) {	# Does method exist & is it executable by me?
	    return $decomp_method;
	}
	else {
	    print STDOUT "$decomp_method not found or not able to execute\n";
	    return 0;
	}
    }
}
