#!/usr/local/bin/perl

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);
use lib "$EGSE_SW_LIB/perllib/CcsdsLib";
use MdInterface;
use File::Basename;

do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

my %filenames;

$num_args = $#ARGV;
if($num_args == 0) {
    $filename = $ARGV[0];
}
else {
    if($num_args == 1) {
	$filename = $ARGV[1];
	$verbose = $ARGV[0];
	if($verbose ne "-v") {
	    print STDERR "verbose flag is $verbose\n";
	    exit;
	}
    }
    else {
	print STDERR "Too many arguments\n"; write_log($filename, "Too many args"); exit;
    }
}

$archive = MdInterface->new();
print STDOUT "\nFile: $filename\n";
my $done = 0;
$md_headers = 0;
if($archive->openForReading($filename)) {
    $archive->header_report_header();
    while(1) {
	if($archive->get_bigendian_header_packet()) {
	    $archive->printHeaders() if $verbose;
	    $archive->printPrimaryHeader() if $verbose;
	    ++$md_headers;
	    $archive->header_report1();
	    $raster_id = $archive->raster_id();
	    ($eng, $type) = eng($raster_id);
	    $filenames{$file} = $type if $eng;
	    while($archive->nextPacket()) {
		last if($archive->isLastPacketOfSequence());
	    }
	}
	else {
	    last if($archive->{_packetValid} == 0);
	    print STDOUT "Pixel data\n" if !$done;
	    $done = 1;
#	    $archive->printHeaders();
#	    while($archive->nextPacket()) {
#		last if($archive->isLastPacketOfSequence());
#	    }
#	    next;
#	    last;
	}
    }
    print "$md_headers headers\n";
    $archive->report();
}
else {
    print STDERR "Failed to open file\n";
}

if(%filenames) {
    print STDERR "Data summary filenames hash has something\n";
    open(SUMMARY, ">> $merge_dir/data_summary.txt") || print STDERR "Can't open data_summary.txt : $!\n";
#    foreach $key (keys %filenames) {
#	print SUMMARY "Missing\n";
#	if($filenames{$key} eq 'Missing packets') {
#	    print SUMMARY "$key\n";
#	}
#    }
    print SUMMARY "Engineering\n";
    foreach $key (keys %filenames) {
	if($filenames{$key} =~ m/^Eng/) {
	    print SUMMARY "$key ", $filenames{$key}, "\n";
	}
    }
    print SUMMARY "\n";
    close SUMMARY;
}
else {
    print STDERR "Data summary filenames hash has NOTHING\n";
}

exit(0);

my %eng_rasters = (
		   0xC015 => 'Short Darks',
		   0xC016 => 'Long Darks',
		   );

sub eng {
    my $ras_id = shift;
    return (1, 'Eng: ' . $eng_rasters{$ras_id}) if $eng_rasters{$ras_id};
    return (0, "");
}

