#!/usr/bin/perl

#
# Read mission data packet archives which have missing mission data header ccsds packets. Write out packets we get and fill
# in with dummy mission data header packets using information derived from previous headers.
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);
use lib "$EGSE_SW_LIB/perllib/CcsdsLib";
use MdInterface1;
use File::Basename;

do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

my $first_block = 1;
my $middle_block = 2;
my $last_block = 3;

my %filenames;
my %eng_rasters = (
		   'C014' => 'ADC Offset',		# regcal014
		   'C015' => 'Short Darks',		# regcal015
		   'C016' => 'Long Darks',		# regcal016
		   'C017' => 'Short Flats',		# regcal017
		   'C018' => 'Long Flats',		# regcal018
		   'C019' => 'Intensity Calibration',	# regcal019
		   'D020' => 'Pointing and Alignment',	# regcal020
		   'D022' => 'Pointing and Alignment',	# regcal022
		   'D067' => 'EUV',			# regcal067
		   'D068' => 'EUV',			# regcal068
		   'C070' => 'Flat Oscn',		# regcal070
		   'C071' => 'Dark Bottom',		# regcal071
		   'C072' => 'Dark Top',		# regcal072
		   'C073' => 'Reduced Long',		# regcal073
		   'C074' => 'Dark Prescan',		# regcal074
		   'C075' => 'Dark Daily',		# regcal075
		   'C076' => '1exp_100ms',		# regcal076
		   'C077' => '2exps_80ms',		# regcal077
		   'D167' => 'EUV',			# regcal067
		   'D168' => 'EUV',			# regcal06
		   'D078' => 'Dark Bottom 0s',		# regcal078
		   'D079' => 'Dark Top 0s',		# regcal079
		   );

$num_args = $#ARGV;
if($num_args == 0) {
    $dirname = $ARGV[0];
}
else {
    if($num_args > 0) {
	while(@ARGV) {
	    $arg = shift;
	    if($arg =~ /^\-/) {
		next;
	    }
	    $dirname = $arg;
	    last;
#	    if($verbose ne "-v") {
#		print STDERR "verbose flag is $verbose\n";
#	    exit;
#	    }
	}
    }
    else {
	print STDERR "Not enough arguments\n"; write_log($filename, "Not enough args"); exit;
    }
}
#print STDERR "DIRNAME  = $dirname\n";

$archive = MdInterface->new();

@files = `ls $dirname | grep eis_md`;

my $file;

print html_header("Hinode EIS Mission Header Dump");
print "<body>\n";
print "<pre>\n";


foreach $filen (@files) {
    chomp $filen;
    $last_file = $filen;
    $file = "$dirname/$filen";
    my $short_name = substr $file, -26, 26;

    my $ppe = 0;	# Packets per exposure (1 - 8)
    my $ssc = 0;	# Sub sequence count (0 - (ppe - 1))
    my $ras_done = 0;	# Rasters done counter
    my $block = 0;

    my $headers_count = 0;	# Count of received headers
    my $headers_missing = 0;	# Count of missing headers

    my @headers = ();	# List of header packets

    my $done = 0;

    if($archive->openForReading($file)) {
	print STDOUT "\n$file\n";
	$archive->header_report_header();
	while(1) {
	    if($archive->get_bigendian_header_packet()) {
		$archive->printHeaders() if $verbose;
		$archive->printPrimaryHeader() if $verbose;

		if ($headers_count == 0) {
		    $raster_id = $archive->raster_id();		# constant
		    $ppe = $archive->mdPacketsPerExposure();	# constant
		    $ras_req = $archive->rasters_required();	# constant
		    $ep = $archive->exposures_per_position();	# constant
		}

		$ssc = $archive->subsequence_count();
		$ras_done = $archive->rasters_counter();
		if ($ras_done == $ras_req) {
		    $block = $last_block;
		}
		elsif ($ras_done > 1) {
		    $block = $middle_block;
		}
		else {
		    $block = $first_block;
		}

		push @headers, $self->packet();	# Save entire ccsds packet

		++$headers_count;

		$archive->header_report1();
		($eng, $type) = eng($raster_id);
		$filenames{$file} = $type if $eng;
		while($archive->nextPacket()) {
		    last if($archive->isLastPacketOfSequence());
		}
	    }
	    else {
		last if($archive->{_packetValid} == 0);
		#print STDOUT "Pixel data\n" if !$done;
		#$done = 1;
		print STDOUT "Pixel data\n";
		while($archive->nextPacket()) {
		    last if( ($archive->isLastPacketOfSequence()) || ($archive->{_packetValid} == 0) );
		}
	    }
	}
	print "$headers_count headers\n";
	$archive->report();
	$shutter_move = 0;
	$shutter_move = sprintf("%5u", ($ras_req * $ep * 2)) if $eng == 0;
#	$shutter_move = sprintf("%5u", (($md_headers * 2) / $ppe)) if $eng == 0;
###	print SHUT "$short_name : ", sprintf("%5u", ($md_headers * 2)), "\n";
	print SHUT "$short_name : ", $shutter_move, "\n";
}
    else {
	print STDERR "Failed to open file\n";
    }
}
close SHUT;

print "</pre>\n";
html_end();

if(%filenames) {
    print STDERR "Data summary filenames hash has something\n";
    open(SUMMARY, "> $dirname/engineering.txt") || print STDERR "Can't open engineering.txt : $!\n";
    print SUMMARY "Engineering\n";
    foreach $key (keys %filenames) {
	if($filenames{$key} =~ m/^Eng/) {
	    $val = $filenames{$key};
	    $val =~ s/Eng //;
	    print SUMMARY "$key:$val\n";
	}
    }
    print SUMMARY "\n";
    close SUMMARY;
}
else {
    print STDERR "Data summary filenames hash has NOTHING\n";
}

#
# $last_file has the name of the last file processed.
# Extract the date and hhmm portion of the filename
# and save to a file, ready for the next time the
# pipeline runs it can start with the last file of
# the previous run in case that file was truncated.
# Filename: eis_md_yyyymmdd_hhmmsstthh

$date  = substr($last_file, 7, 8);
$stime = substr($last_file, 16, 4);

exit(0);

sub eng {
    my $ras_id = shift;
    return (1, 'Eng ' . $eng_rasters{$ras_id}) if $eng_rasters{$ras_id};
    return (0, "");
}

