#!/usr/bin/perl

use Env qw(EGSE_SW_LIB);

use lib "$EGSE_SW_LIB/perllib/CcsdsLib";
use MdInterface;
use File::Basename;

do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

#$num_args = $#ARGV;
#if($num_args == 0) {
#    $directory = $ARGV[0];
#}
#else {
#    if($num_args == 1) {
#	$directory = $ARGV[1];
#	$verbose = $ARGV[0];
#	if($verbose ne "-v") {
#	    print STDERR "verbose flag is $verbose\n";
#	    exit;
#	}
#    }
#    else {
#	print STDERR "Too many arguments\n"; write_log($filename, "Too many args"); exit;
#    }
#}

# Create a mission data archive reader
$md_archive = MdInterface->new();

# Get rid of empty line at top of file
$junk = <>;

# Read in rest of file
while(<>) {
    if(/discard/) {
	print STDOUT "$_";
	$junk = <>;	# Read in filename
	$junk = <>;	# Read in blank line
	next;
    }
    if(/standalone/) {
	print STDOUT "$_";
	$pathname = <>;
	chomp $pathname;
	$file = basename($pathname);
	$dir  = dirname($pathname);
	print "\t$file\n";
	$junk = <>;	# Read in blank line	

#	system("/bin/cp $pathname $splice_dir/$file");

	next;
    }
    if(/join/) {
	print STDOUT "$_";
	while(<>) {
	    last if /^$/;
	    chomp;
	    $file = basename($_);
	    $dir  = dirname($_);

	    # Read in the md files. Remember the ccsds sequence count of the last packet.
	    # Check count is > than last one

	    print STDOUT "\t$file\n";
	}
	next;
    }
    print "HUH? : $_";
}

exit;

my $first = 1;
my $cont  = 0;

foreach $filename (`ls $directory/eis_md*`) {
    chomp $filename;
#    $md_archive = MdInterface->new();
    if($md_archive->openForReading($filename)) {
	if($first) {
	    if($md_archive->get_bigendian_header_packet()) {
		# expecting first packet of raster
		if(check_start_flags($md_archive)) {
		    # remember the mid
		    $previous_mid = $md_archive->mid();
		    # read rest of archive
		    while(1) {
			while($md_archive->nextPacket()) {
			    last if($md_archive->isLastPacketOfSequence());
			}
			last unless($md_archive->get_bigendian_header_packet());
		    }
		    if(check_end_flags($md_archive)) {
			# archive is complete, keep first flag and output instructions
			print STDOUT "\nstandalone\n$filename\n";
		    }
		    else {
			# this archive is incomplete, set flags and output
			$first = 0;
			$cont  = 1;
			print STDOUT "\njoin 1\n$filename\n";
		    }
		}
		else {
		    # first packet in archive is not start but first flag is set
		    print STDOUT "\ndiscard 1\n$filename\n";
		}
	    }
	    else {
		# Couldnt get header, discard file
		print STDOUT "\ndiscard 2\n$filename\n";
	    }
	}
	elsif($cont) {
	    if($md_archive->get_bigendian_header_packet()) {
		$mid = $md_archive->mid();
#		if($md_archive->mid() == $previous_mid) {
		if($mid eq $previous_mid) {
#print "mid: $mid, previous mid: $previous_mid\n";
		    print STDOUT "$filename 1\n";
		    while($md_archive->nextPacket()) {
			last if($md_archive->isLastPacketOfSequence());
		    }
		    # read rest of archive
		    while($md_archive->get_bigendian_header_packet()) {
			while($md_archive->nextPacket()) {
			    last if($md_archive->isLastPacketOfSequence());
			}
		    }
		    if(check_end_flags($md_archive)) {
			# archive is complete, change flags
			$cont = 0;
			$first = 1;
		    }
		}
		elsif(check_start_flags($md_archive)) { # Valid start of new archive?
		    # read rest of archive
		    $previous_mid = $md_archive->mid();
		    while(1) {
			while($md_archive->nextPacket()) {
			    last if($md_archive->isLastPacketOfSequence());
			}
			last unless($md_archive->get_bigendian_header_packet());
		    }
		    if(check_end_flags($md_archive)) {
			# archive is complete, change flags
			$cont = 0;
			$first = 1;
			print STDOUT "\nstandalone\n$filename\n";
		    }
		    else {
			$cont = 1;
			$first = 0;
			$previous_mid = $md_archive->mid();
			print STDOUT "\njoin 2\n$filename\n";
		    }
		    
		}
		else { # not valid, discard
		    print STDOUT "\ndiscard 3\n$filename\n";
		}
	    }
	    else {	# pixel data, join to previous file (guess)
		print STDOUT "$filename 2\n";
	    }
	    
	}
    }
    else {
	print STDERR "Failed to open file\n";
	print STDOUT "bad\n$filename\n";
    }
}

exit(0);


sub check_start_flags {
    my $archive = shift;
    return 1 if($archive->isFirstExposurePacket1());
    return 0;
}
 
sub check_end_flags {
    my $archive = shift;
    return 1 if($archive->isLastExposurePacket1());
    return 0;
}
