#!/usr/bin/perl

use Env qw(EGSE_SW_LIB);

use lib "$EGSE_SW_LIB/perllib/CcsdsLib";

use MdInterface;

use File::Basename;

$num_args = $#ARGV;
if($num_args == -1) {
    print STDERR "Supply a directory\n";
    exit;
}
if($num_args == 0) {
    $directory = $ARGV[0];
}
else {
    if($num_args == 1) {
	$directory = $ARGV[1];
	$verbose = $ARGV[0];
	if($verbose ne "-v") {
	    print STDERR "verbose flag is $verbose\n";
	    exit;
	}
    }
}

my $done  = 0; # ?
my $first = 1;
my $cont  = 0;

$md_archive = MdInterface->new();
foreach $filename (`ls $directory/eis_md*`) {
    chomp $filename;
    if($md_archive->openForReading($filename)) {
	if($first) {
	    if($md_archive->get_bigendian_header_packet()) {
		# expecting first packet of raster
		if(check_start_flags($md_archive)) {
		    # remember the mid
		    $previous_mid = $md_archive->mid();
		    $previous_rid = $md_archive->raster_id();
		    # read rest of archive
		    while(1) {
			while($md_archive->nextPacket()) {
			    last if($md_archive->isLastPacketOfSequence());
			}
			last unless($md_archive->get_bigendian_header_packet());
		    }
		    if(check_end_flags($md_archive)) {
			# archive is complete, keep first flag and output instructions
			print STDOUT "\nstandalone\n$filename\n";
		    }
		    else {
			# this archive is incomplete, set flags and output
			$first = 0;
			$cont  = 1;
			print STDOUT "\njoin 1\n$filename\n";
		    }
		}
		else {
		    # first packet in archive is not start but first flag is set
		    print STDOUT "\ndiscard 1\n$filename\n";
		}
	    }
	    else {
		# Couldnt get header, discard file
		print STDOUT "\ndiscard 2\n$filename\n";
	    }
	}
	elsif($cont) {
	    
	    if($md_archive->get_bigendian_header_packet()) {
		
		if(check_start_flags($md_archive)) { # Valid start of new archive?
		    # read rest of archive
		    $previous_mid = $md_archive->mid();
		    while(1) {
			while($md_archive->nextPacket()) {
			    last if($md_archive->isLastPacketOfSequence());
			}
			last unless($md_archive->get_bigendian_header_packet());
		    }
		    if(check_end_flags($md_archive)) {
			# archive is complete, change flags
			$cont = 0;
			$first = 1;
			print STDOUT "\nstandalone\n$filename\n";
		    }
		    else {
			$cont = 1;
			$first = 0;
			$previous_mid = $md_archive->mid();
			print STDOUT "\njoin 2\n$filename\n";
		    }
		    
		}
		
		else {
		    $mid = $md_archive->mid();
		    $rid = $md_archive->raster_id();
		    # Need to test for rid here ...
		    if($mid eq $previous_mid) {
			print STDOUT "$filename\n";
			while($md_archive->nextPacket()) {
			    last if($md_archive->isLastPacketOfSequence());
			}
			# read rest of archive
			while($md_archive->get_bigendian_header_packet()) {
			    while($md_archive->nextPacket()) {
				last if($md_archive->isLastPacketOfSequence());
			    }
			}
			if(check_end_flags($md_archive)) {
			    # archive is complete, change flags
			    $cont = 0;
			    $first = 1;
			}
		    }
		    else { # not valid, discard
			print STDOUT "\ndiscard 3\n$filename\n";
		    }
		}
	    }
	    else {	# pixel data, join to previous file (guess)
		print STDOUT "$filename\n";
	    }
	    
	}
    }
    else {
	print STDERR "Failed to open file\n";
	print STDOUT "bad\n$filename\n";
    }
}

# Add a blank line to make life easier for ccsds_md_splice.pl
print STDOUT "\n";

exit(0);


sub check_start_flags {
    my $archive = shift;
    return 1 if($archive->isFirstExposurePacket1());
    return 0;
}
 
sub check_end_flags {
    my $archive = shift;
    return 1 if($archive->isLastExposurePacket1());
    return 0;
}
