#!/usr/bin/perl

use Env qw(EGSE_SW_LIB);

use lib "$EGSE_SW_LIB/perllib/CcsdsLib";

use MdInterface;

use File::Basename;

$num_args = $#ARGV;
if($num_args == -1) {
    print STDERR "Supply a directory\n";
    exit;
}
if($num_args == 0) {
    $directory = $ARGV[0];
}
else {
    if($num_args == 1) {
	$directory = $ARGV[1];
	$verbose = $ARGV[0];
	if($verbose ne "-v") {
	    print STDERR "verbose flag is $verbose\n";
	    exit;
	}
    }
}

my $expect_first_md_packet = 1;
my $expect_more_md_packets = 0;

$md_archive = MdInterface->new();
foreach $filename (`ls $directory/eis_md*`) {
    chomp $filename;
    if($md_archive->openForReading($filename)) {
	if($expect_first_md_packet) {
	    if($md_archive->get_bigendian_header_packet()) {
		# expecting first packet of raster
		if(check_start_flags($md_archive)) {
		    # remember the mid
		    $previous_mid = $md_archive->mid();
		    $previous_rid = $md_archive->raster_id();

		    # read rest of archive
		    while(1) {
			while($md_archive->nextPacket()) {
			    last if($md_archive->isLastPacketOfSequence());
			}
			last unless($md_archive->get_bigendian_header_packet());
		    }

		    if(check_end_flags($md_archive)) {
			# archive is complete, keep first flag and output instructions
			#print STDOUT "\nstandalone 1\n$filename\n";
			verdict($md_archive, "\nstandalone 1\n$filename\n");
		    }
		    else {
			# this archive is incomplete, set flags and output
			$expect_first_md_packet = 0;
			$expect_more_md_packets = 1;
			#print STDOUT "\njoin 1\n$filename\n";
			verdict($md_archive, "\njoin 1\n$filename\n");
		    }
		}

		else {
		    # first packet in archive is not start but first flag is set
#		    verdict($md_archive, "\ndiscard 1\n$filename\n");
		    verdict($md_archive, "\nstandalone n\n$filename\n");
		}
	    }

	    else {
		# First packet not a header, find one if there is one
		# read rest of archive
		while(1) {
		    while($md_archive->nextPacket()) {
			last if($md_archive->isLastPacketOfSequence());
		    }
		    last unless($md_archive->get_bigendian_header_packet());
		}

		if(check_end_flags($md_archive)) {
		    # archive is complete, keep first flag and output instructions
		    #print STDOUT "\nstandalone 1\n$filename\n";
		    verdict($md_archive, "\nstandalone n\n$filename\n");
		}
		else {
		    # this archive is incomplete, set flags and output
		    $expect_first_md_packet = 0;
		    $expect_more_md_packets = 1;
		    # remember the mid
		    $previous_mid = $md_archive->mid();
		    $previous_rid = $md_archive->raster_id();
		    #print STDOUT "\njoin 1\n$filename\n";
		    verdict($md_archive, "\njoin n\n$filename\n");
		}
### mcrw 20210824
###      Changed to discard
###		verdict($md_archive, "\nstandalone 2\n$filename\n");
#		verdict($md_archive, "\ndiscard 2\n$filename\n");
	    }
	}

	elsif($expect_more_md_packets) {
	    
	    if($md_archive->get_bigendian_header_packet()) {
		
		if(check_start_flags($md_archive)) { # Valid start of new archive?
		    # read rest of archive
		    $previous_mid = $md_archive->mid();
		    while(1) {
			while($md_archive->nextPacket()) {
			    last if($md_archive->isLastPacketOfSequence());
			}
			last unless($md_archive->get_bigendian_header_packet());
		    }
		    if(check_end_flags($md_archive)) {
			# archive is complete, change flags
			$expect_more_md_packets = 0;
			$expect_first_md_packet = 1;
			#print STDOUT "\nstandalone 3\n$filename\n";
			verdict($md_archive, "\nstandalone 3\n$filename\n");
		    }
		    else {
			$expect_more_md_packets = 1;
			$expect_first_md_packet = 0;
			$previous_mid = $md_archive->mid();
			#print STDOUT "\njoin 2\n$filename\n";
			verdict($md_archive, "\njoin 2\n$filename\n");
		    }
		    
		}
		
		else {
		    $mid = $md_archive->mid();
		    $rid = $md_archive->raster_id();
		    # Need to test for rid here ...
		    if(($mid eq $previous_mid) && ($rid eq $previous_rid)) {
			#print STDOUT "$filename\n";
			verdict($md_archive, "$filename\n");
			while($md_archive->nextPacket()) {
			    last if($md_archive->isLastPacketOfSequence());
			}
			# read rest of archive
			while($md_archive->get_bigendian_header_packet()) {
			    while($md_archive->nextPacket()) {
				last if($md_archive->isLastPacketOfSequence());
			    }
			}
			if(check_end_flags($md_archive)) {
			    # archive is complete, change flags
			    $expect_more_md_packets = 0;
			    $expect_first_md_packet = 1;
			}
			else {
			    $expect_more_md_packets = 1;
			    $expect_first_md_packet = 0;
			    $previous_mid = $mid;
			    $previous_rid = $rid;
			    #print STDOUT "\n\njoin 3\n$filename\n";
			    #verdict($md_archive, "\n\njoin 3\n$filename\n");
			    verdict($md_archive, ""); # Filename has already been printed when you get to here...
			}
		    }
		    else { # not valid, discard
###			print STDOUT "\ndiscard 3\n$filename\n";
			#print STDOUT "\nstandalone 4\n$filename\n";
			verdict($md_archive, "\nstandalone 4\n$filename\n");
		    }
		}
	    }
	    else {	# pixel data, join to previous file (guess)
		#print STDOUT "$filename\n";
		verdict($md_archive, "$filename\n");
	    }
	    
	}
    }
    else {
	print STDERR "Failed to open file\n";
	print STDOUT "bad\n$filename\n";
    }
}

# Add a blank line to make life easier for ccsds_md_splice.pl
print STDOUT "\n";

exit(0);


sub check_start_flags {
    my $archive = shift;
    return 1 if($archive->isFirstExposurePacket1());
    return 0;
}
 
sub check_end_flags {
    my $archive = shift;
    return 1 if($archive->isLastExposurePacket1());
    return 0;
}

sub verdict {
    my $archive = shift;
    my $string = shift;

    print STDOUT $string;
    $archive->closeInput();
}
