#!/usr/local/bin/perl

$filename = "";
$missing = 0;
$gaps    = 0;
$total   = 0;

#print "Filename                    Total Missing  Gaps\n";

$date = "No date";
#print STDERR "ARGV = ", $#ARGV, "\n";# -1 for no args

if($#ARGV != -1) {
###    $date = $ARGV[0];
    $date = shift;
#    print "$date\n";
}
###print STDERR "date = $date\n";

print "Filename\t\t      Rec    Miss  Gaps    $date\n";

while(<>) {
    next if /^Dirname/;
    next if /^$/;
    next if /^Time/;
    chomp;
    record_filename($_) if /^\/nasA/;
    record_filename($_) if /^\/san_solar/;
    $total   = record_total($_)   if /ccsds packets/;
    $total   = record_total1($_)  if /^Read/;
    $gaps    = record_gaps($_)    if /Number of gaps/;
    record_missing($_)            if /Number of packets missing/;
}

sub record_filename {
    my $line = shift;
    $filename = substr $line, -26, 26;
}

sub record_total {
    my $line = shift;
    my $tmp;
    ($tmp, @junk) = split / /, $line;
    return sprintf "%u", $tmp;

}

sub record_total1 {
    my $line = shift;
    my @tmp;
    @tmp = split / /, $line;
    return sprintf "%u", $tmp[1];

}

sub record_gaps {
    my $line = shift;
    my @tmp = split / /, $line;
    return sprintf "%u", $tmp[-1];
}

sub record_missing {
    my $line = shift;
    my @tmp = split / /, $line;
    $missing =  sprintf "%u", $tmp[-1];    

#    print "$filename\t$total\t$missing\t$gaps\n";
    write;
}

#format STDOUT_TOP =
#Filename                    Total Missing Gaps
#.

#format STDOUT = 
#@<<<<<<<<<<<<<<<<<<<<<<<<< @>>>>>  @>>>>>@>>>>>
#$filename, $total, $missing, $gaps
#.

format STDOUT = 
@<<<<<<<<<<<<<<<<<<<<<<<<< @>>>>>  @>>>>>@>>>>> @>>>>>>>
$filename, $total, $missing, $gaps, $date
.
