#!/usr/bin/perl -W

#require "CcsdsInterface.pl";

use Env qw(EGSE_SW_LIB);
#do "$EGSE_SW_LIB/next_date.pl" || die "Can't find next_date.pl: $!\n";

use lib "$EGSE_SW_LIB/perllib/CcsdsLib";

use CcsdsInterface;

#print "\@ARGV: ", @ARGV, "\n";

if($#ARGV == 0) {
    $filename = $ARGV[0];
}
else {
    message("Supply filename to process");
    exit -1;
}

$first = 1;
$t0 = 0;
$prev_apid=0;
$archive = CcsdsInterface->new();
if($archive->openForReading($filename)) {
    $archive->setPrimaryHeaderLength(6);
    $archive->setSecondaryHeaderLength(4);
    $archive->setEndian("big");		# Not necessary, big is default
    while($archive->nextPacket()) {
	$apid = $archive->getApid();
	next if $apid == 1476;
	next if $apid == 1478;
	next if $apid == 1480;
	$time = $archive->getTime();
	$t1 = sprintf "%u", hex($time);

	print $t1 - $t0, "\n" unless $first;

	$first = 0;
	$t0 = $t1;
#	$prev_apid = $apid;

    }
    $archive->report();
}
else {
    print STDERR "Failed to open file\n";
}

sub message {
    my $message = shift;

    print STDOUT "$message\n";
}
