#!/usr/bin/perl

#use Env qw(HOME);
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl" || warn "Can't do date_calc.pl: $!\n";

$HOME="/san_solar/disk2/home/sbukeis";

# The start time will either be passed in or will be generated from time now - 1 (days) (or maybe 2)

system("/bin/rm $HOME/work/localdata/sdtp/daily/eis_*");

# Start and end dates of telemetry
$sdate="20061026";
$edate="20061027";

# Antenna selection
#$ant='usc34';
$ant='allant';
#$ant='msp1';
#$ant='usc20';
#$ant='gna';
#$ant='gnb';

# Band selection. 1=S, 2=X, 3=Allband
#$band=1;	# S
#$band=2;	# X
$band=3;	# Allband

# Mode selection. late,real,daily
$mode='daily';

if($#ARGV != -1) {
    if(@ARGV) { $sdate = shift; }
    if(@ARGV) { $edate = shift; }
    if(@ARGV) { $ant   = shift; }
    if(@ARGV) { $band  = shift; }
    if(@ARGV) { $mode  = shift; }
}

# Start times
@stimes=('0000','0130','0300','0430','0600','0730','0900','1030','1200','1330','1500','1630','1800','1930','2100');

# End times
@etimes=('0130','0300','0430','0600','0730','0900','1030','1200','1330','1500','1630','1800','1930','2100','2230');

# Index into end times array
$index = 0;

# Whizz through the start times array and fetch status telemetry
foreach $start (@stimes) {
    system("$HOME/bin/sdtp $mode $ant band=$band sdate=$sdate edate=$sdate stime=$start etime=$etimes[$index]");
    ++$index;
}

# Last one uses the edate (next day)
system("$HOME/bin/sdtp $mode $ant band=$band sdate=$sdate edate=$edate stime=2230 etime=0000");

# Need to define these directories...
# Check these directories exist, starting with the year of course
# Just for now
$darts_year_dir  = substr $sdate, 0, 4;
$darts_month_dir = substr $sdate, 4, 2;
$darts_day_dir   = substr $sdate, 6, 2;

### Needs to be calculated (redundant when time conversion is ok)
$end_date = "21-Oct-06 00:00:00";

############################################### REFORMAT

# Now start the status fits reformatter process

# Could open a pipe to sswidl...
#open(IDL, "/san_darts/solar/ssw/gen/setup/ssw_idl") or die "Can't start IDL: $!\n";
#print IDL, "'$HOME/work/localdata/sdtp/daily','$HOME/data/status/$darts_year_dir/$darts_month_dir/$darts_day_dir/'\n";

# Temporary .comps
# Write the file to be executed by IDL
$output = <<EOF;
.comp $HOME/work/idl/eis_ti2utc
auto_mk_fits,'$HOME/work/localdata/sdtp/daily','$HOME/data/status/$darts_year_dir/$darts_month_dir/$darts_day_dir/'
exit
EOF
open(FITS, "> $HOME/work/tmp/daily_status.pro") or die "Can't open daily_status.pro: $!\n" ;
print FITS $output;
close FITS;

# Start IDL and run the file
#system("sswidl < $HOME/work/tmp/daily_status.pro");
system("/san_darts/solar/ssw/gen/setup/ssw_idl < $HOME/work/tmp/daily_status.pro");

############################################### PLOTS

# Now do the daily plots
# First write the IDL file

#$output = <<EOF;
#.comp $HOME/work/idl/eis_status_sts1_conversions
#eis_daily_plots,'$HOME/data/status/$darts_year_dir/$darts_month_dir/$darts_day_dir/','$HOME/work/tmp/','$end_date'
#exit
#EOF
#open(PLOT, "> $HOME/work/tmp/daily_plot.pro");
#print PLOT $output;
#close PLOT;

#print IDL, ".comp $HOME/work/idl/eis_daily_plots\n";
#print IDL, "'$HOME/work/localdata/sdtp/daily','$HOME/data/status/$darts_year_dir/$darts_month_dir/$darts_day_dir/'\n";

$output = <<EOF;
.comp $HOME/work/idl/eis_daily_plots
.comp $HOME/work/idl/eis_status_sts1_conversions
.comp $HOME/work/idl/eis_status_sts2_conversions
.comp $HOME/work/idl/eis_status_sts3_conversions
.comp $HOME/work/idl/eis_hk1_temperatures
eis_daily_plots,'$HOME/data/status/$darts_year_dir/$darts_month_dir/$darts_day_dir/','$HOME/work/tmp/','$end_date'
EOF
open(PLOT, "> $HOME/work/tmp/daily_plot.pro");
print PLOT $output;
close PLOT;

# Now start IDL and do the plots
#system("sswidl < $HOME/tmp/daily_plot.pro");
system("/san_darts/solar/ssw/gen/setup/ssw_idl < $HOME/work/tmp/daily_plot.pro");

############################################### PS -> PDF

# Now create pdf's out of the fits files
system("$HOME/bin/daily_pdfs $HOME/work/tmp $HOME/data/status/$darts_year_dir/$darts_month_dir/$darts_day_dir");

############################################### CCSDS MOVE

# TEMPORARY!
# Move the ccsds archives to the DARTS directory
system("/bin/mv $HOME/work/localdata/sdtp/daily/eis_* $HOME/data/status/$darts_year_dir/$darts_month_dir/$darts_day_dir");

############################################### COMPRESS

# Now gzip everything in the DARTS directory
system("gzip -f $HOME/data/status/$darts_year_dir/$darts_month_dir/$darts_day_dir/*");

############################################### CLEAN UP

# Now remove the trail of junk
system("/bin/rm $HOME/work/tmp/*pro");
