#!/usr/local/bin/perl

#
# This program is scheduled to run on pg1
#

#
# allband = 0xF1
# antenna = 0xF0 merge
#           0xF1 allant
#
# Base start time on the first usc contact of the day in the contacts file for the day
# (20061029_contacts.txt appears not to have any usc passes - thats because it was a
# sunday...)
# 20061101_contacts.txt msp1 is first real, so maybe look for first real contact time
# and use that as the start time. Also sundays do not have any real time contacts...
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

# Instead of die-ing would be better to report the error in a file somewhere
# and then exit. This applies to all instances of die of course. Todo.

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

open(MLOG, ">> $pipeline_log/pipeline_log.txt") || die "Can't open $pipeline_log/$pipeline_log.txt for writing: $!";
print MLOG scalar(localtime), " (JST) daily_merge_1 started ";

# The start time will either be passed in (interactive mode)
# or will be generated from cron using todays date minus 7 days

$state = "cron"; # Default to cron job

$ant='usc34';	# Not needed for merge as sdtp will substitute merge ant
$band=3;	# Merge telemetry
$mode='merge';	# Merge telemetry

# Set default values for start date, end date and start time to empty strings. If in
# interactive state these are not set then bail out.

$sdate = "";
$edate = "";
$stime = "";

# If there is anything on the command line then this is interactive mode

if($#ARGV != -1) {
    $state = "interactive";
    if(@ARGV) { $sdate  = shift; }
    if(@ARGV) { $edate  = shift; }
    if(@ARGV) { $stime 	= shift; }
    if(@ARGV) { $etime 	= shift; }
    #
    # Further options for re-processing just status or just mission data
    #
    die "No start date" if $sdate eq "";
    die "No end date"   if $edate eq "";
    die "No start time" if $stime eq "";
    $etime = $stime  if $etime eq "";

    $pipeline_mission_log = "$pipeline_log/daily_merge_1_log_$sdate";
    open(LOG, ">> $pipeline_mission_log") || die "Can't open $pipeline_mission_log for writing: $!";
    print LOG "Started (manually) ", scalar(localtime), " (JST)\n";
    print MLOG "manually: daily_merge_1 $sdate $edate $stime $etime\n";

    $syear  = substr($sdate, 0, 4);
    $smonth = substr($sdate, 4, 2);
    $sday   = substr($sdate, 6, 2);
}
else {
    # Never started by cron
}

# Split the start date into constituent parts
$year  = substr $sdate, 0, 4;
$month = substr $sdate, 4, 2;
$day   = substr $sdate, 6, 2;

$date_string = "$year$month$day";

############################################### 0 - CLEAR OLD DATA

stage_title(*LOG, $state, "Removing old data in $merge_dir");

# Remove old ccsds packets
perform(*LOG, $state, "cd $merge_dir && /bin/rm -f eis_md_2*");
perform(*LOG, $state, "cd $merge_dir && /bin/rm -f eis_sts*");
perform(*LOG, $state, "cd $merge_dir && /bin/rm -f eis_dmp*");

# Remove old decompressed ccsds packets
perform(*LOG, $state, "cd $merge_dir/decompressed && /bin/rm -f eis_md_2*");

# Remove old text files
perform(*LOG, $state, "/bin/rm -f $merge_dir/*.txt");

perform(*LOG, $state, "unset noclobber");


############################################### 1 - FETCH DATA

stage_title(*LOG, $state, "Fetching data");
#perform(*LOG, $state, "$HOME/bin/sdtp $mode $ant band=$band sdate=$sdate edate=$edate stime=$stime etime=$etime >&! $pipeline_log/md_fetch_$date_string.txt");
perform(*LOG, $state, "$HOME/bin/sdtp $mode $ant band=$band sdate=$sdate edate=$edate stime=$stime etime=$etime >& $pipeline_log" . "/md_fetch_" . "$date_string" . ".txt");

# Remove status files
perform(*LOG, $state, "/bin/rm $merge_dir/eis_sts*");


############################################### 2 - MISSION DATA CHECK

#print STDOUT scalar(localtime), " (JST) - Mission data check\n" if $state eq "interactive";
#print LOG "\n", scalar(localtime), " (JST) - Mission data check\n";

#system("$HOME/bin/pipeline_mdhdrs $merge_dir");
#####system("$HOME/bin/pipeline_ccsds_check $merge_dir");
#system("$HOME/bin/pipeline_ccsds $merge_dir");

#system("/bin/mv $merge_dir/hdrs.txt $HOME/data/mission/$year/$month/manual_hdrs.$year$month$day.txt");
#system("/bin/mv $merge_dir/ccsds.txt $HOME/data/mission/$year/$month/manual_ccsds.$year$month$day.txt");


############################################### 15 - CLEAN UP

#print STDOUT scalar(localtime), " (JST) - Cleaning up\n" if $state eq "interactive";
#print LOG "\n", scalar(localtime), " (JST) - Cleaning up\n";

#print LOG "\t/bin/rm $temp_idl/*pro\n";
#system("/bin/rm $temp_idl/*pro");

#print LOG "\t/bin/rm $temp_fits/*\n";
#system("/bin/rm $temp_fits/*");

#print LOG "\t/bin/rm $temp_plots/*\n";
#system("/bin/rm $temp_plots/*");


############################################### 16 - EXIT

pipeline_exit("mission");
