#!/usr/local/bin/perl

#
# This program is scheduled to run on pg1
#

#
# allband = 0xF1
# antenna = 0xF0 merge
#           0xF1 allant
#
# Base start time on the first usc contact of the day in the contacts file for the day
# (20061029_contacts.txt appears not to have any usc passes - thats because it was a
# sunday...)
# 20061101_contacts.txt msp1 is first real, so maybe look for first real contact time
# and use that as the start time. Also sundays do not have any real time contacts...
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

# Instead of die-ing would be better to report the error in a file somewhere
# and then exit. This applies to all instances of die of course. Todo.

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

open(MLOG, ">> $pipeline_log/pipeline_log.txt") || die "Can't open $pipeline_log/$pipeline_log.txt for writing: $!";
print MLOG scalar(localtime), " (JST) daily_merge_1 started ";

# The start time will either be passed in (interactive mode)
# or will be generated from cron using todays date minus 7 days

$state = "cron"; # Default to cron job

$ant='usc34';	# Not needed for merge as sdtp will substitute merge ant
$band=3;	# Merge telemetry
$mode='merge';	# Merge telemetry

# Set default values for start date, end date and start time to empty strings. If in
# interactive state these are not set then bail out.

$sdate = "";
$edate = "";
$stime = "";

# If there is anything on the command line then this is interactive mode

if($#ARGV != -1) {
    $state = "interactive";
    if(@ARGV) { $sdate  = shift; }
    if(@ARGV) { $edate  = shift; }
    if(@ARGV) { $stime 	= shift; }
    if(@ARGV) { $etime 	= shift; }
    #
    # Further options for re-processing just status or just mission data
    #
    die "No start date" if $sdate eq "";
    die "No end date"   if $edate eq "";
    die "No start time" if $stime eq "";
    $etime = $stime  if $etime eq "";

    $pipeline_mission_log = "$pipeline_log/daily_merge_1_log_$sdate";
    open(LOG, ">> $pipeline_mission_log") || die "Can't open $pipeline_mission_log for writing: $!";
    print LOG "Started (manually) ", scalar(localtime), " (JST)\n";
    print MLOG "manually: daily_merge_2 $sdate $edate $stime $etime\n";

    $syear  = substr($sdate, 0, 4);
    $smonth = substr($sdate, 4, 2);
    $sday   = substr($sdate, 6, 2);
}
else {
    # Never started by cron
}

# Split the start date into constituent parts
$year  = substr $sdate, 0, 4;
$month = substr $sdate, 4, 2;
$day   = substr $sdate, 6, 2;

$date_string = "$year$month$day";


############################################### 2 - MISSION DATA CHECK

stage_title(*LOG, $state, "Mission data check");

@files = `ls $merge_dir/ | grep eis_md`;
if(! @files) {
    log_msg(*LOG, $state, "No ccsds mission data files");
    pipeline_exit("mission");
}
$log_msg_str = "Number of files: " . @files;
log_msg(*LOG, $state, $log_msg_str);

# Do the mission data header dump, which also updates the engineering.txt file
perform(*LOG, $state, "$HOME/bin/pipeline_md_hdr_dump $merge_dir > $merge_dir/md_hdr_check.txt");

# Do the ccsds check which detects missing packets, updating missing_packets.txt
perform(*LOG, $state, "$HOME/bin/pipeline_ccsds_check $merge_dir > $merge_dir/ccsds_hdr_check.txt");


###system(      "$HOME/bin/pipeline_ccsds_check $merge_dir $sdate $edate $stime $etime > $merge_dir/ccsds_hdr_check.txt");

# Move the files to DARTS
perform(*LOG, $state, "/bin/mv $merge_dir/md_hdr_check.txt $darts_mission/$year/$month/packet_check/md_hdrs.$year$month$day.html");
perform(*LOG, $state, "/bin/mv $merge_dir/ccsds_hdr_check.txt $darts_mission/$year/$month/packet_check/ccsds_hdrs.$year$month$day.txt");
perform(*LOG, $state, "/bin/cp $shutter_log/shutter.txt $staging/logs/");

#
# For now, if there are any archives with missing packets move them to the incomplete directory.
# Must handle these more sensibly in the future.
#
$number_missing = 0;
if(-e "$merge_dir/missing_packets.txt") {
    log_msg(*LOG, $state, "Missing packet file exists");
    open(BAD, "< $merge_dir/missing_packets.txt");
    while(<BAD>) {
	next if /^Missing/;
	last if /^$/;
	chomp;
	# TEMP!!!!
#	print STDERR "[$_]\n";

	log_msg(*LOG, $state, "Moving $merge_dir/$_ to $merge_dir/incomplete/");
	perform(*LOG, $state, "/bin/mv $merge_dir/$_ $merge_dir/incomplete/");
	++$number_missing;
    }
    close BAD;
    perform(*LOG, $state, "/bin/mv $merge_dir/missing_packets.txt $darts_mission/$year/$month/packet_check/missing_packets.$year$month$day.txt");
    log_msg(*LOG, $state, "Number of missing archives: $number_missing");
}
else {
    log_msg(*LOG, $state, "No missing packet file");
}

#
# Check for and record those files which are continuations of previous files.
# The decompression stage will move these files aside.
#
if(-e "$merge_dir/headless_packets.txt") {
    log_msg(*LOG, $state, "Headless packets file exists");
#    open(BAD, "< $merge_dir/headless_packets.txt");
#    while(<BAD>) {
#	next if /^Headless/;
#	last if /^$/;
#	chomp;
#	log_msg(*LOG, $state, "Moving $merge_dir/$_ to $merge_dir/incomplete/");
#	perform(*LOG, $state, "/bin/mv $merge_dir/$_ $merge_dir/incomplete/");
#    }
#    close BAD;
    perform(*LOG, $state, "/bin/mv $merge_dir/headless_packets.txt $darts_mission/$year/$month/packet_check/headless_packets.$year$month$day.txt");
}
else {
    log_msg(*LOG, $state, "No headless packets file");
}
#
# Check for and record those files which are not complete.
# The decompression stage will move these files aside.
#
if(-e "$merge_dir/incomplete_packets.txt") {
    log_msg(*LOG, $state, "Incomplete packets file exists");
#    open(BAD, "< $merge_dir/headless_packets.txt");
#    while(<BAD>) {
#	next if /^Headless/;
#	last if /^$/;
#	chomp;
#	log_msg(*LOG, $state, "Moving $merge_dir/$_ to $merge_dir/incomplete/");
#	perform(*LOG, $state, "/bin/mv $merge_dir/$_ $merge_dir/incomplete/");
#    }
#    close BAD;
    perform(*LOG, $state, "/bin/mv $merge_dir/incomplete_packets.txt $darts_mission/$year/$month/packet_check/incomplete_packets.$year$month$day.txt");
}
else {
    log_msg(*LOG, $state, "No incomplete packets file");
}

perform(*LOG, $state, "/bin/mv $merge_dir/sequence_counts.txt $darts_mission/$year/$month/packet_check/sequence_counts_$year$month$day.txt");

# Get a count of number of mission data files here
#@pre_decompression = `ls $merge_dir/eis_md*`;
@pre_decompression = `ls $merge_dir/ | grep eis_md`;
print STDOUT "Number of compressed files: ", scalar(@pre_decompression), "\n" if $state eq "interactive";
print LOG  "\tNumber of compressed files: ", scalar(@pre_decompression), "\n";


############################################### 15 - CLEAN UP

#print STDOUT scalar(localtime), " (JST) - Cleaning up\n" if $state eq "interactive";
#print LOG "\n", scalar(localtime), " (JST) - Cleaning up\n";

#print LOG "\t/bin/rm $temp_idl/*pro\n";
#system("/bin/rm $temp_idl/*pro");

#print LOG "\t/bin/rm $temp_fits/*\n";
#system("/bin/rm $temp_fits/*");

#print LOG "\t/bin/rm $temp_plots/*\n";
#system("/bin/rm $temp_plots/*");


############################################### 16 - EXIT

pipeline_exit("mission");
