#!/usr/local/bin/perl

#
# This program is scheduled to run on pg1
#

#
# allband = 0xF1
# antenna = 0xF0 merge
#           0xF1 allant
#
# Base start time on the first usc contact of the day in the contacts file for the day
# (20061029_contacts.txt appears not to have any usc passes - thats because it was a
# sunday...)
# 20061101_contacts.txt msp1 is first real, so maybe look for first real contact time
# and use that as the start time. Also sundays do not have any real time contacts...
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

# Instead of die-ing would be better to report the error in a file somewhere
# and then exit. This applies to all instances of die of course. Todo.

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

open(MLOG, ">> $pipeline_log/pipeline_log.txt") || die "Can't open $pipeline_log/$pipeline_log.txt for writing: $!";
print MLOG scalar(localtime), " (JST) daily_merge_1 started ";

# The start time will either be passed in (interactive mode)
# or will be generated from cron using todays date minus 7 days

$state = "cron"; # Default to cron job

$ant='usc34';	# Not needed for merge as sdtp will substitute merge ant
$band=3;	# Merge telemetry
$mode='merge';	# Merge telemetry

# Set default values for start date, end date and start time to empty strings. If in
# interactive state these are not set then bail out.

$sdate = "";
$edate = "";
$stime = "";

# If there is anything on the command line then this is interactive mode

if($#ARGV != -1) {
    $state = "interactive";
    if(@ARGV) { $sdate  = shift; }
    if(@ARGV) { $edate  = shift; }
    if(@ARGV) { $stime 	= shift; }
    if(@ARGV) { $etime 	= shift; }
    #
    # Further options for re-processing just status or just mission data
    #
    die "No start date" if $sdate eq "";
    die "No end date"   if $edate eq "";
    die "No start time" if $stime eq "";
    $etime = $stime  if $etime eq "";

    $pipeline_mission_log = "$pipeline_log/daily_merge_1_log_$sdate";
    open(LOG, ">> $pipeline_mission_log") || die "Can't open $pipeline_mission_log for writing: $!";
    print LOG "Started (manually) ", scalar(localtime), " (JST)\n";
    print MLOG "manually: daily_merge_2 $sdate $edate $stime $etime\n";

    $syear  = substr($sdate, 0, 4);
    $smonth = substr($sdate, 4, 2);
    $sday   = substr($sdate, 6, 2);
}
else {
    # Never started by cron
    die;
}

# Split the start date into constituent parts
$year  = substr $sdate, 0, 4;
$month = substr $sdate, 4, 2;
$day   = substr $sdate, 6, 2;

$date_string = "$year$month$day";


############################################### 3 - MISSION DATA DECOMPRESS

#stage_title(*LOG, $state, "Mission data check");

$current_time = scalar(localtime);
print STDOUT $current_time, " (JST) - Starting mission data decompress\n" if $state eq "interactive";
print LOG "\n", $current_time, " (JST) - Starting mission data decompress\n";

print LOG "\t(IDL) eis_md_decomp_fix1_script,'$merge_dir', /merge\n";

$output = <<EOF;
.comp $local_idl/eis_ccsds_interface__define

;.comp $local_idl/eis_md_decomp
;.comp $local_idl/eis_md_decomp_script
;eis_md_decomp_script,'$merge_dir', /merge

.comp $local_idl/mdppmdctrecover
;;;.comp $local_idl/mdppmdctrecover_merge

;.comp $local_idl/eis_md_decomp_fix
;.comp $local_idl/eis_md_decomp_fix_script
;eis_md_decomp_fix_script,'$merge_dir', /merge

.comp $local_idl/eis_md_decomp_fix1
.comp $local_idl/eis_md_decomp_fix1_script
eis_md_decomp_fix1_script,'$merge_dir', /merge
EOF

open(MD_DECOMP, "> $temp_idl/md_decomp.pro");
print MD_DECOMP $output;
close MD_DECOMP;

# Start the mission data decompress

###$date_string  = "$year$month$day";

#system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/md_decomp.pro > /dev/null");
#system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/md_decomp.pro > $pipeline_log/md_decompress_$date_string.txt");
system("$HOME/ssw_idl < $temp_idl/md_decomp.pro > $pipeline_log/md_decompress_$date_string.txt");

#system("remove_decomp_junk");

# Copy the decompression record and logs to DARTS
log_msg(*LOG, $state, "/bin/cp $HOME/work/localdata/log/decompression/merge_decomp_record.txt $darts_staging/logs/decompression/");
system("/bin/cp $HOME/work/localdata/log/decompression/merge_decomp_record.txt $darts_staging/logs/decompression/");

#log_msg(*LOG, $state, "/bin/mv $pipeline_log/md_decompress_$date_string.txt $darts_staging/logs/decompression/");
#system("/bin/mv $pipeline_log/md_decompress_$date_string.txt $darts_staging/logs/decompression/");

log_msg(*LOG, $state, "$HOME/bin/slim.pl <  $pipeline_log/md_decompress_$date_string.txt > $darts_staging/logs/decompression/md_decompress_$date_string.txt");
system("$HOME/bin/slim.pl < $pipeline_log/md_decompress_$date_string.txt > $darts_staging/logs/decompression/md_decompress_$date_string.txt");

# Get a count of number of mission data files here
#@post_decompression = `ls $merge_dir/decompressed/eis_md*`;
@post_decompression = `ls $merge_dir/decompressed/ | grep eis_md`;
print STDOUT "Number of de-compressed files: ", scalar(@post_decompression), "\n" if $state eq "interactive";
print LOG  "\tNumber of de-compressed files: ", scalar(@post_decompression), "\n";


############################################### 16 - EXIT

pipeline_exit("mission");
