#!/usr/local/bin/perl

#
# This program is scheduled to run on pg4 by cron but can also be run from the command line.
#

#
# allband = 0xF1
# antenna = 0xF0 merge
#           0xF1 allant
#
# Base start time on the first usc contact of the day in the contacts file for the day
# (20061029_contacts.txt appears not to have any usc passes - thats because it was a
# sunday...)
# 20061101_contacts.txt msp1 is first real, so maybe look for first real contact time
# and use that as the start time. Also sundays do not have any real time contacts...
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

# Instead of die-ing would be better to report the error in a file somewhere
# and then exit. This applies to all instances of die of course. Todo.

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";


# Open the master pipeline log if we can.
open(MLOG, ">> $pipeline_log/pipeline_log.txt") || die "Can't open $pipeline_log/$pipeline_log.txt for writing: $!";
print MLOG scalar(localtime), " (JST) daily_merge_mission1 started ";

# The start time will either be passed in (interactive mode)
# or will be generated from cron using todays date minus some days

$state = "cron"; # Default to cron job

$ant='usc34';	# Not needed for merge as sdtp will substitute merge antenna
$band=3;	# Merge telemetry
$mode='merge';	# Merge telemetry

# Set default values for start date, end date and start time to empty strings. If in
# interactive state these are not set then bail out.

$sdate = "";
$edate = "";
$stime = "";

# If there is anything on the command line then this is interactive mode
if($#ARGV != -1) {
    $state = "interactive";
    #
    # Get any command line arguments (must be in this order)
    #
    if(@ARGV) { $sdate  = shift; }
    if(@ARGV) { $edate  = shift; }
    if(@ARGV) { $stime 	= shift; }
    if(@ARGV) { $etime 	= shift; }
    #
    # Simple check for arguments. Could test actual times but sdtp will catch errors
    #
    die "No start date" if $sdate eq "";
    die "No end date"   if $edate eq "";
    die "No start time" if $stime eq "";
    $etime = $stime     if $etime eq "";
    #
    # All set, open the local log, update the master log and off we go
    #
    $pipeline_mission_log = "$pipeline_log/pipeline_mission_log_$sdate";
    open(LOG, ">> $pipeline_mission_log") || die "Can't open $pipeline_mission_log for writing: $!";
    print LOG "Started (manually) ", scalar(localtime), " (JST)\n";
    print MLOG "manually: daily_merge_mission1 $sdate $edate $stime $etime\n";

    $syear  = substr($sdate, 0, 4);
    $smonth = substr($sdate, 4, 2);
    $sday   = substr($sdate, 6, 2);
}
else {
    die;
}


############################################### 4 - MISSION DATA REFORMAT

$current_time = scalar(localtime);
print STDOUT $current_time, " (JST) - Starting mission data reformat\n" if $state eq "interactive";
print LOG "\n", $current_time, " (JST) - Starting mission data reformat\n";
print LOG "\t(IDL) fits_script, '$merge_dir/decompressed/', '$temp_fits/'\n";

$translate_log_name = "md_translation" . "_$date_string" . ".txt";
$translate_log = "$pipeline_log/" . $translate_log_name;

$output = <<EOF;
.comp $local_idl/planning/jside_input/eis_read_orbit_events_reformatter
;;;;;;.comp $local_idl/eis_fits_calib
;;;.comp $local_idl/hw_help__define
.comp $local_idl/hw_data__define
.comp $local_idl/eis_data__define
.comp $local_idl/eis_data__readccsds
;;;.comp $local_idl/eis_data__readfits
;;;.comp $local_idl/eis_modfits
;;;.comp $local_idl/eis_mkfits
;;;.comp $local_idl/eis_fits_script
eis_fits_script,'$merge_dir/decompressed/', '$temp_fits/',logfile='$translate_log'
;eis_fits_script,'$merge_dir/decompressed/', '$temp_fits/',logfile='$HOME/work/localdata/log/merge/md_translation.txt'
;eis_fits_script,'$merge_dir/decompressed/', '$temp_fits/',logfile='$HOME/work/localdata/log/merge/md_translation.txt', /nospcd
EOF

open(MD_FITS, "> $temp_idl/md_fits.pro");
print MD_FITS $output;
close MD_FITS;

$reformat_log = "$pipeline_log/md_reformat" . "_$date_string" . ".txt";
#$reformat_log = "/dev/null";

#print  "/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/md_fits.pro >& $reformat_log\n";
#system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/md_fits.pro >& $reformat_log");
#print  "/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/md_fits.pro >& $reformat_log\n";
#system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/md_fits.pro >& $reformat_log");
perform(*LOG, $state, "$HOME/ssw_idl < $temp_idl/md_fits.pro >& $reformat_log");

perform(*LOG, $state, "/bin/cp $reformat_log $darts_staging/logs/md_reformat/");
perform(*LOG, $state, "/bin/cp $translate_log $darts_staging/logs/md_translation/");

# Get a count of number of mission data files here
#@post_reformat = `ls $temp_fits/eis_l0*`;
@post_reformat = `ls $temp_fits/ | grep eis_l0`;
print STDOUT "Number of reformatted files: ", scalar(@post_reformat), "\n" if $state eq "interactive";
print LOG  "\tNumber of reformatted files: ", scalar(@post_reformat), "\n";


############################################### 5 - UPDATE MD TRANSLATION DBASE

$current_time = scalar(localtime);
print STDOUT "$current_time (JST) - Update md translation database\n" if $state eq "interactive";
print LOG  "\n$current_time (JST) - Update md translation database\n";

# eis_mkfits writes all the ccsds packet filenames and the corresponding fits filenames processed
# to a text file. Open the text file and transfer the information to a perl database.

if(dbmopen(%trans, "$pipeline_log/mission_name_dbase", 0644)) {
    print STDOUT "mission_name_dbase opened\n" if $state eq "interactive";
    print LOG  "\tmission_name_dbase opened\n";
    if(open(REF_LOG, "< $translate_log")) {
	print STDOUT "Opened $translate_log ok\n" if $state eq "interactive";
	print LOG  "\tOpened $translate_log ok\n";
	while(<REF_LOG>) {
	    @files = split;		# Split ccsds filename and fits filename
	    $ccsds = $files[0];
	    $fits = $files[1];
	    $ccsds =~ s/ //g;		# Remove any white space from names
	    $fits =~ s/ //g;
	    chomp $fits;		# Remove newline if any
	    $trans{$ccsds} = $fits;
	    print LOG  "\tUpdating mission_name_database: $ccsds => $fits\n";
	    $temp{$ccsds} = $fits;
	}
	close(REF_LOG);
    }
    else {
	print STDOUT "Can't open $reformat_log: $!\n" if $state eq "interactive";
	print LOG  "\tCan't open $reformat_log: $!\n";
    }
    print STDOUT "Closing mission_name_dbase\n" if $state eq "interactive";
    print LOG  "\tClosing mission_name_dbase\n";
    if(dbmclose(%trans)) {
	print STDOUT "Closed mission_name_dbase ok\n" if $state eq "interactive";
	print LOG  "\tClosed mission_name_dbase ok\n";
    }
    else {
	print STDOUT "Closing mission_name_dbase failed: $!\n" if $state eq "interactive";
	print LOG  "\tClosing mission_name_dbase failed: $!\n";
    }
}
else {
    print STDOUT "Cannot open mission_name_dbase: $!\n" if $state eq "interactive";
    print LOG  "\tCannot open mission_name_dbase: $!\n";
}

# Copy the database to the staging area even if it was not updated
print STDOUT "/bin/cp $pipeline_log/mission_name_dbase $darts_staging/logs/\n" if $state eq "interactive";
print LOG  "\t/bin/cp $pipeline_log/mission_name_dbase $darts_staging/logs/\n";
system("/bin/cp $pipeline_log/mission_name_dbase $darts_staging/logs/");


############################################### 6 - COMPRESS

# Now gzip everything in the temporary fits directory
# before moving to the DARTS directories

$current_time = scalar(localtime);
print STDOUT $current_time, " (JST) - Gzip temporary fits files\n" if $state eq "interactive";
print LOG "\n", $current_time, " (JST) - Gzip temporary fits files\n";
print LOG "\tgzip -f $temp_fits/*\n";

system("cd $temp_fits && gzip -f *");

