#!/usr/bin/perl

#
# This program is scheduled to run on pg1
#

#
# allband = 0xF1
# antenna = 0xF0 merge
#           0xF1 allant
#
# Base start time on the first usc contact of the day in the contacts file for the day
# (20061029_contacts.txt appears not to have any usc passes - thats because it was a
# sunday...)
# 20061101_contacts.txt msp1 is first real, so maybe look for first real contact time
# and use that as the start time. Also sundays do not have any real time contacts...
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

# Instead of die-ing would be better to report the error in a file somewhere
# and then exit. This applies to all instances of die of course. Todo.

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

open(MLOG, ">> $pipeline_log/pipeline_log.txt") || die "Can't open $pipeline_log/$pipeline_log.txt for writing: $!";
print MLOG scalar(localtime), " (JST) daily_merge_9_plan started ";

# The start time will either be passed in (interactive mode)
# or will be generated from cron using todays date minus 7 days

$state = "cron"; # Default to cron job

$ant='usc34';	# Not needed for merge as sdtp will substitute merge ant
$band=3;	# Merge telemetry
$mode='merge';	# Merge telemetry

# Set default values for start date, end date and start time to empty strings. If in
# interactive state these are not set then bail out.

$sdate = "";
$edate = "";
$stime = "";

# If there is anything on the command line then this is interactive mode

if($#ARGV != -1) {
    $state = "interactive";
    if(@ARGV) { $sdate  = shift; }
    if(@ARGV) { $edate  = shift; }
    if(@ARGV) { $stime 	= shift; }
    if(@ARGV) { $etime 	= shift; }
    #
    # Further options for re-processing just status or just mission data
    #
    die "No start date" if $sdate eq "";
    die "No end date"   if $edate eq "";
    die "No start time" if $stime eq "";
    $etime = $stime  if $etime eq "";

    $pipeline_mission_log = "$pipeline_log/pipeline_mission_log_$sdate";
    open(LOG, ">> $pipeline_mission_log") || die "Can't open $pipeline_mission_log for writing: $!";
    print LOG "daily_merge_9 started (manually) ", scalar(localtime), " (JST)\n";
    print MLOG "manually for $sdate to $edate, start time $stime until $etime\n";
}
else {
    # Started by cron. Calculate start date, end date and start time
    @today = today();	# @today[0..6] = seconds,minutes,hours,day,month,year,day_of_week (0 = sunday)

    @start_day = other_date(@today,-7);		# Go back 7 days
    @next_day  = other_date(@today,-6);		# Go back 6 days
#    print "start_day = @start_day\n";
#    print "next_day  = @next_day\n";
    $syear  = sprintf "%04u", $start_day[5];	# Get starting year
    $smonth = sprintf "%02u", $start_day[4];	# Get starting month
    $sday   = sprintf "%02u", $start_day[3];	# Get starting day
    $eyear  = sprintf "%04u", $next_day[5];	# Get ending year
    $emonth = sprintf "%02u", $next_day[4];	# Get ending month
    $eday   = sprintf "%02u", $next_day[3];	# Get ending day
    
    $sdate = "$syear$smonth$sday";
    $edate = "$eyear$emonth$eday";
    
#    print "sdate = $sdate\n";
#    print "edate = $edate\n";

    open(LOG, ">> $pipeline_log/pipeline_log_$sdate") || die "Can't open $pipeline_log_$sdate for writing: $!";
    print LOG "Started ", scalar(localtime), " (JST)\n";

    # Get the date of the contact file we will parse to find the start time
    $parse_date = $sdate;

    # If sunday get previous start time and use that for today
    if($today[6] == 0) {	# Sunday
        print LOG "$sdate is Sunday, going back a day\n";
	@yesterday = other_date(@start_day,-1);
	$syear  = sprintf "%04u", $yesterday[5];	# Get starting year
	$smonth = sprintf "%02u", $yesterday[4];	# Get starting month
	$sday   = sprintf "%02u", $yesterday[3];	# Get starting day
	$parse_date = "$syear$smonth$sday";
    }
    
    # Parse contact file to get start time
    $src_file = $parse_date . "_contacts.txt";
    $file = `/bin/ls $pass_list_dir/$src_file`;
    if($file eq "") {
	print LOG "Can't open contact file for $sdate\n";
	pipeline_exit();
    }
    chomp $file;
    print LOG "Using contact file $file for $sdate\n";
    $line = "";
    open(PASS, "< $file") or die "Can't open contacts file\n";
    while(<PASS>) {
	if(/real/) {
	    chomp;
	    $line = $_;
	    last;
	}
    }
    if($line eq "") {
        print LOG "No start time\n";
        pipeline_exit();
    }

    # now get the start time by getting the time 16 characters in from the end of the line
    $stime = substr $line, -16, 4;
    $etime = $stime;
    print MLOG "by cron for $sdate to $edate, start time $stime until $etime\n";
}

# Split the start date into constituent parts
$year  = substr $sdate, 0, 4;
$month = substr $sdate, 4, 2;
$day   = substr $sdate, 6, 2;
$eyear  = substr $edate, 0, 4;
$emonth = substr $edate, 4, 2;
$eday   = substr $edate, 6, 2;


############################################### gunzip status files in DARTS
# unnecessary when fxbopen is updated and mission reformatter looks for gzip files

#system("gunzip $darts_status/$year/$month/$day/*");
#system("gunzip $darts_status/$eyear/$emonth/$eday/*");


############################################### 10 - MISSION DATA REFORMAT

print STDOUT scalar(localtime), " (JST) - Starting mission data reformat\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Starting mission data reformat\n";

print LOG "\t(IDL) fits_script, '$merge_dir/decompressed/', '$temp_fits/'\n";

$date_string  = "$year$month$day";
$translate_log_name = "md_translation" . "_$date_string" . ".txt";
$translate_log = "$pipeline_log/" . $translate_log_name;


$output = <<EOF;
;.comp $local_idl/eis_ti2utc
;.comp $local_idl/eis_fxbopen
;.comp $local_idl/eis_spcd__define
;;;;;;.comp $local_idl/eis_data__define
.comp $local_idl/hw_help__define
;.comp $local_idl/eis_data__readccsds
.comp $local_idl/eis_data__readfits
;.comp $local_idl/eis_plan__define
;.comp $local_idl/eis_fits_coord.pro
;.comp $local_idl/eis_find_directory
;.comp $local_idl/eistim2utc
;.comp $local_idl/eis_fits_obstime
;.comp $local_idl/eis_mk_fitsname
.comp $local_idl/eis_modfits.pro
.comp $local_idl/eis_mkfits
.comp $local_idl/eis_fits_script
;;eis_fits_script,'$merge_dir/decompressed/', '$temp_fits/',logfile='$HOME/work/localdata/log/merge/md_translation.txt'
;eis_fits_script,'$merge_dir/decompressed/', '$temp_fits/',logfile='$HOME/work/localdata/log/merge/md_translation.txt', /nospcd, /noplan, /noasrun
eis_fits_script,'$merge_dir/decompressed/', '$temp_fits/',logfile='$HOME/work/localdata/log/merge/md_translation.txt', /noplan, /noasrun
EOF
#eis_fits_script,'$merge_dir/decompressed/', '$temp_fits/',logfile='$HOME/work/localdata/log/merge/md_translation.txt', /doplan, /dospcd, /doasrun

open(MD_FITS, "> $temp_idl/md_fits.pro");
print MD_FITS $output;
close MD_FITS;

$date_string  = "$year$month$day";
$reformat_log = "$pipeline_log/md_reformat" . "_$date_string" . ".txt";

###print "/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/md_fits.pro > $pipeline_log/md_reformat.txt\n";
print "/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/md_fits.pro > $reformat_log\n";

#system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/md_fits.pro > /dev/null");

system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/md_fits.pro > $reformat_log");
#system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/md_fits.pro");

system("/bin/cp $reformat_log $darts_staging/logs/");

@post_reformat = `ls $temp_fits/eis_l0*`;
print STDOUT "Number of reformatted files: ", scalar(@post_reformat), "\n" if $state eq "interactive";
print LOG  "\tNumber of reformatted files: ", scalar(@post_reformat), "\n";

############################################### gzip status files in DARTS

#system("gzip -f $darts_status/$year/$month/$day/*");
#system("gzip -f $darts_status/$eyear/$emonth/$eday/*");

############################################### 5 - UPDATE MD TRANSLATION DBASE

$current_time = scalar(localtime);
print STDOUT $current_time, " (JST) - Update md translation database\n" if $state eq "interactive";
print LOG "\n", $current_time, " (JST) - Update md translation database\n";

# eis_mkfits writes all the ccsds packet filenames and the corresponding fits filenames processed
# to a text file. Open the text file and transfer the information to a perl database.

if(dbmopen(%trans, "$pipeline_log/mission_name_dbase", 0644)) {
    print STDOUT "mission_name_dbase opened\n" if $state eq "interactive";
    print LOG "mission_name_dbase opened\n";
    if(open(REF_LOG, "< $translate_log")) {
	print STDOUT "Opened $translate_log ok\n" if $state eq "interactive";
	print LOG "Opened $translate_log ok\n";
	while(<REF_LOG>) {
	    @files = split;
	    $ccsds = $files[0];
	    $fits = $files[1];
#	    ($ccsds, $fits) = split;
	    $ccsds =~ s/ //g;
	    $fits =~ s/ //g;
	    chomp $fits;
#	    print STDOUT "UPDATE: (ccsds,fits) = ($ccsds,$fits)\n";
	    print LOG "Updating mission_name_database: $ccsds => $fits\n";
	    $trans{$ccsds} = $fits;
	    $temp{$ccsds} = $fits;
	}
	close(REF_LOG);
    }
    else {
	print STDOUT "Can't open $reformat_log: $!\n" if $state eq "interactive";
	print LOG "Can't open $reformat_log: $!";
    }
    print STDOUT "Closing mission_name_dbase\n" if $state eq "interactive";
    print LOG  "\tClosing mission_name_dbase\n";
    if(dbmclose(%trans)) {
	print STDOUT "Closed mission_name_dbase ok\n" if $state eq "interactive";
	print LOG  "\tClosed mission_name_dbase ok\n";
    }
    else {
	print STDOUT "Closing mission_name_dbase failed: $!\n" if $state eq "interactive";
	print LOG  "\tClosing mission_name_dbase failed: $!\n";
    }
}
else {
    print STDOUT "Cannot open mission_name_dbase\n" if $state eq "interactive";
    print LOG "Cannot open mission_name_dbase\n";
}

# Copy the database to the staging area even if it was not updated
print STDOUT "/bin/cp $pipeline_log/mission_name_dbase $darts_staging/logs/\n" if $state eq "interactive";
print LOG  "\t/bin/cp $pipeline_log/mission_name_dbase $darts_staging/logs/\n";
system("/bin/cp $pipeline_log/mission_name_dbase $darts_staging/logs/");


############################################### 6 - COMPRESS

# Now gzip everything in the temporary fits directory
# before moving to the DARTS directories

$current_time = scalar(localtime);
print STDOUT $current_time, " (JST) - Gzip temporary fits files\n" if $state eq "interactive";
print LOG "\n", $current_time, " (JST) - Gzip temporary fits files\n";
print LOG "\tgzip -f $temp_fits/*\n";

system("gzip -f $temp_fits/*");


############################################### 7 - COPY ENGINEERING FILES TO CALIBRATION AREA


$current_time = scalar(localtime);
print STDOUT $current_time, " (JST) - Move engineering files to calibration area\n" if $state eq "interactive";
print LOG "\n", $current_time, " (JST) - Move engineering files to calibration area\n";

# If the engineering.txt file exists then there is engineering data to be dealt with.
# Use the ccsds packet filename from the engineering.txt file to look up in the translation
# log to get the fits filename and use the engineering study type information to copy the
# fits file to the calibration directory.

$eng_dbase = 0;
if((-e "$merge_dir/engineering.txt") || (-e "$HOME/data/mission/$year/$month/packet_check/engineering.$year$month$day.txt")) {
    $eng_file = "$merge_dir/engineering.txt" if -e "$merge_dir/engineering.txt";
    $eng_file = "$HOME/data/mission/$year/$month/packet_check/engineering.$year$month$day.txt" if -e "$HOME/data/mission/$year/$month/packet_check/engineering.$year$month$day.txt";
    print STDOUT "Engineering summary exists\n" if $state eq "interactive";
    print LOG "Engineering summary exists\n";
    $eng_dbase = 1 if(dbmopen(%eng_dbase, "$pipeline_log/engineering_name_dbase", 0644));
    if(dbmopen(%trans, "$pipeline_log/mission_name_dbase", undef)) {
#	if(open(ENG_LOG, "< $merge_dir/engineering.txt")) {
	if(open(ENG_LOG, "< $eng_file")) {
	    $line = <ENG_LOG>;				# Read title
	    while($line = <ENG_LOG>) {			# Read ccsds packet filename
		last if $line =~ /^$/;			# Finish on a blank line
		chop $line;				# Remove \n
		($path, $type) = split(/:/, $line);	# Get filename and type of engineering study
		print LOG "(path,type) = ($path, $type)\n";
		@path = split(/\//, $path);		# Split up filename path
		$ccsds_file = $path[-1];
#		$fits_file = $trans{$path[-1]};		# Get fits filename from ccsds filename
		$fits_file = $trans{$ccsds_file};	# Get fits filename from ccsds filename
		$fits_file = $temp{$ccsds_file};	# Get fits filename from ccsds filename
		if($fits_file) {
		    $eng_dbase{$fits_file} = $type if $eng_dbase;	# Update engineering database
		    $destination = eng_path($type);		# Get where to copy the fits file and copy it
		    $source = $temp_fits . "/"  . $fits_file . ".gz";
#		    system("/bin/cp $temp_fits/$fits_file.gz $destination") if($destination);
		    if($destination ne "") {
			$dest1 = "$darts_mission" . $destination;
			$dest2 = "$soda_darts_mission" . $destination;
			print STDOUT "Moving $source to $dest1\n" if $state eq "interactive";
			print LOG  "\tMoving $source to $dest1 and $dest2\n";
#			system("/bin/cp $source $dest1");
#			system("/bin/cp $source $dest2");
			system("/bin/cp $source $dest1");
			system("/bin/mv $source $dest2");
		    }
		}
		else {
		    print STDOUT "No translation found for $ccsds_file\n" if $state eq "interactive";
		    print LOG "No translation found for $ccsds_file\n";
		}
	    }
	    close(ENG_LOG);
	}
	dbmclose(%trans);
    }
    dbmclose(%eng_dbase) if($eng_dabse);
    if(-e "$merge_dir/engineering.txt") {
	system("/bin/mv $merge_dir/engineering.txt $HOME/data/mission/$year/$month/packet_check/engineering.$year$month$day.txt");
    }
}
else {
    print LOG "No engineering summary file\n";
}
# Copy the engineering database to the staging area even if it was not updated
print STDOUT "/bin/cp $pipeline_log/engineering_name_dbase $darts_staging/logs/\n" if $state eq "interactive";
print LOG  "\t/bin/cp $pipeline_log/engineering_name_dbase $darts_staging/logs/\n";
system("/bin/cp $pipeline_log/engineering_name_dbase $darts_staging/logs/");


############################################### 15 - CLEAN UP

#print STDOUT scalar(localtime), " (JST) - Cleaning up\n" if $state eq "interactive";
#print LOG "\n", scalar(localtime), " (JST) - Cleaning up\n";

print LOG "\t/bin/rm $temp_idl/*pro\n";
system("/bin/rm $temp_idl/*pro");

#print LOG "\t/bin/rm $temp_fits/*\n";
#system("/bin/rm $temp_fits/*");


pipeline_exit("mission");

