#!/usr/bin/perl

#
# This program is scheduled to run on pg1
#

#
# allband = 0xF1
# antenna = 0xF0 merge
#           0xF1 allant
#
# Base start time on the first usc contact of the day in the contacts file for the day
# (20061029_contacts.txt appears not to have any usc passes - thats because it was a
# sunday...)
# 20061101_contacts.txt msp1 is first real, so maybe look for first real contact time
# and use that as the start time. Also sundays do not have any real time contacts...
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

# Instead of die-ing would be better to report the error in a file somewhere
# and then exit. This applies to all instances of die of course. Todo.

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

open(MLOG, ">> $pipeline_log/pipeline_log.txt") || die "Can't open $pipeline_log/$pipeline_log.txt for writing: $!";
print MLOG scalar(localtime), " (JST) daily_merge_status started ";

# The start time will either be passed in (interactive mode)
# or will be generated from cron using todays date minus 7 days

$state = "cron"; # Default to cron job

$ant='usc34';	# Not needed for merge as sdtp will substitute merge ant
$band=3;	# Merge telemetry
$mode='merge';	# Merge telemetry

# Set default values for start date, end date and start time to empty strings. If in
# interactive state these are not set then bail out.

$sdate = "";
$edate = "";
$stime = "";

# If there is anything on the command line then this is interactive mode

if($#ARGV != -1) {
    $state = "interactive";
    if(@ARGV) { $sdate  = shift; }
    if(@ARGV) { $edate  = shift; }
    if(@ARGV) { $stime 	= shift; }
    #
    # Further options for re-processing just status or just mission data
    #
    die "No start date" if $sdate eq "";
    die "No end date"   if $edate eq "";
    die "No start time" if $stime eq "";
    $etime = $stime;
    open(LOG, ">> $pipeline_log/pipeline_log_$sdate") || die "Can't open $pipeline_log_$sdate for writing: $!";
    print LOG "Started (manually) ", scalar(localtime), " (JST)\n";
    print MLOG "manually for $sdate to $edate, start time $stime until $etime\n";
}
else {
    # Started by cron. Calculate start date, end date and start time
    @today = today();	# @today[0..6] = seconds,minutes,hours,day,month,year,day_of_week (0 = sunday)

    @start_day = other_date(@today,-5);		# Go back 5 days
    @next_day  = other_date(@today,-4);		# Go back 4 days
#    @start_day = other_date(@today,-4);		# Go back 4 days
#    @next_day  = other_date(@today,-3);		# Go back 3 days

    $syear  = sprintf "%04u", $start_day[5];	# Get starting year
    $smonth = sprintf "%02u", $start_day[4];	# Get starting month
    $sday   = sprintf "%02u", $start_day[3];	# Get starting day
    $eyear  = sprintf "%04u", $next_day[5];	# Get ending year
    $emonth = sprintf "%02u", $next_day[4];	# Get ending month
    $eday   = sprintf "%02u", $next_day[3];	# Get ending day
    
    $sdate = "$syear$smonth$sday";
    $edate = "$eyear$emonth$eday";
    
#    print "sdate = $sdate\n";
#    print "edate = $edate\n";

    $stime = '0000';
    $etime = $stime;

    open(LOG, ">> $pipeline_log/pipeline_log_$sdate") || die "Can't open $pipeline_log_$sdate for writing: $!";
    print LOG "Started ", scalar(localtime), " (JST)\n";

#    # Get the date of the contact file we will parse to find the start time
#    $parse_date = $sdate;
#
#    # If sunday get previous start time and use that for today
#    if($today[6] == 0) {	# Sunday
#	@yesterday = other_date(@today,-1);
#	$syear  = sprintf "%04u", $start_day[5];	# Get starting year
#	$smonth = sprintf "%02u", $start_day[4];	# Get starting month
#	$sday   = sprintf "%02u", $start_day[3];	# Get starting day
#	$parse_date = "$syear$smonth$sday";
#    }
#    
#    # Parse contact file to get start time
#    $src_file = $parse_date . "_contacts.txt";
#    $file = `/bin/ls $pass_list_dir/$src_file`;
#    if($file eq "") {
#	print LOG "Can't open contact file for $sdate\n";
#	pipeline_exit();
#    }
#    $line = "";
#    open(PASS, "< $file") or die "Can't open contacts file\n";
#    while(<PASS>) {
#	if(/real/) {
#	    chomp;
#	    $line = $_;
#	    last;
#	}
#    }
#    if($line eq "") {
#        print LOG "No start time\n";
#        pipeline_exit();
#    }
#
#    # now get the start time by getting the time 16 characters in from the end of the line
#    $stime = substr $line, -16, 4;
#    $etime = $stime;
    print MLOG "by cron for $sdate to $edate, start time $stime until $etime\n";
}

# Split the start date into constituent parts
$year  = substr $sdate, 0, 4;
$month = substr $sdate, 4, 2;
$day   = substr $sdate, 6, 2;

############################################### CLEAR OLD DATA

print STDOUT scalar(localtime), " (JST) - Removing old data in $merge_dir\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Removing old data in $merge_dir\n";

print LOG "\t/bin/rm -f $merge_dir/eis_*\n";
system("/bin/rm -f $merge_dir/eis_*");

#print LOG "\t/bin/rm -f $merge_dir/decompressed/eis_*\n";
#system("/bin/rm -f $merge_dir/decompressed/eis_*");


############################################### FETCH DATA

print STDOUT scalar(localtime), " (JST) - Fetching data\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Fetching data\n";

print LOG "\t$HOME/bin/sdtp $mode $ant band=$band sdate=$sdate edate=$edate stime=$stime etime=$etime\n";
system("$HOME/bin/sdtp $mode $ant band=$band sdate=$sdate edate=$edate stime=$stime etime=$etime");


############################################### DATA AVAILABLE CHECK

@files = `ls $merge_dir/eis*`;
if(! @files) {
    print STDOUT scalar(localtime), " (JST) - No ccsds files\n" if $state eq "interactive";
    print LOG "\n", scalar(localtime), " (JST) - No ccsds files\n";
    pipeline_exit();
}


############################################### STATUS REFORMAT

# Start the status fits reformatter

print STDOUT scalar(localtime), " (JST) - Starting status reformat\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Starting status reformat\n";

print LOG "\t(IDL) auto_mk_fits, '$merge_dir', '$temp_fits/'\n";

# Temporary .comps

#$output = <<EOF;
#.comp $local_idl/eis_ccsds_interface__define
#.comp $local_idl/eis_make_status_fits
#.comp $local_idl/eis_ti2utc
#.comp $local_idl/auto_mk_fits
#auto_mk_fits, '$merge_dir', '$temp_fits/'
#EOF

$output = <<EOF;
.comp $local_idl/eis_make_status_fits
auto_mk_fits, '$merge_dir', '$temp_fits/'
EOF

open(STAT_FITS, "> $temp_idl/status_fits.pro");
print STAT_FITS $output;
close STAT_FITS;

# Start the status reformatter

##system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/status_fits.pro");
###system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/status_fits.pro > /dev/null");
system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/status_fits.pro > $pipeline_log/sts_reformat.txt");


############################################### PS PLOTS

print STDOUT scalar(localtime), " (JST) - Starting daily plot\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Starting daily plot\n";

print LOG "\t(IDL) eis_daily_plots, '$temp_fits/','$temp_plots/'\n";

# Now do the daily plots

# Temporary .comps
###foreach $i (`ls $local_idl/eis_convert*.pro`) {
###    $foo .= ".comp $i\n";
###}
###$output = <<EOF;
###$foo
###.comp $local_idl/eis_get_daily_data
###.comp $local_idl/eis_daily_plots
###.comp $local_idl/eis_status_sts1_conversions
###.comp $local_idl/eis_status_sts2_conversions
###.comp $local_idl/eis_status_sts3_conversions
###.comp $local_idl/eis_hk1_temperatures
###eis_daily_plots,'$temp_fits/','$temp_plots/'
###EOF

# Temporary .comps
$output = <<EOF;
eis_daily_plots,'$temp_fits/','$temp_plots/'
EOF

open(PLOT, "> $temp_idl/daily_plot.pro");
print PLOT $output;
close PLOT;

# Now start IDL and do the plots
system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/daily_plot.pro");


############################################### PS -> PDF

# Now create pdfs out of the ps files

print STDOUT scalar(localtime), " (JST) - Converting ps to pdf and compressing\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Converting ps to pdf and compressing\n";

print LOG "\t$HOME/bin/daily_pdfs $temp_plots $temp_plots\n";
system("$HOME/bin/daily_pdfs $temp_plots $temp_plots");

print LOG "\tgzip -f $temp_plots/*pdf\n";
system("gzip -f $temp_plots/*pdf");


############################################### MOVE PDFS TO DARTS

print STDOUT scalar(localtime), " (JST) - Moving pdfs to DARTS\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Moving pdfs to DARTS\n";

print LOG "\t/bin/mkdir $darts_status/$year/$month/$day/plots\n";
system("/bin/mkdir $darts_status/$year/$month/$day/plots");

print LOG "\t/bin/mv $temp_plots/*gz $darts_status/$year/$month/$day/plots\n";
system("/bin/mv $temp_plots/*gz $darts_status/$year/$month/$day/plots");


############################################### 10 - COMPRESS TEMP FITS DIRECTORY FILES

# Now gzip everything in the temporary fits directory
# before moving to the DARTS directories
print STDOUT scalar(localtime), " (JST) - Gzip temporary fits files\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Gzip temporary fits files\n";

print LOG "\tgzip -f $temp_fits/*\n";

system("gzip -f $temp_fits/*");


############################################### MOVE STATUS FITS FILES TO DARTS

# Move the status fits files before mission data reformatting as the
# mission data reformatter looks for housekeeping date in the DARTS
# system. It also needs the status fits files to be un-gzipped. They
# will be gzipped up later in DARTS.

print STDOUT scalar(localtime), " (JST) - Moving status fits files to DARTS\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Moving status fits files to DARTS\n";

#
# Filenames:
#	eis_aocs1_yyyymmdd_hhmmss.fits
#	eis_hk1_yyyymmdd_hhmmss.fits
#	eis_hk2_yyyymmdd_hhmmss.fits
#	eis_sts1_yyyymmdd_hhmmss.fits
#	eis_sts2_yyyymmdd_hhmmss.fits
#	eis_sts3_yyyymmdd_hhmmss.fits
#

#@files = `ls $temp_fits/*fits`;
@files = `ls $temp_fits`;
foreach $file (@files) {
    next if $file =~ /eis_l0/;
    chomp $file;
    # Match destination directory with filename
    $index  = 10 if $file =~ /aocs/;
    $index  =  9 if $file =~ /sts/;
    $index  =  8 if $file =~ /hk/;
    $darts_year  = substr $file, $index, 4;
    $darts_month = substr $file, $index + 4, 2;
    $darts_day   = substr $file, $index + 6, 2;

#    print LOG "\t/bin/mv $temp_fits/$file $darts_status/$darts_year/$darts_month/$darts_day/ccsds\n";
#    system("/bin/mv $temp_fits/$file $darts_status/$darts_year/$darts_month/$darts_day/ccsds");
    print LOG "\t/bin/cp $temp_fits/$file $darts_status/$darts_year/$darts_month/$darts_day\n";
    system("/bin/cp $temp_fits/$file $darts_status/$darts_year/$darts_month/$darts_day/");
}


############################################### GRID FTP

print STDOUT scalar(localtime), " (JST) - Starting gridFTP session\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Starting gridFTP session\n";

###@files = `ls $temp_fits`;
@files = `ls $darts_status/$darts_year/$darts_month/$darts_day/`;
foreach $file (@files) {
    chomp $file;
    print LOG "\tgridFTP $file\n";
}


############################################### COMPRESS STATUS FITS FILES IN DARTS

#print STDOUT scalar(localtime), " (JST) - Compress status fits files in DARTS\n" if $state eq "interactive";
#print LOG "\n", scalar(localtime), " (JST) - Compress status fits files in DARTS\n";
#
## The fits files in the temp_fits directory have been compressed but not the ones in DARTS.
## Get a listing of the temp_fits directory and substitute the .gz with nothing
#
#@files = `ls $temp_fits`;
#foreach $file (@files) {
#    next if $file =~ /eis_l0/;
#    chomp $file;
#    # Match destination directory with filename
#    $index  = 10 if $file =~ /aocs/;
#    $index  =  9 if $file =~ /sts/;
#    $index  =  8 if $file =~ /hk/;
#    $darts_year  = substr $file, $index, 4;
#    $darts_month = substr $file, $index + 4, 2;
#    $darts_day   = substr $file, $index + 6, 2;
#
#    $file =~ s/\.gz//;
#
#    print LOG "\tgzip -f $darts_status/$darts_year/$darts_month/$darts_day/$file\n";
#    system("gzip -f $darts_status/$darts_year/$darts_month/$darts_day/$file");
#}


############################################### CCSDS MOVE TO DARTS

# TEMPORARY!

# Move the ccsds status and memory dump archives to the DARTS directory
print STDOUT scalar(localtime), " (JST) - Copying status ccsds files to DARTS (TEMPORARY)\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Copying status ccsds files to DARTS (TEMPORARY)\n";

print LOG "\tgzip -f $merge_dir/eis_sts*\n";
system("gzip -f $merge_dir/eis_sts*");

print LOG "\tgzip -f $merge_dir/eis_dmp*\n";
system("gzip -f $merge_dir/eis_dmp*");

print LOG "\t/bin/mkdir $darts_status/$year/$month/$day/ccsds\n";
system("/bin/mkdir $darts_status/$year/$month/$day/ccsds");

print LOG "\t/bin/mv $merge_dir/eis_sts* $darts_status/$year/$month/$day/ccsds\n";
system("/bin/mv $merge_dir/eis_sts* $darts_status/$year/$month/$day/ccsds");

print LOG "\t/bin/mv $merge_dir/eis_dmp* $darts_status/$year/$month/$day/ccsds\n";
system("/bin/mv $merge_dir/eis_dmp* $darts_status/$year/$month/$day/ccsds");


############################################### CLEAN UP

print STDOUT scalar(localtime), " (JST) - Cleaning up\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Cleaning up\n";

print LOG "\t/bin/rm $temp_idl/*pro\n";
system("/bin/rm $temp_idl/*pro");

print LOG "\t/bin/rm $temp_fits/*\n";
system("/bin/rm $temp_fits/*");

print LOG "\t/bin/rm $temp_plots/*\n";
system("/bin/rm $temp_plots/*");

print LOG "\t/bin/rm $merge_dir/eis_md*\n";
system("/bin/rm $merge_dir/eis_md*");


############################################### EXIT

pipeline_exit();


#sub pipeline_exit {
#
#    print LOG "---------\n\n";
#    close LOG;
#
#    print MLOG scalar(localtime), " (JST) finished.\n";
#    print MLOG "---------\n\n";
#    close MLOG;
#
#    system("/bin/cp $pipeline_log/pipeline_log.txt $staging");
#
#    exit 0;
#}
