#!/usr/bin/perl

#
# This program is scheduled to run on pg1
#

#
# allband = 0xF1
# antenna = 0xF0 merge
#           0xF1 allant
#
# Base start time on the first usc contact of the day in the contacts file for the day
# (20061029_contacts.txt appears not to have any usc passes - thats because it was a
# sunday...)
# 20061101_contacts.txt msp1 is first real, so maybe look for first real contact time
# and use that as the start time. Also sundays do not have any real time contacts...
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

# Instead of die-ing would be better to report the error in a file somewhere
# and then exit. This applies to all instances of die of course. Todo.

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

open(MLOG, ">> $pipeline_log/pipeline_log.txt") || die "Can't open $pipeline_log/$pipeline_log.txt for writing: $!";
print MLOG scalar(localtime), " (JST) started ";

# The start time will either be passed in (interactive mode)
# or will be generated from cron using todays date minus 7 days

$ant='usc34';	# Not needed for merge as sdtp will substitute merge ant
$band=3;	# Merge telemetry
$mode='merge';	# Merge telemetry

# Set default values for start date, end date and start time to empty strings. If in
# interactive state these are not set then bail out.

$sdate = "";
$edate = "";
$stime = "";

# If there is anything on the command line then this is interactive mode

if($#ARGV != -1) {
    $state = "interactive";
    if(@ARGV) { $sdate  = shift; }
    if(@ARGV) { $edate  = shift; }
    if(@ARGV) { $stime 	= shift; }
    #
    # Further options for re-processing just status or just mission data
    #
    die "No start date" if $sdate eq "";
    die "No end date"   if $edate eq "";
    die "No start time" if $stime eq "";
    $etime = $stime;
    open(LOG, ">> $pipeline_log/pipeline_log_$sdate") || die "Can't open $pipeline_log_$sdate for writing: $!";
    print LOG "Started (manually) ", scalar(localtime), " (JST)\n";
    print MLOG "manually for $sdate to $edate, start time $stime until $etime\n";
}
else {
    
    # Parse contact file to get start time
    $src_file = $parse_date . "_contacts.txt";
    $file = `/bin/ls $pass_list_dir/$src_file`;
    if($file eq "") {
	print LOG "Can't open contact file for $sdate\n";
	pipeline_exit();
    }
    chomp $file;
    print LOG "Using contact file $file for $sdate\n";
    $line = "";
    open(PASS, "< $file") or die "Can't open contacts file\n";
    while(<PASS>) {
	if(/real/) {
	    chomp;
	    $line = $_;
	    last;
	}
    }
    if($line eq "") {
        print LOG "No start time\n";
        pipeline_exit();
    }

    # now get the start time by getting the time 16 characters in from the end of the line
    $stime = substr $line, -16, 4;
    $etime = $stime;
    print MLOG "by cron for $sdate to $edate, start time $stime until $etime\n";
}

# Split the start date into constituent parts
$year  = substr $sdate, 0, 4;
$month = substr $sdate, 4, 2;
$day   = substr $sdate, 6, 2;

############################################### CLEAR OLD DATA

print STDOUT scalar(localtime), " (JST) - Removing old data in $merge_dir\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Removing old data in $merge_dir\n";

print LOG "\t/bin/rm -f $merge_dir/eis_*\n";
system("/bin/rm -f $merge_dir/eis_*");

print LOG "\t/bin/rm -f $merge_dir/decompressed/eis_*\n";
system("/bin/rm -f $merge_dir/decompressed/eis_*");


############################################### FETCH DATA

print STDOUT scalar(localtime), " (JST) - Fetching data\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Fetching data\n";

print LOG "\t$HOME/bin/sdtp $mode $ant band=$band sdate=$sdate edate=$edate stime=$stime etime=$etime\n";
system("$HOME/bin/sdtp $mode $ant band=$band sdate=$sdate edate=$edate stime=$stime etime=$etime");


############################################### STATUS REFORMAT

# Start the status fits reformatter

print STDOUT scalar(localtime), " (JST) - Starting status reformat\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Starting status reformat\n";

print LOG "\t(IDL) auto_mk_fits, '$merge_dir', '$temp_fits/'\n";

# Temporary .comps

$output = <<EOF;
.comp $local_idl/eis_ccsds_interface__define
.comp $local_idl/eis_make_status_fits
.comp $local_idl/eis_ti2utc
.comp $local_idl/auto_mk_fits
auto_mk_fits, '$merge_dir', '$temp_fits/'
EOF

open(STAT_FITS, "> $temp_idl/status_fits.pro");
print STAT_FITS $output;
close STAT_FITS;

# Start the status reformatter

system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/status_fits.pro > /dev/null");


############################################### PS PLOTS

print STDOUT scalar(localtime), " (JST) - Starting daily plot\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Starting daily plot\n";

print LOG "\t(IDL) eis_daily_plots, '$temp_fits/','$temp_plots/'\n";

# Now do the daily plots

# Temporary .comps
###foreach $i (`ls $local_idl/eis_convert*.pro`) {
###    $foo .= ".comp $i\n";
###}
###$output = <<EOF;
###$foo
###.comp $local_idl/eis_get_daily_data
###.comp $local_idl/eis_daily_plots
###.comp $local_idl/eis_status_sts1_conversions
###.comp $local_idl/eis_status_sts2_conversions
###.comp $local_idl/eis_status_sts3_conversions
###.comp $local_idl/eis_hk1_temperatures
###eis_daily_plots,'$temp_fits/','$temp_plots/'
###EOF

###open(PLOT, "> $temp_idl/daily_plot.pro");
###print PLOT $output;
###close PLOT;

# Now start IDL and do the plots
###system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/daily_plot.pro");


############################################### PS -> PDF

# Now create pdfs out of the ps files

print STDOUT scalar(localtime), " (JST) - Converting ps to pdf and compressing\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Converting ps to pdf and compressing\n";

print LOG "\t$HOME/bin/daily_pdfs $temp_plots $temp_plots\n";
###system("$HOME/bin/daily_pdfs $temp_plots $temp_plots");

print LOG "\tgzip -f $temp_plots/*pdf\n";
###system("gzip -f $temp_plots/*pdf");


############################################### MOVE PDFS TO DARTS

print STDOUT scalar(localtime), " (JST) - Moving pdfs to DARTS\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Moving pdfs to DARTS\n";

print LOG "\t/bin/mv $temp_plots/*gz $darts_status/$year/$month/$day\n";
###system("/bin/mv $temp_plots/*gz $darts_status/$year/$month/$day");


############################################### COPY STATUS FITS FILES TO DARTS

# Copy the status fits files before mission data reformatting as the
# mission data reformatter looks for housekeeping date in the DARTS
# system. It also needs the status fits files to be un-gzipped. They
# will be gzipped up later in DARTS.

print STDOUT scalar(localtime), " (JST) - Moving status fits files to DARTS\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Moving status fits files to DARTS\n";

#
# Filenames:
#	eis_aocs1_yyyymmdd_hhmmss.fits
#	eis_hk1_yyyymmdd_hhmmss.fits
#	eis_hk2_yyyymmdd_hhmmss.fits
#	eis_sts1_yyyymmdd_hhmmss.fits
#	eis_sts2_yyyymmdd_hhmmss.fits
#	eis_sts3_yyyymmdd_hhmmss.fits
#

@files = `ls $temp_fits`;
foreach $file (@files) {
    next if $file =~ /eis_l0/;
    chomp $file;
    # Match destination directory with filename
    $index  = 10 if $file =~ /aocs/;
    $index  =  9 if $file =~ /sts/;
    $index  =  8 if $file =~ /hk/;
    $darts_year  = substr $file, $index, 4;
    $darts_month = substr $file, $index + 4, 2;
    $darts_day   = substr $file, $index + 6, 2;

    print LOG "\t/bin/cp $temp_fits/$file $darts_status/$darts_year/$darts_month/$darts_day/\n";
    system("/bin/cp $temp_fits/$file $darts_status/$darts_year/$darts_month/$darts_day/");
}

goto skip_md_reformat;

=pod
############################################### MISSION DATA DECOMPRESS

print STDOUT scalar(localtime), " (JST) - Starting mission data decompress\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Starting mission data decompress\n";

print LOG "\t(IDL) eis_md_decomp_script,'$merge_dir', /merge\n";

$output = <<EOF;
.comp $local_idl/eis_ccsds_interface__define
.comp $local_idl/eis_md_decomp
.comp $local_idl/eis_md_decomp_script
eis_md_decomp_script,'$merge_dir', /merge
EOF

open(MD_DECOMP, "> $temp_idl/md_decomp.pro");
print MD_DECOMP $output;
close MD_DECOMP;

# Start the mission data decompress

system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/md_decomp.pro > /dev/null");


############################################### MISSION DATA REFORMAT

print STDOUT scalar(localtime), " (JST) - Starting mission data reformat\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Starting mission data reformat\n";

print LOG "\t(IDL) fits_script, '$merge_dir/decompressed/', '$temp_fits/'\n";

# Temp compiles

$output = <<EOF;
.comp $local_idl/eis_ti2utc
.comp $local_idl/eis_find_directory
.comp $local_idl/eis_plan__define
.comp $local_idl/eis_cal__define
.comp $local_idl/eis_fits_dataid
.comp $local_idl/eis_fits_obstime
.comp $local_idl/eis_spcd__define
.comp $local_idl/eis_mkfits
.comp $local_idl/fits_script
fits_script,'$merge_dir/decompressed/', '$temp_fits/',logfile='$HOME/work/localdata/log/merge/md_translation.txt'
EOF

open(MD_FITS, "> $temp_idl/md_fits.pro");
print MD_FITS $output;
close MD_FITS;

system("/san_darts/solar/ssw/gen/setup/ssw_idl < $temp_idl/md_fits.pro > /dev/null");


############################################### COMPRESS

# Now gzip everything in the temporary fits directory
# before moving to the DARTS directories
print STDOUT scalar(localtime), " (JST) - Gzip temporary fits files\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Gzip temporary fits files\n";

print LOG "\tgzip -f $temp_fits/*\n";

system("gzip -f $temp_fits/*");


############################################### COPY MISSION FITS TO DARTS

print STDOUT scalar(localtime), " (JST) - Moving mission data fits files to DARTS\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Moving mission data fits files to DARTS\n";

#
# Filenames:
#	eis_l0_yyyymmdd_hhmmss.fits
#

@files = `ls $temp_fits`;
foreach $file (@files) {
    next if !($file =~ /l0/);
    chomp $file;
    # Match destination directory with filename
    $darts_year  = substr $file,  7, 4;
    $darts_month = substr $file, 11, 2;
    $darts_day   = substr $file, 13, 2;

    print LOG "\t/bin/cp $temp_fits/$file $darts_mission/$darts_year/$darts_month/$darts_day/\n";
    system("/bin/cp $temp_fits/$file $darts_mission/$darts_year/$darts_month/$darts_day/");
}


############################################### GRID FTP

print STDOUT scalar(localtime), " (JST) - Starting gridFTP session\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Starting gridFTP session\n";

@files = `ls $temp_fits`;
foreach $file (@files) {
    chomp $file;
    print LOG "\tgridFTP $temp_fits/$file\n";
}

=cut

skip_md_reformat:

############################################### COMPRESS STATUS FITS FILES IN DARTS

print STDOUT scalar(localtime), " (JST) - Compress status fits files in DARTS\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Compress status fits files in DARTS\n";

# The fits files in the temp_fits directory have been compressed but not the ones in DARTS.
# Get a listing of the temp_fits directory and substitute the .gz with nothing

@files = `ls $temp_fits`;
foreach $file (@files) {
    next if $file =~ /eis_l0/;
    chomp $file;
    # Match destination directory with filename
    $index  = 10 if $file =~ /aocs/;
    $index  =  9 if $file =~ /sts/;
    $index  =  8 if $file =~ /hk/;
    $darts_year  = substr $file, $index, 4;
    $darts_month = substr $file, $index + 4, 2;
    $darts_day   = substr $file, $index + 6, 2;

    $file =~ s/\.gz//;

    print LOG "\tgzip -f $darts_status/$darts_year/$darts_month/$darts_day/$file\n";
    system("gzip -f $darts_status/$darts_year/$darts_month/$darts_day/$file");
}


############################################### CCSDS MOVE TO DARTS

# TEMPORARY!
# Move the ccsds status and memory dump archives to the DARTS directory
print STDOUT scalar(localtime), " (JST) - Copying status ccsds files to DARTS (TEMPORARY)\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Copying status ccsds files to DARTS (TEMPORARY)\n";

print LOG "\tgzip -f $merge_dir/eis_sts*\n";
system("gzip -f $merge_dir/eis_sts*");

print LOG "\tgzip -f $merge_dir/eis_dmp*\n";
system("gzip -f $merge_dir/eis_dmp*");

print LOG "\t/bin/cp $merge_dir/eis_sts* $darts_status/$year/$month/$day\n";
system("/bin/cp $merge_dir/eis_sts* $darts_status/$year/$month/$day");

print LOG "\t/bin/cp $merge_dir/eis_dmp* $darts_status/$year/$month/$day\n";
system("/bin/cp $merge_dir/eis_dmp* $darts_status/$year/$month/$day");


############################################### CLEAN UP

print STDOUT scalar(localtime), " (JST) - Cleaning up\n" if $state eq "interactive";
print LOG "\n", scalar(localtime), " (JST) - Cleaning up\n";

print LOG "\t/bin/rm $temp_idl/*pro\n";
system("/bin/rm $temp_idl/*pro");

print LOG "\t/bin/rm $temp_fits/*\n";
system("/bin/rm $temp_fits/*");

print LOG "\t/bin/rm $temp_plots/*\n";
system("/bin/rm $temp_plots/*");


############################################### EXIT

pipeline_exit();


sub pipeline_exit {

    print LOG "---------\n\n";
    close LOG;

    print MLOG scalar(localtime), " (JST) finished.\n";
    print MLOG "---------\n\n";
    close MLOG;

    exit 0;
}
