#!/usr/bin/perl

#
# allband = 0xF1
# antenna = 0xF0 merge
#           0xF1 allant
#


#use Env qw(HOME);
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl" || warn "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

$HOME="/san_solar/disk2/home/sbukeis";
$fits_dir = "$HOME/work/tmp/fits";

# The start time will either be passed in or will be generated from time now - 1 (day) (or maybe 2)

system("/bin/rm -f $HOME/work/localdata/sdtp/daily/eis_* $fits_dir/* $HOME/work/tmp/daily/*");

#$sdate="20061024";	# Start date of telemetry
#$edate="20061025";	# End date
$sdate="";	# Start date of telemetry
$edate="";	# End date

$ant='usc34';
#$ant='allant';
#$ant='msp1';
#$ant='usc20';
#$ant='gna';
#$ant='gnb';
#$ant='merge';

#$band=1;	# S
$band=2;	# X
#$band=3;	# Merge

$mode='daily';

#print STDERR "Checking for args ", $#ARGV, "\n";

if($#ARGV != -1) {
    if(@ARGV) { $sdate = shift; }
    if(@ARGV) { $edate = shift; }
    if(@ARGV) { $ant   = shift; }
    if(@ARGV) { $band  = shift; }
    if(@ARGV) { $mode  = shift; }
}

die if $sdate eq "";
die if $edate eq "";

#print STDERR "sdate = $sdate\n";
#print STDERR "edate = $edate\n";

# Start times
@stimes=('0000','0130','0300','0430','0600','0730','0900','1030','1200','1330','1500','1630','1800','1930','2100');

# End times
@etimes=('0130','0300','0430','0600','0730','0900','1030','1200','1330','1500','1630','1800','1930','2100','2230');

# Index into end times array
$index = 0;

# Whizz through the start times array and fetch status telemetry
foreach $start (@stimes) {
    print STDERR "$HOME/bin/sdtp $mode $ant band=$band sdate=$sdate edate=$sdate stime=$start etime=$etimes[$index]\n";
    system("$HOME/bin/sdtp $mode $ant band=$band sdate=$sdate edate=$sdate stime=$start etime=$etimes[$index]");
#    system("$HOME/bin/sdtp daily $ant band=$band sdate=$sdate edate=$sdate stime=$start etime=$etimes[$index]");
    ++$index;
}

# Last one uses the edate (next day)
#system("$HOME/bin/sdtp daily $ant band=$band sdate=$sdate edate=$edate stime=2230 etime=0000");
print STDERR "$HOME/bin/sdtp $mode $ant band=$band sdate=$sdate edate=$sdate stime=$start etime=$etimes[$index]\n";
system("$HOME/bin/sdtp $mode $ant band=$band sdate=$sdate edate=$edate stime=2230 etime=0000");

@files = `ls $HOME/work/localdata/sdtp/daily/eis_*`;
die "No ccsds files" unless @files;

#
## Now start the status fits reformatter
#
$output = <<EOF;
.comp $local_idl/eis_status_parameter__define
.comp $local_idl/eis_make_status_fits
;.comp $local_idl/eis_ti2utc
;.comp $local_idl/auto_mk_fits
auto_mk_fits,'$HOME/localdata/sdtp/daily','$fits_dir/'
EOF

open(STAT_FITS, "> $HOME/work/tmp/daily/daily_status.pro") or die "Can't open daily_status.pro: $!\n" ;
print STAT_FITS $output;
close STAT_FITS;
system("/san_darts/solar/ssw/gen/setup/ssw_idl < $HOME/work/tmp/daily/daily_status.pro > /dev/null");

#
### Now do the daily plots
$output = <<EOF;
eis_daily_plots,'$fits_dir/','$HOME/work/tmp/daily/'
EOF
open(PLOT, "> $HOME/work/tmp/daily/daily_plot.pro");
print PLOT $output;
close PLOT;

system("sswidl < $HOME/work/tmp/daily/daily_plot.pro");

### Now create pdf's out of the fits files
system("$HOME/bin/daily_pdfs $HOME/work/tmp/daily $HOME/work/tmp/daily");

### Now gzip the fits data files
system("gzip $HOME/work/tmp/daily/*pdf");

### Copy to darts
system("/bin/cp $HOME/work/tmp/daily/*pdf.gz $HOME/data/staging/daily");

### Now remove the trail of junk
#system("bin/rm $HOME/tmp/*pdf");
