/**************************************
 *
 *  MdpPMdctRecover
 *
 *    2001/07/24  created
 **************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <cfortran.h>
#include <hbook.h>
#include <cli.h>
#include <com.h>
#include <bnk.h>
#include <evs.h>
#include <anl.h>
#include <anl_misc.h>

#define MODULE "MdpPMdctRecover:"

char MdpPMdctRecover_version[] = "version 010724";

void MdpPMdctRecover_init   (int *status){ 
  EvsDef( MODULE "RECOVER:QTABLE" );
  EvsDef( MODULE "RECOVER:DPCM" );
  EvsDef( MODULE "RECOVER:DCT" );
  *status = ANL_OK; 
}

void MdpPMdctRecover_ana(int nevent, int eventid, int *status)
{
  unsigned char *cmpimg;     int cmpimg_len;
  unsigned char *gnd_mdphdr; int gnd_mdphdr_len;
  int comp_code, dctbl, dpcm12, dct12;
  int size,i;
  
  BnkfGetM("GND:MDPHDR",      sizeof(gnd_mdphdr),      &size, &gnd_mdphdr);
  BnkfGetM("GND:MDPHDR_LEN",  sizeof(gnd_mdphdr_len),  &size, &gnd_mdphdr_len);

  BnkfGetM("GND:CMPIMG",       sizeof(cmpimg),     &size, &cmpimg);
  BnkfGetM("GND:CMPIMG_LEN",   sizeof(cmpimg_len), &size, &cmpimg_len);

  comp_code = (gnd_mdphdr[30] << 8) + (gnd_mdphdr[31] << 0);
  dctbl  = ((comp_code >> 3) & 3) ;
  dpcm12 = ((comp_code >> 8) & 7) == 0x3;
  dct12  = ((comp_code >> 8) & 7) == 0x7;

  if( dct12 ){
      if( (cmpimg[0x06] & 0x04) && (cmpimg[0x99] & 0x04) ){
	EvsSet( MODULE "RECOVER:QTABLE" );
	cmpimg[0x06] &= 0xfb;
	cmpimg[0x99] &= 0xfb;
      }
  }

  if( (dpcm12 || dct12) && (dctbl == 0 || dctbl == 2)){
    if( dpcm12 ){
      EvsSet( MODULE "RECOVER:DPCM" );
      memmove(cmpimg+0x3a, cmpimg+0x36, cmpimg_len-0x36);

      cmpimg[0x18] = 0x23;
      cmpimg[0x23] = 0x01;
      cmpimg[0x24] = 0x01;
      cmpimg[0x25] = 0x01;
      cmpimg[0x26] = 0x01;
      cmpimg[0x36] = 0x0c;
      cmpimg[0x37] = 0x0d;
      cmpimg[0x38] = 0x0e;
      cmpimg[0x39] = 0x0f;
    }
    if( dct12 ){
      EvsSet( MODULE "RECOVER:DCT" );
      memmove(cmpimg+0xbf, cmpimg+0xbb, cmpimg_len-0xbb);

      cmpimg[0x9d] = 0x26;
      cmpimg[0xa8] = 0x01;
      cmpimg[0xa9] = 0x01;
      cmpimg[0xaa] = 0x01;
      cmpimg[0xab] = 0x01;
      cmpimg[0xbb] = 0x0c;
      cmpimg[0xbc] = 0x0d;
      cmpimg[0xbd] = 0x0e;
      cmpimg[0xbe] = 0x0f;
    }

    cmpimg_len += 4;

    BnkfPutM("GND:CMPIMG_LEN",   sizeof(cmpimg_len), &cmpimg_len);
  }
  *status = ANL_OK;
}


void MdpPMdctRecover_startup(int *status){ *status = ANL_OK; }
void MdpPMdctRecover_com    (int *status){ *status = ANL_OK; }
void MdpPMdctRecover_his    (int *status){ *status = ANL_OK; }
void MdpPMdctRecover_bgnrun (int *status){ *status = ANL_OK; }
void MdpPMdctRecover_endrun (int *status){ *status = ANL_OK; }
void MdpPMdctRecover_exit   (int *status){ *status = ANL_OK; }


