/*
 *
 * dpcmdecomp.c
 * 
 * This is the main routine for the 12-bit Solar-B Mission Data Processor
 * (MDP) DPCM decoder. Large parts are stolen from ljpgtopnm.c.
 *
 * ljpgtopnm.c --
 *
 * This is the main routine for the lossless JPEG decoder.  Large
 * parts are stolen from the IJG code, so:
 *
 * Copyright (C) 1991, 1992, Thomas G. Lane.
 * Part of the Independent JPEG Group's software.
 * See the file Copyright for more details.
 *
 * Copyright (c) 1993 Brian C. Smith, The Regents of the University
 * of California
 * All rights reserved.
 * 
 * Copyright (c) 1994 Kongji Huang and Brian C. Smith.
 * Cornell University
 * All rights reserved.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL CORNELL UNIVERSITY BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF CORNELL
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * CORNELL UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND CORNELL UNIVERSITY HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include "jpeg.h"
#include "mcu.h"
#include "proto.h"

/* 
 * input and output file pointers 
 */
FILE *inFile, *outFile;

/*
 * For Solar-B application
 * This is for checking the decompressed data
 * Should be commented out
 *
 *int image_height;
 *int image_width;
 */


/*
 *--------------------------------------------------------------
 *
 * WritePmHeader --
 *
 *	Output Portable Pixmap (PPM) or Portable
 *	Graymap (PGM) image header.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *      The PPM or PGM header is written to file
 *	pointed by outFile.
 *
 *--------------------------------------------------------------
 */
void
WritePmHeader(dcInfo)
DecompressInfo dcInfo;
{
    switch(dcInfo.numComponents) {
    case 1: /* pgm */
       if (dcInfo.dataPrecision==8) {
          fprintf(outFile,"P5\n%d %d\n255\n",
                  dcInfo.imageWidth,dcInfo.imageHeight);
       } else {
          fprintf(outFile,"P5\n%d %d\n%d\n",
                  dcInfo.imageWidth,dcInfo.imageHeight,
                  ((1<<dcInfo.dataPrecision)-1));
       }
       break;
    case 3: /* ppm */
       if (dcInfo.dataPrecision==8) {
          fprintf(outFile,"P6\n%d %d\n255\n",
                  dcInfo.imageWidth,dcInfo.imageHeight);
       } else {
          fprintf(outFile,"P6\n%d %d\n%d\n",
                  dcInfo.imageWidth,dcInfo.imageHeight,
                  ((1<<dcInfo.dataPrecision)-1));
       }
       break;
    default:
      fprintf(stderr,"Error: Unsupported image format.\n");
      exit(-1);
    }
}

/*
 *--------------------------------------------------------------
 *
 * WritePmImage --
 *
 *      Output Portable Graymap (PGM) image.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      The PGM header is written to file
 *      pointed by outFile.
 *
 *--------------------------------------------------------------
 */
void
WritePmImage(dcInfo, outputBuffer,numOutputBytes)
    DecompressInfo dcInfo;
    int outputBuffer[];
    int numOutputBytes;
{
    register int col,vl,vu;

    //    fprintf(stderr,"WritePmImage: numOutputBytes = %u\n",numOutputBytes);
     for (col = 0; col < numOutputBytes; col++) {
         vl = (char) (outputBuffer[col] & 0xFF);
         vu = (char) ((outputBuffer[col] >> 8) & 0xFF);
         (void)putc(vl,outFile);
         (void)putc(vu,outFile);
     }

}

/*
 *--------------------------------------------------------------
 *
 * ArgParser --
 *
 *      Command line parser.
 *
 * Results:
 *      Command line parameters and options are passed out.
 *
 * Side effects:
 *      None.
 *
 *--------------------------------------------------------------
 */
static void
ArgParser(argc,argv,verbose,inFile,outFile,numOut)
    int argc;
    char **argv;
    int *verbose;
    FILE **inFile, **outFile;
    int *numOut;
{
    int argn;
    char *arg;
    char *usage="ppmtoljpeg [ -v -h ] [ inFile [outFile] ]";
    int NumOfFile=0;
    int i,selValue;

    /*
     * default values
     */
    *inFile=stdin;
    *outFile=stdout;
    *verbose=0;

    for (argn = 1; argn < argc; argn++) {
        arg=argv[argn];
        if (*arg != '-') { /* process a file name */
           if (NumOfFile==0) {
              if ((*inFile=fopen(arg,"r"))==NULL) {
                 fprintf(stderr,"Can't open %s\n",arg);
                 exit(-1);
              }
           }
           if (NumOfFile==1) {
              if ((*outFile=fopen(arg,"w"))==NULL) {
                 fprintf(stderr,"Can't open %s\n",arg);
                 exit(-1);
              }
           }
           if (NumOfFile>1) {
              fprintf(stderr,"%s\n",usage);
              exit(-1);
           }
           NumOfFile++;
        }
        else { /* precess a option */
           arg++;
           switch (*arg) {
             case 'h':
                       /* help flag */
                       fprintf(stderr,"Decode a lossless JPEG image into ");
                       fprintf(stderr,"a PPM or PGM image.\n");
                       fprintf(stderr,"Usage:\n");
                       fprintf(stderr,"%s\n",usage);
                       fprintf(stderr,"Default  input: stdin\n");
                       fprintf(stderr,"Default output: stdout\n");
                       fprintf(stderr,"-h  help\n");
                       fprintf(stderr,"-v  verbose\n");
                       exit(1);
                       break;
             case 'v':
                       /* verbose flag */
                       *verbose=1;
                       break;
	   case 'o' : ++arg;
	     *numOut = (int)strtol(arg, (char **)NULL, 10);
	     break;
	     
             default:
                       fprintf(stderr,"%s\n",usage);
                       exit(-1);
           }
        }
    }
}

int
main(argc, argv)
    int argc;
    char **argv;
{


    DecompressInfo dcInfo;
    int verbose;

    /*
     * InputBuffer and OutputBuffer Size
     *   Set 256Kbytes for maximum
     */
    // mcrw 20191031
    //Uchar inputBuffer[256*1024];
    Uchar inputBuffer[256*1024*2];
    // mcrw 20191031
    //int outputBuffer[256*1024];
    int outputBuffer[256*1024*2];

    int InputBytesoffset;

    /*
     *int numInputBytes= 240225;
     */
    // mcrw 20191031
    //int numInputBytes= 256*1024;
    int numInputBytes= 256*1024*2;
    int numOutputBytes;

    //   fprintf(stderr, "main: Width %d Height %d\n",dcInfo.imageWidth,dcInfo.imageHeight);

    /*
     * Process command line parameters.
     */
    ArgParser(argc,argv,&verbose,&inFile,&outFile,&numOutputBytes);

    /*
     * Read all the DPCM data from inFile (DPCM data) and put them
     * into inputBuffer array.
     */

    InputBytesoffset= fread(inputBuffer, 1, numInputBytes, inFile);
    fclose(inFile);

    if (InputBytesoffset < numInputBytes) {
        numInputBytes= InputBytesoffset;
	//	fprintf(stderr,"dpcmtopnm: numInputBytes = %lu, ", numInputBytes);
	//	fprintf(stderr,"numOutputBytes = %lu, ", numOutputBytes);
	//	fprintf(stderr,"Bytes read = %lu\n", InputBytesoffset);
    } else {
        fprintf(stderr,"File size is larger than 256 Kbytes\n");
	fprintf(stderr,"Bytes read = %lu\n", InputBytesoffset);
    }

    /*
     * Decode the image bits stream.
     *   This is the DPCM decompression routine
     */ 
    DpcmDecomp(inputBuffer,numInputBytes,outputBuffer,numOutputBytes,&dcInfo);
    //    DpcmDecomp(inputBuffer,numInputBytes,outputBuffer,&numOutputBytes);

    //    numOutputBytes = (dcInfo.imageWidth * 2) * (dcInfo.imageHeight * 2);
    numOutputBytes = (dcInfo.imageWidth) * (dcInfo.imageHeight);

    /*
     * Write PPM or PGM image header.
     *
     *fprintf(outFile, "P5\n%ld %ld\n%d\n",
     *         image_width, image_height, 4095);
     */

    
   
    //   fprintf(stderr, "main: Width %d Height %d\n",dcInfo.imageWidth,dcInfo.imageHeight);

    /*
     * Write decompressed image data to file
     */
    WritePmImage(dcInfo, outputBuffer,numOutputBytes);

    /*
     * Output image parameter if verbose flag is on.
     */
     if (verbose) {
        fprintf(stderr,"sample precision=%d\n",dcInfo.dataPrecision);
        fprintf(stderr,"image height=%d\n",dcInfo.imageHeight);
        fprintf(stderr,"image width=%d\n",dcInfo.imageWidth);
        fprintf(stderr,"component=%d\n",dcInfo.numComponents);
     }

}
