#!/usr/bin/perl

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);
use lib "$EGSE_SW_LIB/perllib/CcsdsLib";
use MdInterface;
use File::Basename;

do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

my %filenames;
my %eng_rasters = (
		   'C014' => 'ADC Offset',		# regcal014
		   'C015' => 'Short Darks',		# regcal015
		   'C016' => 'Long Darks',		# regcal016
		   'C017' => 'Short Flats',		# regcal017
		   'C018' => 'Long Flats',		# regcal018
		   'C019' => 'Intensity Calibration',	# regcal019
		   'D020' => 'Pointing and Alignment',	# regcal020
		   'D022' => 'Pointing and Alignment',	# regcal022
		   'D067' => 'EUV',			# regcal067
		   'D068' => 'EUV',			# regcal068
		   'C070' => 'Flat Oscn',		# regcal070
		   'C071' => 'Dark Bottom',		# regcal071
		   'C072' => 'Dark Top',		# regcal072
		   'C073' => 'Reduced Long',		# regcal073
		   'C074' => 'Dark Prescan',		# regcal074
		   'C075' => 'Dark Daily',		# regcal075
		   'C076' => '1exp_100ms',		# regcal076
		   'C077' => '2exps_80ms',		# regcal077
		   'D167' => 'EUV',			# regcal067
		   'D168' => 'EUV',			# regcal06
		   'D078' => 'Dark Bottom 0s',		# regcal078
		   'D079' => 'Dark Top 0s',		# regcal079
		   );


$num_args = $#ARGV;
if($num_args == 0) {
    $dirname = $ARGV[0];
}
else {
    print STDERR "Need dirname\n";
}

$archive = MdInterface->new();
@files = `ls $dirname | grep eis_md`;

my $file;
foreach $filen (@files) {
    chomp $filen;
    $last_file = $filen;
    $file = "$dirname/$filen";
    my $short_name = substr $file, -26, 26;

    my $done = 0;
    $md_headers = 0;
    if($archive->openForReading($file)) {
#	print STDOUT "\n$file\n";
#	$archive->header_report_header();
	while(1) {
	    if($archive->get_bigendian_header_packet()) {
#		$archive->printHeaders() if $verbose;
#		$archive->printPrimaryHeader() if $verbose;
		++$md_headers;
#		$archive->header_report1();
		$raster_id = $archive->raster_id();
		$ppe = $archive->mdPacketsPerExposure();
		$ras_req = $archive->rasters_required();
		$ep = $archive->exposures_per_position();
		($eng, $type) = eng($raster_id);
		$filenames{$file} = $type if $eng;
		while($archive->nextPacket()) {
		    last if($archive->isLastPacketOfSequence());
		}
	    }
	    else {
		last if($archive->{_packetValid} == 0);
#		print STDOUT "Pixel data\n" if !$done;
		$done = 1;
	    }
	}
#	print "$md_headers headers\n";
#	$archive->report();
	$shutter_move = 0;
	$shutter_move = sprintf("%5u", ($ras_req * $ep * 2)) if $eng == 0;
#	$shutter_move = sprintf("%5u", (($md_headers * 2) / $ppe)) if $eng == 0;
###	print SHUT "$short_name : ", sprintf("%5u", ($md_headers * 2)), "\n";
	print STDOUT "$short_name : ", $shutter_move, " ($ras_req, $ep, $eng)\n";
}
    else {
	print STDERR "Failed to open file\n";
    }
}

sub eng {
    my $ras_id = shift;
    return (1, 'Eng ' . $eng_rasters{$ras_id}) if $eng_rasters{$ras_id};
    return (0, "");
}
