#!/usr/bin/perl -W

# Read in cpt or MSSL generated hex file, check it and interprete contents.

# dump_obstbl [-c] [seqnnn] [llnn] obstbl.hex

# Cmd id => ['cmd name', parameter length in bytes]
%cmds = ('44' => ['eis_cam_prog_csg_win   ',  4, \&stub],
         '45' => ['eis_cam_setup_ae       ',  8, \&stub],
         '54' => ['eis_mhc_motor_enable   ',  2, \&stub],
         '5A' => ['eis_mhc_find_sht_ind   ',  2, \&stub],
         '5F' => ['eis_mhc_auto_safe      ',  6, \&stub],
         '62' => ['eis_mhc_mir_f_auto     ',  6, \&stub],
         '65' => ['eis_mhc_cal_source_ctrl',  6, \&stub],
         '66' => ['eis_mhc_cal_power      ',  6, \&stub],
         '69' => ['eis_mhc_heater_off     ',  6, \&stub],
         '6A' => ['eis_mhc_heater_on      ',  6, \&stub],
	 '6D' => ['eis_mhc_mir_c_manual   ',  8, \&stub,],
         '6F' => ['eis_mhc_parameter_set  ',  8, \&stub,],
         '70' => ['eis_mhc_qcm_ctl        ',  8, \&stub],
	 '71' => ['eis_qcm_heater         ',  6, \&decode_qcm_heater],
	 '73' => ['eis_slit_slot_auto     ',  8, \&decode_slitslot_auto],
         '76' => ['eis_mhc_watchdog       ',  6, \&stub],
         '81' => ['eis_stop_seq           ',  1, \&stub],
         '82' => ['eis_call_seq           ',  1, \&decode_eis_call_seq],
         '85' => ['eis_flush_ccd          ',  2, \&stub],
         '86' => ['eis_run_raster         ', 22, \&decode_run_raster],
	 '87' => ['eis_set_mhc_opepar     ', 36, \&stub],
         '89' => ['eis_set_seq_loop       ',  1, \&decode_set_seq_loop],
         '8A' => ['eis_delay              ',  2, \&decode_eis_delay],
         '8D' => ['eis_start_exp          ',  2, \&decode_start_exp],
         '8E' => ['eis_flat_field         ',  3, \&decode_eis_flat_field],
         );

@slit_slot = ('1"', '256"', '2"', '40"');

$cpt = 0;

# $argc will be 0 for prog + filename
$argc = $#ARGV;
if($argc > 0) {
    while($argc--) {
	$a = shift;

#	print "A = $a\n";
	if($a =~ /-c/) {
	    $cpt = 1;
	}

	if($a =~ /seq/) {
	    $qseq = $a;
#	    print "QSEQ = $qseq\n";
	}
	if($a =~ /ll/) {
	    $qll = $a;
	}
    }
}

$c=<>;	# First line is comment line
print "$c";

$info = <>;	# Address etc
chop $info;

if($cpt == 1) {
    foreach $seq (0..127) {
	$seqs[$seq] = <>;
    }
    foreach $ll (0..47) {
	$lls[$ll] = <>;
	chop $lls[$ll];

	chop $lls[$ll];
	chop $lls[$ll];

	$foo = <>;
	chop $foo;

	$len_foo = length($foo);
	$lls[$ll] .= substr($foo, 9, ($len_foo - 9));
    }
    # AEC exposure time table
    $aec_time = hex_line();
    # AEC control table
    $aec_cntl = hex_line();
    # XRT table
    $xrt_flare_table = hex_line();
    # EIS flare trigger
    $eis_flare_table = hex_line();
    # EIS event trigger
    $eis_event_table = hex_line();

}
else {
    foreach $seq (0..127) {
	foreach $i (0..4) {
	    $line = <>;
	    chomp $line;
	    $len = length $line;
	    if($i == 0) {
		$seq_line = $line;
	    }
	    else {
		$seq_line = substr $line, 9, $len - 9;
	    }
	    chop $seq_line;
	    chop $seq_line;
	    $seqs[$seq] .= $seq_line;
	}
	$junk = <>;	# Address line of next sequence
    }
    # Address line has already been read
    foreach $ll (0..47) {
	foreach $i (0..5) {
	    $line = <>;
	    chomp $line;
	    $len = length $line;
	    if($i == 0) {
		$ll_line = $line;
	    }
	    else {
		$ll_line = substr $line, 9, $len - 9;
	    }
	    chop $ll_line;
	    chop $ll_line;
	    $lls[$ll] .= $ll_line;
	}
	$junk = <>;	# Address line of next line list
    }
}

#foreach $i (0..127) {
#    print "SEQ[$i] = ", $seqs[$i], "\n";
#}

#foreach $i (0..47) {
#    print "LL[$i] = ", $lls[$i], "\n";
#}

if($qseq) {
    $qseq =~ s/seq//;
    $l = length($seqs[$qseq]);
    $sequence = substr($seqs[$qseq], 9, ($l - 9));
    &decode_sequence($qseq, $sequence);
}
else {
    if(!$qll) {
	foreach $seq (0..127) {
	    $l = length($seqs[$seq]);
	    $sequence = substr($seqs[$seq], 9, ($l - 9));
	    &decode_sequence($seq, $sequence);
	}
    }
}

if($qll) {
    $qll =~ s/ll//;
    $l = length($lls[$qll]);
    $linelist = substr($lls[$qll], 9, ($l - 9));
    &decode_linelist($qll, $linelist);
}
else {
    if(!$qseq) {
	foreach $ll (0..47) {
	    $l = length($lls[$ll]);
	    $linelist = substr($lls[$ll], 9, ($l - 9));
	    &decode_linelist($ll, $linelist);
	}
    }
}

# Dump tables
&decode_aec_time_table($aec_time);
&decode_aec_cntl_table($aec_cntl);
&decode_xrt_flare_table($xrt_flare_table);
&decode_eis_flare_table($eis_flare_table);
&decode_eis_event_table($eis_event_table);

sub decode_sequence {
    my $snum = shift;
    my $seq = shift;
    chop $seq;

    $len = sprintf "%03u", hex(byte(0, $seq));
    print "\nSEQUENCE $snum (", sprintf("%02X", $snum), ")";
    if($len > 128) {
	print "\tUNUSED\n";
	return;
    }
    print "\n0\tLENGTH\t\t\t$len (decimal)\n";
    print "1\tSEQID\t\t\t", word(1, $seq), "\n";
    print "3\tSEQ REP\t\t\t", byte(3, $seq), " (decimal)\n";

    $cmd_offset = 4;
    $cmd = 0;
    while(1) {
        $cmd = byte($cmd_offset, $seq);
	last if $cmd_offset > $len;
	if($cmd_offset == ($len - 1)) {
	    print "$cmd_offset\tCHECKSUM\t\t$cmd\n";
	    last;
	}
	if(defined($cmds{$cmd})) {
	    print "$cmd_offset\t", $cmds{$cmd}[0], "\t", bytes($cmd_offset, ($cmds{$cmd}[1] + 1), $seq);

#            $decode = $cmds{$cmd}[2];
#            &$decode(bytes($cmd_offset, ($cmds{$cmd}[1] + 1), $seq));
	    &{$cmds{$cmd}[2]}(bytes($cmd_offset, ($cmds{$cmd}[1] + 1), $seq));
            $cmd_offset += ($cmds{$cmd}[1] + 1);

	}
        else {
            if($cmd_offset == ($len - 1)) {
		
                print "$cmd_offset\tCHECKSUM\t\t$cmd\n";
		last;
            }
            else {
                print "$cmd_offset\t??????\t\t\t$cmd\n";
            }
            ++$cmd_offset;
        }
	
    }
}

sub decode_linelist {
    my $snum = shift;
    my $mem_str = shift;

    print "\nLINE LIST $snum (" , sprintf("%02X", $snum), ")";

    chop $mem_str;

    $len = sprintf "%u", hex(byte(0, $mem_str));
    if(($len == 0) || ($len == 255)) {
	print " Unused\n";
	return;
#	print "Incorrect length ($len)\n";
#	exit -2;
    }
    print "\n";

    print "0\tLinelist length\t\t$len\n";
    $nwin = sprintf "%u", hex(byte(2, $mem_str));
    if(($len == 0) || ($nwin > 25)) {
	print "Incorrect nwin ($nwin)\n";
	exit -2;
    }
    print "2\tNumber of sw windows\t", byte(2, $mem_str), "\t($nwin)\n";
    print "3\tChecksum\t\t", sprintf("%02X", hex(byte(3,$mem_str))), "\n";
    print "4\tCCD Length\t\t", word(4, $mem_str), "\t(", sprintf("%u", hex(word(4,$mem_str))),")\n";
    print "6\tXws\t\t\t", word(6, $mem_str), "\t(", sprintf("%u", hex(word(6,$mem_str))),")\n";
    print "8\tXw\t\t\t", word(8, $mem_str), "\t(", sprintf("%u", hex(word(8,$mem_str))),")\n";
    print "10\tYws\t\t\t", word(10, $mem_str), "\t(", sprintf("%u", hex(word(10,$mem_str))),")\n";
    print "12\tYw\t\t\t", word(12, $mem_str), "\t(", sprintf("%u", hex(word(12,$mem_str))),")\n";

    $offset = 14;
    for($i = 0; $i < $nwin; ++$i) {
	$tabs = 2;
	$tabs = 1 unless $i < 10;
	print "$offset\tSW $i Hdr, Xs, Xw", "\t" x $tabs, word($offset, $mem_str);
	$offset += 2;

	print ", ", word($offset, $mem_str);

	$offset += 2;
	print ", ", word($offset, $mem_str), "\n";
	$offset += 2;
    }
}

#sub decode_slitslot_auto {
#    my $bytes = shift;
#
#    my $dir = word(5, $bytes);
#    my $s   = word(7, $bytes);
#    my $dir_str;
#    my $s_str;
#
#    $dir_str = " (forward)";
#    $dir_str = " (reverse)" unless $dir == 1;
#    my $foo = sprintf("%u", $s);
#    $s_str = $slit_slot[$foo];
#    print "\t\t\t\tDirection\t", word(5, $bytes), "$dir_str\n";
#    print "\t\t\t\tSlit\t\t", word(7, $bytes), " ($s_str)\n";
#}

sub decode_run_raster {
    my $bytes = shift;

    print "\n\t\t\t\tRaster ID\t", word(1, $bytes), "\n";
    print "\t\t\t\tMip\t\t", word(3, $bytes), "\n";
    print "\t\t\t\tLoop Counter\t0x", word(5, $bytes), "\n";
    print "\t\t\t\tCompression\t", word(7, $bytes), "\n";
    print "\t\t\t\tOCB-X\t\t", byte(9, $bytes), "\n";
    print "\t\t\t\tOCB-Y\t\t", byte(10, $bytes), "\n";
    print "\t\t\t\tFlush Id\t", byte(11, $bytes), "\n";
    print "\t\t\t\tNum flush\t", byte(12, $bytes), "\n";
    print "\t\t\t\tExp/pos\t\t", sprintf("%02u", hex(byte(13, $bytes))) & 0xF, "\n";
    print "\t\t\t\tASRC ctl\t", byte(14, $bytes), "\n";
    $ro = sprintf("%u", hex(byte(15, $bytes)));
    $ro >>= 4;
    print "\t\t\t\tRo nodes\t", sprintf("%02X", $ro), "\n";
 
    $foo = sprintf("%u", hex(byte(15, $bytes)));
    $foo &= 0x0F;
    $foo <<= 8;
 
    $foo1 = sprintf("%u", hex(byte(16, $bytes)));
    $bar = sprintf("%04X", ($foo | $foo1));
 
    print "\t\t\t\tRepeats\t\t0x$bar\n";

    print "\t\t\t\tASRC skip\t", byte(17, $bytes), "\n";
    print "\t\t\t\tRo seq\t\t", byte(18, $bytes), "\n";
    print "\t\t\t\tStep size\t", word(19, $bytes), "\n";
    print "\t\t\t\tLine list\t", byte(21, $bytes), "\n";
    print "\t\t\t\tSci Op\t\t", byte(22, $bytes), "\n";
}


sub decode_qcm_heater {
    my $bytes = shift;

    my $onoff = word(5, $bytes);
    my $str;

    if($onoff == 1) {
	$str = "QCM1 heater on";
    }
    elsif($onoff == 2) { $str = "QCM2 heater on";}
    else { $str = "QCM heater off";}
    
    print "\n\t\t\t\t\tState\t", word(5, $bytes), " $str\n";
}

sub decode_slitslot_auto {
    my $bytes = shift;

    my $dir = word(5, $bytes);
    my $s   = word(7, $bytes);
    my $dir_str;
    my $s_str;

    $dir_str = " (forward)";
    $dir_str = " (reverse)" unless $dir == 1;
    my $foo = sprintf("%u", $s);
    $s_str = $slit_slot[$foo];
    print "\n\t\t\t\tDirection\t", word(5, $bytes), "$dir_str\n";
    print "\t\t\t\tSlit\t\t", word(7, $bytes), " ($s_str)\n";
}

sub decode_start_exp {
    my $bytes = shift;
    my $t = word(1, $bytes);
    
    print "\t(", sprintf("%u", hex($t) * 10)," ms)\n";
}

sub decode_set_seq_loop {
    my $bytes = shift;
    my $t = word(1, $bytes);
    
    print "\t(", sprintf("%u", hex($t)),")\n";
}

sub decode_eis_call_seq {
    my $bytes = shift;
    my $t = word(1, $bytes);
    
    print "\t(", sprintf("%u", hex($t)),")\n";
}

sub decode_eis_delay {
    my $bytes = shift;
    my $t = word(1, $bytes);
    
    print "\t(", sprintf("%u", hex($t))," ms)\n";
}

sub decode_eis_flat_field {
    my $bytes = shift;
    my $t = word(1, $bytes);
    my $l = byte(3, $bytes);
    my $led_str;

    print "\t(", sprintf("%u", hex($t)/100)," ms,";

    if($l == 0) {$led_str = "both off";}
    elsif($l == 1) {$led_str = "1";}
    elsif($l == 2) {$led_str = "2";}
    elsif($l == 3) {$led_str = "1 & 2";}
    else {$led_str = "unknown";}

    print " led ", $led_str, ")\n";


#    print "\tnot decoded\n";
}

#sub decode_dummy {
sub stub {
    my $bytes = shift;
    my $t = word(1, $bytes);
    
#    print "\t(", sprintf("%u", hex($t)),")\n";
    print "\tnot decoded\n";
}

sub bytes {
    my $offset = shift;
    my $len    = shift;
    my $str    = shift;
    return substr $str, ($offset * 2), ($len * 2);
}
 
sub byte {
    my $offset = shift;
    my $str = shift;
    return substr $str, ($offset * 2), 2;
}
 
sub word {
    my $offset = shift;
    my $str = shift;
    return substr $str, ($offset * 2), 4;
}

sub hex_line {
    my $line = <>;
    my $l = length $line;
    my $data = substr($line, 9, ($l - 9));
    chomp $data;
    return $data;
}

sub decode_aec_time_table {
    my $aec_time = shift;
    print "\n\nAEC Exposure Time Table:\n\n";
}

sub decode_aec_cntl_table {
    my $aec_cntl = shift;
    print "AEC Control Table:\n\t";
    
#    print "Upper Threshold: 0x", sprintf("%04X", hex(word(0, $aec_cntl))), "\n";
    print "Upper Threshold: 0x", word(0, $aec_cntl), "\n\t";
    print "Lower Threshold: 0x", word(2, $aec_cntl), "\n\t";
    print "HEPC: 0x", word(4, $aec_cntl) . word(6, $aec_cntl), "\n\t";
    print "LEPC: 0x", word(8, $aec_cntl) . word(10, $aec_cntl), "\n\t";
    my $word6 = sprintf "%u", hex(word(12, $aec_cntl));
    my $word7 = sprintf "%u", hex(word(14, $aec_cntl));
    print "Exposure ID: 0x", sprintf("%02X", ($word6 >> 11)), "\n\t";
    print "Binning: 0x", sprintf("%03X", (($word6 & 0x07FF) >> 1)), "\n\t";
    my $runtime = sprintf "%05X", ((($word6 & 1) << 16) | $word7);
    print "Runtime : 0x$runtime (", sprintf("%u", hex($runtime)), ")\n\n"; 
}

sub decode_xrt_flare_table {
    my $xrt_flare_table = shift;
    print "XRT Flare Table:\n\t";
    my $sn = sprintf "%u", hex(byte(0, $xrt_flare_table));
    my $rid = sprintf "%u", hex(word(1, $xrt_flare_table));
    my $flags = sprintf "%u", hex(byte(3, $xrt_flare_table));
    my $y_start = word(4, $xrt_flare_table) . word(6, $xrt_flare_table);
    my $y_height = word(8, $xrt_flare_table) . word(10, $xrt_flare_table);
    my $w6 = sprintf "%u", hex(word(12, $xrt_flare_table));
    my $w7 = sprintf "%u", hex(word(14, $xrt_flare_table));
    my $x0 = sprintf "%03X", ($w6 >> 4);
    my $y0 = sprintf "%03X", ((($w6 & 0xF) << 8) | (($w7 >> 8) & 0xFFF));
    my $fs = sprintf "%u", ($w7 & 0xFF);

    my $w8 = sprintf "%u", hex(word(16, $xrt_flare_table));
    my $w9 = sprintf "%u", hex(word(18, $xrt_flare_table));
    my $theta = $w8;
    my $ocb = sprintf "%02X", ($w9 >> 8);
    my $psize = sprintf "502X", (($w9 >> 4) & 0xFF);
    my $fsen = (($w9 >> 3) & 1);
    my $fov = (($w9 >> 1) & 1);
    my $sb = ($w9 & 1);
    print "Sequence Number: 0x", sprintf("%02X", $sn), " ($sn)\n\t";
    print "Raster ID: 0x", sprintf("%02X", $rid), " ($rid)\n\t";
    print "Controle Flags: 0x", sprintf("%02X", $flags), "\n\t";
    print "Y Start Address: 0x$y_start\n\t";
    print "Y Height Address: 0x$y_height\n\t";
    print "X0 : 0x", $x0, "\n\t";
    print "Y0 : 0x", $y0, "\n\t";
    print "Filler : 0x", sprintf("%02X", $fs), " ($fs)\n\t";
    print "XRT OCB : 0x$ocb\n\t";
    print "P-size : 0x$psize\n\t";
    print "Fs enable : $fsen\n\t";
    print "EIS FOV : $fov\n\t";
    print "Spare : $sb\n\n";
}

sub decode_eis_flare_table {
    my $eis_flare_table = shift;
    print "EIS Flare Table:\n\t";
    
    my $sn = byte(0, $eis_flare_table);
    my $rid = word(1, $eis_flare_table);
    my $flags = byte(3, $eis_flare_table);
    my $x_threshold = word(4, $eis_flare_table) . word(6, $eis_flare_table);
    my $y_threshold = word(8, $eis_flare_table) . word(10, $eis_flare_table);
    my $y_start = word(12, $eis_flare_table) . word(14, $eis_flare_table);
    my $y_height = word(16, $eis_flare_table) . word(18, $eis_flare_table);
    my $x_min = sprintf "%u", hex(byte(20, $eis_flare_table));
    my $y_min = sprintf "%u", hex(byte(21, $eis_flare_table));
    my $psize = sprintf "%u", hex(byte(22, $eis_flare_table));
    my $res = sprintf "%u", hex(byte(23, $eis_flare_table));

    print "Sequence Number : 0x", sprintf("%02X", hex($sn)), " ($sn)\n\t";
    print "Raster ID : 0x", sprintf("%04X", hex($rid)), " ($rid)\n\t";
    print "Flags : 0x", sprintf("%02X", hex($flags)), "\n\t";
    print "X Threshold : 0x$x_threshold\n\t";
    print "Y Threshold : 0x$y_threshold\n\t";
    print "Y Start Address : 0x$y_start\n\t";
    print "Y Height Address : 0x$y_height\n\t";
    print "X Min Limit : 0x", sprintf("%02X", $x_min), " ($x_min)\n\t";
    print "Y Min Limit : 0x", sprintf("%02X", $y_min), " ($y_min)\n\t";
    print "EIS P-size : 0x", sprintf("%02X", $psize), " {$psize)\n\t";
    print "Reserved: 0x", sprintf("%02X", $res), "\n\n";
}

sub decode_eis_event_table {
    my $eis_event_table = shift;
    print "EIS Event Table:\n\t";

    my $sn = byte(0, $eis_event_table);
    my $rid = word(1, $eis_event_table);
    my $flags = byte(3, $eis_event_table);
    my $x_threshold = word(4, $eis_event_table) . word(6, $eis_event_table);
    my $y_threshold = word(8, $eis_event_table) . word(10, $eis_event_table);
    my $y_start = word(12, $eis_event_table) . word(14, $eis_event_table);
    my $y_height = word(16, $eis_event_table) . word(18, $eis_event_table);
    print "Sequence Number : 0x", sprintf("%02X", $sn), " ($sn)\n\t";
    print "Raster ID : 0x", sprintf("%04X", hex($rid)), " (", sprintf("%u", hex($rid)), ")\n\t";
    print "Flags : 0x", sprintf("%02X", hex($flags)), "\n\t";
    print "X Threshold : 0x$x_threshold\n\t";
    print "Y Threshold : 0x$y_threshold\n\t";
    print "Y Start Address : 0x$y_start\n\t";
    print "Y Height Address : 0x$y_height\n";
}

