#!/usr/bin/perl -W

# Read in cpt or MSSL generated hex file, check it and interprete contents.

# dump_obstbl [-c] [seqnnn] [llnn] obstbl.hex

# Cmd id => ['cmd name', parameter length in bytes]
%cmds = ('44' => ['eis_cam_prog_csg_win' ,  4, \&stub],
         '45' => ['eis_cam_setup_ae'     ,  8, \&stub],
	 '54' => ['eis_mhc_motor_enable' ,  2, \&stub],
	 '5A' => ['eis_mhc_find_sht_ind ',  2, \&stub],
	 '5F' => ['eis_mhc_auto_safe'    ,  6, \&stub],
	 '62' => ['eis_mhc_mir_f_auto'   ,  6, \&stub],
	 '65' => ['eis_mhc_cal_src_ctl'  ,  6, \&stub],
         '66' => ['eis_mhc_cal_power'    ,  6, \&stub],
	 '69' => ['eis_mhc_heater_off'   ,  6, \&stub],
	 '6A' => ['eis_mhc_heater_on'    ,  6, \&stub],
         '6F' => ['eis_mhc_parameter_set',  8, \&stub],
	 '70' => ['eis_mhc_qcm_ctl'      ,  8, \&stub],
	 '71' => ['eis_mhc_qcm_htr'      ,  6, \&decode_qcm_heater],
	 '73' => ['eis_slit_slot_auto'   ,  8, \&decode_slitslot_auto],
	 '76' => ['eis_mhc_watchdog'     ,  6, \&stub],
         '81' => ['eis_stop_seq'         ,  1, \&stub],
         '82' => ['eis_call_seq'         ,  1, \&decode_eis_call_seq],
         '85' => ['eis_flush_ccd'        ,  2, \&stub],
         '86' => ['eis_run_raster'       , 22, \&decode_run_raster],
	 '87' => ['eis_set_mhc_opepar'   , 36, \&stub],
         '89' => ['eis_set_seq_loop'     ,  1, \&decode_set_seq_loop],
         '8A' => ['eis_delay'            ,  2, \&decode_eis_delay],
         '8D' => ['eis_start_exp'        ,  2, \&decode_start_exp],
         '8E' => ['eis_flat_field'       ,  3, \&decode_eis_flat_field],
         );

@slit_slot = ('1"', '256"', '2"', '40"');

$cpt = 0;

my $AEC_exposures_time_table       = "";
my $AEC_control_parameters_string  = "";
my $XRT_flare_trigger_table_string = "";
my $EIS_flare_trigger_table_string = "";
my $EIS_event_trigger_table_string = "";

# $argc will be 0 for prog + filename
$argc = $#ARGV;
if($argc > 0) {
    while($argc--) {
	$a = shift;

#	print "A = $a\n";
	if($a =~ /-c/) {
#	    print "FOUND -c\n";
	    $cpt = 1;
	}

	if($a =~ /seq/) {
#	    print "SEQ FOUND : $a\n";
	    $qseq = $a;
#	    print "QSEQ = $qseq\n";
	}
	if($a =~ /ll/) {
#	    print "LL FOUND : $a\n";
	    $qll = $a;
	}
    }
}

$c=<>;	# First line is comment line
print "$c";

$info = <>;	# Address etc
chop $info;

if($cpt == 1) {
    foreach $seq (0..127) {
	$seqs[$seq] = <>;
    }
    foreach $ll (0..47) {
	$lls[$ll] = <>;
	chop $lls[$ll];
	$foo = <>;
	chop $foo;
	$len_foo = length($foo);
	$lls[$ll] .= substr($foo, 9, ($len_foo - 9));
    }

    # Now get the tables
#    my $junk = <>;	# ???
    $AEC_exposures_time_table       = <>;
    $AEC_control_parameters_string  = <>;
    $XRT_flare_trigger_table_string = <>;
    $EIS_flare_trigger_table_string = <>;
    $EIS_event_trigger_table_string = <>;

}
else {
    foreach $seq (0..127) {
	foreach $i (0..4) {
	    $line = <>;
	    chomp $line;
	    $len = length $line;
	    if($i == 0) {
		$seq_line = $line;
	    }
	    else {
		$seq_line = substr $line, 9, $len - 9;
	    }
	    chop $seq_line;
	    chop $seq_line;
	    $seqs[$seq] .= $seq_line;
	}
	$junk = <>;	# Address line of next sequence
    }
    # Address line has already been read
    foreach $ll (0..47) {
	foreach $i (0..5) {
	    $line = <>;
	    chomp $line;
	    $len = length $line;
	    if($i == 0) {
		$ll_line = $line;
	    }
	    else {
		$ll_line = substr $line, 9, $len - 9;
	    }
	    chop $ll_line;
	    chop $ll_line;
	    $lls[$ll] .= $ll_line;
	}
	$junk = <>;	# Address line of next line list
    }
}

if($qseq) {
    $qseq =~ s/seq//;
    $l = length($seqs[$qseq]);
    $sequence = substr($seqs[$qseq], 9, ($l - 9));
    &decode_sequence($qseq, $sequence);
}
else {
    if(!$qll) {
	foreach $seq (0..127) {
	    $l = length($seqs[$seq]);
	    $sequence = substr($seqs[$seq], 9, ($l - 9));
	    &decode_sequence($seq, $sequence);
	}
    }
}

if($qll) {
    $qll =~ s/ll//;
    $l = length($lls[$qll]);
    $linelist = substr($lls[$qll], 9, ($l - 9));
    &decode_linelist($qll, $linelist);
}
else {
    if(!$qseq) {
	foreach $ll (0..47) {
	    $l = length($lls[$ll]);
	    $linelist = substr($lls[$ll], 9, ($l - 9));
	    &decode_linelist($ll, $linelist);
	}
    }
}

&decode_aec_time_table($AEC_exposures_time_table);
translate_AEC_control_parameter($AEC_control_parameters_string);
translate_XRT_flare_trigger_table($XRT_flare_trigger_table_string);
translate_EIS_flare_trigger_table($EIS_flare_trigger_table_string);
translate_EIS_event_trigger_table($EIS_event_trigger_table_string);

sub decode_aec_time_table {
    my $aec_time = shift;
    print "\n\nAEC Exposure Time Table:\n\n";
    print "*** NOT DECODED YET ***\n";
}

sub decode_sequence {
    my $snum = shift;
    my $seq = shift;

    chop $seq;

    $len = sprintf "%03u", hex(byte(0, $seq));
    print "\nSEQUENCE $snum";
    if($len > 128) {
	print "\tUNUSED\n";
	return;
    }
    print "\n0\tLENGTH\t\t\t$len\n";
    print "1\tSEQID\t\t\t", word(1, $seq), "\n";
    print "3\tSEQ REP\t\t\t", byte(3, $seq), "\n";

    $cmd_offset = 4;
    $cmd = 0;
    while(1) {
        $cmd = byte($cmd_offset, $seq);
	last if $cmd_offset > $len;
	if(defined($cmds{$cmd})) {
	    print "$cmd_offset\t", $cmds{$cmd}[0], "\t", bytes($cmd_offset, ($cmds{$cmd}[1] + 1), $seq), "\n";
###	    print "$cmd_offset\t", $cmds{$cmd}[0], "\t", bytes($cmd_offset, ($cmds{$cmd}[1] + 1), $seq);
#	    $decode = $cmds{$cmd}[2];
#	    &$decode(bytes($cmd_offset, ($cmds{$cmd}[1] + 1), $seq));
	    &{$cmds{$cmd}[2]}(bytes($cmd_offset, ($cmds{$cmd}[1] + 1), $seq));
	    $cmd_offset += ($cmds{$cmd}[1] + 1);
	}
        else {
            if($cmd_offset == ($len - 1)) {
                print "$cmd_offset\tCHECKSUM\t\t$cmd\n";
		last;
            }
            else {
                print "$cmd_offset\t??????\t\t\t$cmd\n";
            }
            ++$cmd_offset;
        }
    }
}

sub decode_linelist {
    my $snum = shift;
    my $mem_str = shift;

    print "\nLINE LIST $snum";
###    print "\nLINE LIST $snum\t$mem_str\n";

    chop $mem_str;

    $len = sprintf "%u", hex(byte(0, $mem_str));
    if(($len == 0) || ($len == 255)) {
	print " Unused\n";
	return;
#	print "Incorrect length ($len)\n";
#	exit -2;
    }
    print "\n";

    print "0\tLinelist length\t\t$len\n";
    print "1\tRO Node\t\t\t0x", byte(1, $mem_str), "\n";
    $nwin = sprintf "%u", hex(byte(2, $mem_str));
    if(($len == 0) || ($nwin > 25)) {
	print "Incorrect nwin ($nwin)\n";
	exit -2;
    }
    print "2\tNumber of sw windows\t", byte(2, $mem_str), "\n";
    print "3\tChecksum\t\t", sprintf("%02X", hex(byte(3,$mem_str))), "\n";
    print "4\tCCD Length\t\t", word(4, $mem_str), "\n";
    print "6\tXws\t\t\t", word(6, $mem_str), "\n";
    print "8\tXw\t\t\t", word(8, $mem_str), "\n";
    print "10\tYws\t\t\t", word(10, $mem_str), "\n";
    print "12\tYw\t\t\t", word(12, $mem_str), "\n";

    $offset = 14;
    for($i = 0; $i < $nwin; ++$i) {
	$tabs = 2;
	$tabs = 1 unless $i < 10;
	print "$offset\tSW $i Hdr, Xs, X", "\t" x $tabs, word($offset, $mem_str);
	$offset += 2;

	print ", ", word($offset, $mem_str);

	$offset += 2;
	print ", ", word($offset, $mem_str), "\n";
	$offset += 2;
    }
}

sub decode_run_raster {
    my $bytes = shift;

    print "\t\t\t\tRaster ID\t", word(1, $bytes), "\n";
    print "\t\t\t\tMip\t\t", word(3, $bytes), "\n";
    print "\t\t\t\tLoop Counter\t", word(5, $bytes), "\n";
    print "\t\t\t\tCompression\t", word(7, $bytes), "\n";
    print "\t\t\t\tOCB-X\t\t", byte(9, $bytes), "\n";
    print "\t\t\t\tOCB-Y\t\t", byte(10, $bytes), "\n";
    print "\t\t\t\tFlush Id\t", byte(11, $bytes), "\n";
    print "\t\t\t\tNum flush\t", byte(12, $bytes), "\n";
    print "\t\t\t\tExp/pos\t\t", sprintf("%02u", hex(byte(13, $bytes))) & 0xF, "\n";
    print "\t\t\t\tASRC ctl\t", byte(14, $bytes), "\n";
    $ro = sprintf("%u", hex(byte(15, $bytes)));
    $ro >>= 4;
    print "\t\t\t\tRo nodes\t", sprintf("%02X", $ro), "\n";
 
    $foo = sprintf("%u", hex(byte(15, $bytes)));
    $foo &= 0x0F;
    $foo <<= 8;
 
    $foo1 = sprintf("%u", hex(byte(16, $bytes)));
    $bar = sprintf("%04X", ($foo | $foo1));
 
    print "\t\t\t\tRepeats\t\t$bar\n";

    print "\t\t\t\tASRC skip\t", byte(17, $bytes), "\n";
    print "\t\t\t\tRo seq\t\t", byte(18, $bytes), "\n";
    print "\t\t\t\tStep size\t", word(19, $bytes), "\n";
    print "\t\t\t\tLine list\t", byte(21, $bytes), "\n";
    print "\t\t\t\tSci Op\t\t", byte(22, $bytes), "\n";
}

sub decode_qcm_heater {
    my $bytes = shift;

    my $onoff = word(5, $bytes);
    my $str;

    if($onoff == 1) {
	$str = "QCM1 heater on";
    }
    elsif($onoff == 2) { $str = "QCM2 heater on";}
    else { $str = "QCM heater off";}
    
    print "\n\t\t\t\t\tState\t", word(5, $bytes), " $str\n";
}

sub decode_slitslot_auto {
    my $bytes = shift;

    my $dir = word(5, $bytes);
    my $s   = word(7, $bytes);
    my $dir_str;
    my $s_str;

    $dir_str = " (forward)";
    $dir_str = " (reverse)" unless $dir == 1;
    my $foo = sprintf("%u", $s);
    $s_str = $slit_slot[$foo];
    print "\t\t\t\tDirection\t", word(5, $bytes), "$dir_str\n";
    print "\t\t\t\tSlit\t\t", word(7, $bytes), " ($s_str)\n";
}

sub decode_start_exp {
    my $bytes = shift;
    my $t = word(1, $bytes);
    
    print "\t\t\t(", sprintf("%u", hex($t) * 10)," ms)\n";
}

sub decode_set_seq_loop {
    my $bytes = shift;
    my $t = word(1, $bytes);
    
    print "\t\t\t\t(", sprintf("%u", hex($t)),")\n";
}

sub decode_eis_call_seq {
    my $bytes = shift;
    my $t = word(1, $bytes);
    
    print "\t(", sprintf("%u", hex($t)),")\n";
}

sub decode_eis_delay {
    my $bytes = shift;
    my $t = word(1, $bytes);
    
    print "\t\t\t(", sprintf("%u", hex($t))," ms)\n";
}

sub decode_eis_flat_field {
    my $bytes = shift;
    my $t = word(1, $bytes);
    my $l = byte(3, $bytes);
    my $led_str;

    print "\t\t\t(", sprintf("%u", hex($t)/100)," ms,";

    if($l == 0) {$led_str = "both off";}
    elsif($l == 1) {$led_str = "1";}
    elsif($l == 2) {$led_str = "2";}
    elsif($l == 3) {$led_str = "1 & 2";}
    else {$led_str = "unknown";}

    print " led ", $led_str, ")\n";


#    print "\tnot decoded\n";
}

sub bytes {
    my $offset = shift;
    my $len    = shift;
    my $str    = shift;
    return substr $str, ($offset * 2), ($len * 2);
}
 
sub byte {
    my $offset = shift;
    my $str = shift;
    return substr $str, ($offset * 2), 2;
}
 
sub word {
    my $offset = shift;
    my $str = shift;
    return substr $str, ($offset * 2), 4;
}

sub get_32bit_value {
    my $off = shift;
    my $bytes = shift;

    my $byte0 = byte($off++, $bytes);
    my $byte1 = byte($off++, $bytes);
    my $byte2 = byte($off++, $bytes);
    my $byte3 = byte($off, $bytes);

    return "$byte0$byte1$byte2$byte3";
}

#sub get_32bit_value {
#    my $off = shift;
#    my $bytes = shift;
#
#    my $byte0 = hex(byte($off++, $bytes));
#    my $byte1 = hex(byte($off++, $bytes));
#    my $byte2 = hex(byte($off++, $bytes));
#    my $byte3 = hex(byte($off, $bytes));
#
#    return hex(($byte0 << 24) | ($byte1 << 16) | ($byte2 << 8) | $byte3);
#}

sub stub {

}

sub translate_AEC_control_parameter {
    my $string = shift;
    my $l = length $string;
    my $bytes = substr($string, 9, ($l - 9));

    print "\nAEC table:\n";
    my $tmp = word(0, $bytes);
    print "\t\tUpper threshold: $tmp\n";
    $tmp = word(1, $bytes);
    print "\t\tLower threshold: $tmp\n";
    
    $tmp = get_32bit_value(4, $bytes);
    print "\t\tHEPC: $tmp\n";
    $tmp = get_32bit_value(8, $bytes);
    print "\t\tLEPC: $tmp\n";

}

sub translate_XRT_flare_trigger_table {
    my $string = shift;
    chomp $string;
    my $l = length $string;
    my $bytes = substr($string, 9, ($l - 9));

    print "\nXRT flare trigger table:\n";
    my $tmp = byte(0, $bytes);
    print "\t\tSeq no: 0x", $tmp, " (", sprintf("%u", hex($tmp)), ")\n";
    my $byte1 = byte(1, $bytes);
    my $byte2 = byte(2, $bytes);
    my $rasterId = ((hex($byte1) << 8) | hex($byte2));
    print "\t\tRaster ID: 0x", sprintf("%04X", $rasterId), " ($rasterId)\n";
#    print "Raster ID: ", ((hex(byte(1, $bytes)) << 8) | hex(byte(2, $bytes))), "\n";
    print "\t\tFlags: 0x", sprintf("%02X\n", hex(byte(3, $bytes)));

    $tmp = get_32bit_value(4, $bytes);
    print "\t\tY start address: 0x$tmp (", sprintf("%u", hex($tmp)), ")\n";
    $tmp = get_32bit_value(8, $bytes);
    print "\t\tY height address: 0x$tmp (", sprintf("%u", hex($tmp)), ")\n";

    my $byte12 = hex(byte(12, $bytes));
    my $byte13 = hex(byte(13, $bytes));
    my $res = ($byte12 << 4) | (($byte13 >> 4) & 0xF);
    print "\t\tX0: 0x", sprintf("%03X", $res), " ($res)\n";

#    $tmp1 = hex(byte(13, $bytes));
    my $byte14 = hex(byte(14, $bytes));
    $res = (($byte13 & 0xF) << 4) | $byte14;
    print "\t\tY0: 0x", sprintf("%03X", $res), " ($res)\n";

    $tmp = hex(byte(15, $bytes));
    print "\t\tFiller: 0x", sprintf("%X", $tmp), " ($tmp)\n";

    $tmp = (hex(byte(16, $bytes)) << 8) | hex(byte(17, $bytes));
    print "\t\tTheta: 0x", sprintf("%X", $tmp), " ($tmp)\n";

    my $byte18 = hex(byte(18, $bytes));
    my $byte19 = hex(byte(19, $bytes));
#    print "XRT OCB: 0x", sprintf("%u", hex($tmp)), " ($tmp)\n";
    my $ocb = ($byte18 >> 4);
    print "\t\tXRT OCB: 0x", sprintf("%01X", $ocb), " ($ocb)\n";

    my $psize = (($byte18 & 0xF) << 4) | ($byte19 >> 4);
    print "\t\tXRT Pixel size: 0x", sprintf("%02X", $psize), " ($psize)\n";

    $tmp = ($byte19 & 0xF);
###    my $fs_enable = ($tmp & 8) ? 1 : 0;
    my $fs_enable = (($tmp >> 3) & 1);
    print "\t\tFS enable: $fs_enable\n";
#    print "EIS FOV flag: ", sprintf((($tmp >> 1) & 3)), "\n";
    print "\t\tEIS FOV flag: ", (($tmp >> 1) & 3), "\n";
    print "\t\tSpare: ", $tmp & 1, "\n";
}

sub translate_EIS_flare_trigger_table {
    my $string = shift;
    my $l = length $string;
    my $bytes = substr($string, 9, ($l - 9));

    print "\nEIS flare trigger table:\n";
    my $tmp = byte(0, $bytes);
    print "\t\tSeq no: 0x", $tmp, " (", sprintf("%u", hex($tmp)), ")\n";
    my $byte1 = hex(byte(1, $bytes));
    my $byte2 = hex(byte(2, $bytes));
    my $rasterId = (($byte1 << 8) | $byte2);
    print "\t\tRaster ID: 0x", sprintf("%04X", $rasterId), " ($rasterId)\n";
    print "\t\tFlags: 0x", sprintf("%02X\n", hex(byte(3, $bytes)));
    $tmp = get_32bit_value(4, $bytes);

    print "\t\tX Threshold: 0x$tmp (", sprintf("%u", hex($tmp)), ")\n";
    $tmp = get_32bit_value(8, $bytes);
    print "\t\tY Threshold: 0x$tmp (", sprintf("%u", hex($tmp)), ")\n";
    $tmp = get_32bit_value(12, $bytes);
    print "\t\tY CAM start address: 0x$tmp\n";
    $tmp = get_32bit_value(16, $bytes);
    print "\t\tY CAM height address: 0x$tmp\n";

    print "\t\tX min limit: 0x", byte(20, $bytes), "\n";
    print "\t\tY min limit: 0x", byte(21, $bytes), "\n";
    print "\t\tEIS pixel size: 0x", byte(22, $bytes), "\n";
    print "\t\tReserved: ", byte(23, $bytes), "\n";


}

sub translate_EIS_event_trigger_table {
    my $string = shift;
    my $l = length $string;
    my $bytes = substr($string, 9, ($l - 9));

    print "\nEIS event trigger table:\n";
    my $tmp = byte(0, $bytes);
    print "\t\tSeq no: 0x", $tmp, " (", sprintf("%u", hex($tmp)), ")\n";
    my $byte1 = hex(byte(1, $bytes));
    my $byte2 = hex(byte(2, $bytes));
    my $rasterId = (($byte1 << 8) | $byte2);
    print "\t\tRaster ID: 0x", sprintf("%04X", $rasterId), " ($rasterId)\n";
    print "\t\tFlags: 0x", sprintf("%02X\n", hex(byte(3, $bytes)));
    $tmp = get_32bit_value(4, $bytes);

    print "\t\tX Threshold: 0x$tmp (", sprintf("%u", hex($tmp)), ")\n";
    $tmp = get_32bit_value(8, $bytes);
    print "\t\tY Threshold: 0x$tmp (", sprintf("%u", hex($tmp)), ")\n";
    $tmp = get_32bit_value(12, $bytes);
    print "\t\tY start address: 0x$tmp\n";
    $tmp = get_32bit_value(16, $bytes);
    print "\t\tY height address: 0x$tmp\n";

#    print "X min limit: 0x", byte(20, $bytes), "\n";
#    print "Y min limit: 0x", byte(21, $bytes), "\n";
#    print "EIS pixel size: 0x", byte(22, $bytes), "\n";
#    print "Reserved: ", byte(23, $bytes), "\n";


}

