#!/usr/bin/perl

# Looks for an eis plan file with today's date four times a day. Kicked off by cron.
# Keeps a list of pending plans for 7 days.

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

my $pending_dir = "$HOME/tmp/pending_eis_plans";
my $cmdpln = "$HOME/eisco/cmdpln/latest";
my $eisco = "$HOME/eisco/EIS_CPT_output/eis_plan";

##goto foo;

open(LOG, ">> $pipeline_log/eis_plan_cron.txt");
#($log, $perform, $title) = init_log_and_perform(*LOG, "interactive");
$current_time = scalar(localtime);
print LOG "$current_time\n";

foo:
@today = today();	# @today[0..6] = seconds,minutes,hours,day,month,year,day_of_week (0 = sunday)
#
# If today is sunday then don't do anything
#
if($today[6] == 0) {
    print LOG "\teis_plan_cron not running - sunday\n\n";
    finish(0);
}

#
# Split today's date up
#
$year  = sprintf "%04u", $today[5];	# Get starting year
$month = sprintf "%02u", $today[4];	# Get starting month
$day   = sprintf "%02u", $today[3];	# Get starting day
$today = "$year$month$day";

#
# Deal with pending files
#
my @pending_files = `ls $pending_dir`;
##print STDOUT "PENDING FILES: [@pending_files]\n";

if(@pending_files) {
    print LOG "\tTesting pending files:\n";
##    print STDOUT "\tTesting pending files:\n";
    foreach $file (@pending_files) {
	chomp $file;
	$pfile = "$pending_dir" . "/" . "$file";
##	print STDOUT "Testing file: $pfile\n";
	if(-M $pfile > 7) {		# Remove file if it's age is greater than 7 days
	    print LOG "\tRemoving $file from pending list: too old\n";
##	    print STDOUT "\tRemoving $file from pending list: too old\n";
	    system("/bin/rm $pfile");
	    next;
	}
#	else {
#	    print STDOUT "$pfile is not older than 7 days\n";
#	}
	next if $file eq $today;	# Will be checking today's file later
	$src_file = "eis_plan_" . $file . ".txt";
	system("/bin/rm $pfile") if copy_if_found($src_file, $eisco);
    }
    print LOG "\tFinished with pending files.\n";
##    print STDOUT "\tFinished with pending files.\n";
}
else {
    print LOG "\tNo pending plans\n";
##    print STDOUT "\tNo pending plans\n";
}

#
# Make the source filename, see if it has already been copied.
#
$src_file = "eis_plan_" . $today . ".txt";
@files = `ls $HOME/data/staging/eis_plan/$src_file`;
print LOG "\tFile $src_file already found\n" if @files;
finish(0) if @files;

#
# If there is a matching file in eisco's latest directory then copy it across
#
finish(0) if copy_if_found($src_file, $eisco);
finsih(0) if copy_if_found($src_file, $cmdpln);

# File not found, add to pending directory
system("/bin/touch $pending_dir/$today");
finish(0);
#close(LOG);
#system("/bin/cp $pipeline_log/eis_plan_cron.txt $HOME/data/staging/eis_plan/");

sub copy_if_found {
    my $file = shift;
    my $src  = shift;

    print LOG "\tLooking for $file in $src\n";
    my @files = `ls $src/$file`;
    if(@files) {
	print LOG "\tFound $file in $src\n";
	system("/bin/cp $src/$file $HOME/data/staging/eis_plan/");
#	system("/bin/cp $src/$file $HOME/data/staging/eis_plan/$year$month/");
#	system("gzip -f $HOME/data/staging/eis_plan/$year$month/$file");
	system("/bin/cp $src/$file $HOME/data/staging/eis_plan/$year/");
#	system("gzip -f $HOME/data/staging/eis_plan/$year/$file");
	return 1;
    }
    print LOG "\t$file not found in $src\n";
    return 0;
}

sub finish {
    my $code = shift;
    close(LOG);
    system("/bin/cp $pipeline_log/eis_plan_cron.txt $HOME/data/staging/eis_plan/");
    exit $code;
}
