#!/usr/local/bin/perl
# estimate_rasters < /data/Hinode/DARTS/staging/eis_plan/eis_plan_20080614.txt

# Lookup table to find engineering rasters which produce mission data
my %eng = (regcal015 => 1,
	   regcal016 => 1,
	   regcal017 => 1,
	   regcal018 => 1,
	   regcal067 => 1,
	   regcal068 => 1,
	   regcal070 => 1,
	   regcal071 => 1,
	   regcal072 => 1,
	   regcal073 => 1,
	   regcal074 => 1,
	   regcal075 => 1,
	   regcal076 => 1,
	   regcal077 => 1,
	   regcal078 => 1,
	   regcal079 => 1,
	   regeng015 => 0,
	   regeng020 => 0,
	   regeng021 => 0,
	   regeng022 => 0,
	   regeng023 => 0,
	   regeng024 => 0,
	   comcal076 => 1,
	   comcal077 => 1,
	   comcal078 => 1,
	   comcal079 => 1,
	   comcal080 => 1,
	   comcal081 => 1,
	   );

# Number of rasters for each engineering study
my %eng_ra_id = (regcal015 => 1,
		 regcal016 => 1,
		 regcal017 => 1,
		 regcal018 => 1,
		 regcal067 => 1,
		 regcal068 => 1,
		 regcal070 => 1,
		 regcal071 => 1,
		 regcal072 => 1,
		 regcal073 => 1,
		 regcal074 => 1,
		 regcal075 => 1,
		 regcal076 => 1,
		 regcal077 => 1,
		 regcal078 => 1,
		 regcal079 => 1,
		 regeng015 => 0,
		 regeng020 => 0,
		 regeng021 => 0,
		 regeng022 => 0,
		 regeng023 => 0,
		 regeng024 => 0,
		 comcal076 => 1,
		 comcal077 => 1,
		 comcal078 => 1,
		 comcal079 => 1,
		 comcal080 => 1,
		 comcal081 => 1,
		 );

# (for i in `ls eis_plan_200805*`; do estimate_rasters.pl < $i | awk -f /home/mcrw/Hinode/bin/raster_numbers.awk ; done) | awk ' { tot += $1; } END { print tot }' -

# Read first 5 lines of the plan and throw away
$line_count = 0;
while(<>) {
    last if $line_count++ == 4;
}
#foreach $l (0 .. 4) {
#    <>;
#}

# Marker to get start date and time
$first = 1;

# Read through the rest of the plan
while(<>) {
    # Found a timeline entry
    #	Extract the timeline id
    if(/^TL/) {
	(@tl_stuff) = split;
	$tl_id = sprintf "%u", $tl_stuff[1];
	next;
    }
    # Determine whether this is a science or engineering entry
    if(/^SCI_OBJ/) {
	$eng = (m/SCI_OBJENG /) ? 1 : 0;
	@sci_obj_stuff = split;
	# Read in study entry and split into elements
	$_ = <>;
	@study_stuff = split;
	# Extract the start date and start time of entire plan if this is the first timeline entry found
	if($first) {
	    $start_date = $study_stuff[3];
	    $start_time = $study_stuff[4];
	    $first = 0;
	}
	# Get end date and time of this study
	$end_date = $study_stuff[5];
	$end_time = $study_stuff[6];

	# Process an engineering study if reg or com
	if(($study_stuff[2] =~ /regcal/) ||
	   ($study_stuff[2] =~ /regeng/) ||
	   ($study_stuff[2] =~ /comcal/) ||
	   ($study_stuff[2] =~ /comeng/) ||
	   ($eng == 1)) {
	    # Get number of rasters for this engineering study
	    $ra_acr = $study_stuff[2];
	    $rasters = 0;
	    if(defined($eng{$ra_acr})) {
		$rasters = $eng{$ra_acr};
	    }
	    else {
		print STDERR "NO DEFINITION FOR ENGINEERING RASTER [$ra_acr]\n";
	    }
	    # Extract rest of engineering study details
	    $st_id = sprintf "%u", $study_stuff[1];
	    $study_stuff[1] = $st_id;
	    $st_start_date = $study_stuff[3];
	    $st_start_time = $study_stuff[4];
	    $st_end_date = $study_stuff[5];
	    $st_end_time = $study_stuff[6];
	    $st_duration = $study_stuff[7];

	    if(defined($eng_ra_id{$ra_acr})) {
		$ra_id = $eng_ra_id{$ra_acr};
	    }
	    else {
		$ra_id = -1;
	    }
            $st_id = sprintf "%u", $study_stuff[1];
	    # Print out the engineering study details
	    print "TL $tl_id ST $st_id $ra_acr RA $ra_id $ra_acr $study_stuff[3] $study_stuff[4] $study_stuff[5] $study_stuff[6] $study_stuff[7] Engineering $rasters size xpoint ypoint $st_start_date $st_start_time $st_end_date $st_end_time $st_duration\n";
#	    print "TL $tl_id ST $study_stuff[1] STUDY_ACRONYM RA -1 $ra_acr $study_stuff[3] $study_stuff[4] $study_stuff[5] $study_stuff[6] $study_stuff[7] Engineering $rasters size xpoint ypoint\n";
	}
	else {
	    # Normal science study
	    $st_id = sprintf "%u", $study_stuff[1];
	    $st_acr = $study_stuff[2];
	    $st_start_date = $study_stuff[3];
	    $st_start_time = $study_stuff[4];
	    $st_end_date = $study_stuff[5];
	    $st_end_time = $study_stuff[6];
	    $st_duration = $study_stuff[7];

	    # # Get rid of RA ID      Acronym... line
	    <>;

	    # Read in the rasters for the study
	    while(<>) {
		# Get the study details
		if(/^ST/) {
		    @st_stuff = split;
		    # Save the start date and time for the entire plan if this is the first timeline entry
		    if($first) {
			$start_date = $st_stuff[3];
			$start_time = $st_stuff[4];
			$first = 0;
		    }
		    $end_date = $st_stuff[5];
		    $end_time = $st_stuff[6];
		    next;
		}
		# A blank line seperates timeline entries
		last if /^$/;
		# Split the raster details
		@stuff = split;
		#
		# Check here to see if the duration field has not overflown into the type field
		#
		$stuff_len = @stuff;	# Correct length is 13
		if($stuff_len == 12) {
		    $mucky_stuff = $stuff[7];
		    $pat = "Scan" if $mucky_stuff =~ /Scan/;
		    $pat = "SNS" if $mucky_stuff =~ /SNS/;
		    @duration = split(/$pat/, $mucky_stuff);
		    @stuff_copy = @stuff;
		    $stuff_copy[7] = $duration[0];
		    $stuff_copy[8] = $&;
		    $stuff_copy[9] = $stuff[8];
		    $stuff_copy[10] = $stuff[9];
		    $stuff_copy[11] = $stuff[10];
		    $stuff_copy[12] = $stuff[11];
		    @stuff = @stuff_copy;
		}
		$stuff[9] =~ s/x//;
		$ra_id = sprintf "%u", $stuff[1];
		$stuff[1] = $ra_id;
		# Output the timeline entry
		print "TL $tl_id ST $st_id $st_acr @stuff $st_start_date $st_start_time $st_end_date $st_end_time $st_duration\n";
	    }
	}
    }
}

# Output the plan start and end dates/times
print "$start_date $start_time $end_date $end_time\n";

