#!/usr/local/bin/perl
# estimate_rasters < /data/Hinode/DARTS/staging/eis_plan/eis_plan_20080614.txt

my %eng = (regcal015 => 1,
           regcal016 => 1,
           regcal017 => 1,
           regcal018 => 1,
           regcal067 => 1,
           regcal068 => 1,
           regcal070 => 1,
           regcal071 => 1,
           regcal072 => 1,
           regcal073 => 1,
           regcal074 => 1,
           regcal075 => 1,
           regcal076 => 1,
           regcal077 => 1,
           regcal078 => 1,
           regcal079 => 1,
           regeng015 => 0,
           regeng020 => 0,
           regeng021 => 0,
           regeng022 => 0,
           regeng023 => 0,
           regeng024 => 0,
           );

# (for i in `ls eis_plan_200805*`; do estimate_rasters.pl < $i | awk -f /home/mcrw/Hinode/bin/raster_numbers.awk ; done) | awk ' { tot += $1; } END { print tot }' -

<>;
<>;

while(<>) {
    if(/^TL/) {
        (@tl_stuff) = split;
        $tl_id = sprintf "%u", $tl_stuff[1];
        next;
    }
    if(/^ST/) {
        @study_stuff = split;
	$st_id = sprintf "%u", $study_stuff[1];
	$st_start_date = $study_stuff[3];
	$st_start_time = $study_stuff[4];
	$st_end_date = $study_stuff[5];
	$st_end_time = $study_stuff[6];
	$st_duration = $study_stuff[7];
	
	
	if(($study_stuff[2] =~ /regcal/) ||
           ($study_stuff[2] =~ /regeng/) ||
           ($study_stuff[2] =~ /comcal/) ||
           ($study_stuff[2] =~ /comeng/)) {

            $ra_acr = $study_stuff[2];
            $rasters = 0;
            if(defined($eng{$ra_acr})) {
                $rasters = $eng{$ra_acr};
            }

#            print "TL $tl_id ST $study_stuff[1] $ra_acr RA -1 $ra_acr $study_stuff[3] $study_stuff[4] $study_stuff[5] $study_stuff[6] $study_stuff[7] Engineering $rasters size xpoint ypoint $st_start_date $st_start_time $st_end_date $st_end_time $st_duration\n";
            print "TL $tl_id ST $st_id $ra_acr RA -1 $ra_acr $study_stuff[3] $study_stuff[4] $study_stuff[5] $study_stuff[6] $study_stuff[7] Engineering $rasters size xpoint ypoint $st_start_date $st_start_time $st_end_date $st_end_time $st_duration\n";
        }
        else {
#            $st_id = sprintf "%u", $study_stuff[1];
            $st_acr = $study_stuff[2];
            while(<>) {
                last if /^$/;
                @stuff = split;
                $stuff[9] =~ s/x//;
                $ra_id = sprintf "%u", $stuff[1];
                $stuff[1] = $ra_id;
                print "TL $tl_id ST $st_id $st_acr @stuff $st_start_date $st_start_time $st_end_date $st_end_time $st_duration\n";
            }
        }
    }
}
