#!/usr/local/bin/perl

use Env qw(EGSE_SW_LIB);
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

# exposure_count < md_hdrs_yyymmdd.html
# Loop through md_headers dump getting the packet count per exposure value for each ccsds file

my %ra_db;

print "# Filename                  Ppe  Num exps    Tl_id Reps_req Reps_done   Rid   Mid full_x full_y   ExpPerPos  Data_vol\n";

########if(open RD, "< $HOME/eisco/reformatter/raster_db_dump.txt") {
if(open RD, "< $HOME/data/staging/dump/raster_db_dump.txt") {
    while(<RD>) {
	next if /Id/;
	chomp;
	($id, $acr, $type, $nexps) = split;
	$rid = sprintf "%u", $id;
	$ra_db{$rid} = [$acr, $type, $nexps];
    }
    close RD;
}

##########if(open RD, "< $HOME/eisco/reformatter/eng_raster_dump.txt") {
if(open RD, "< $HOME/data/staging/dump/eng_raster_dump.txt") {
    while(<RD>) {
	next if /Id/;
	chomp;
	($id, $acr, $type, $nexps, $pe) = split;
	$rid = sprintf "%u", $id;
	$ra_db{$rid} = [$acr, $type, $nexps, $pe];
    }
    close RD;
}

while(<>) {
    last if /^\<pre\>/;
}

while(<>) {
    while(<>) {
#        next if /^$/;
	if(/^$/) {
	    $done = 0;
	    next;
	}
        last if /eis_md/;
    }

    chomp;
    $fname = $_;
    $fname = substr $fname, -26, 26;

    $last_no_wrap_filename = 'eis_md_20190108_1228428105';
    $first_wrap_filename   = 'eis_md_20190108_1234149331';

    while(<>) {
        next if /^Type/;
        next if /^Pixel data/;
        last if /^Read/;
        last if /headers/;
        last if /ccsds/;
	next if $done;
	if($done == 0) {
	    @data = split;
	    $packets_per_exposure = sprintf "%u", $data[6];
	    $number_of_exposures  = sprintf "%u", hex($data[32]);
	    $timeline_id          = sprintf "%u", hex($data[24]);

#
# Before final reformat change this so it copes with the early data.
# This is for the timeline id wrap around which occurred on 20190108...
#
	    #if ($timeline_id < 65000) {
		#$timeline_id += 65536;
	    #}
	    # This doesn't take into account flare response raster ids
	    # which are 0 - 4 ...
	    if ($fname gt $last_no_wrap_filename) {
		$timeline_id += 65536;
	    }

	    $raster_reps_req      = sprintf "%u", hex($data[34]);
	    $raster_reps_done     = sprintf "%u", hex($data[35]);
	    $rid                  = sprintf "%u", hex($data[25]);
	    $ra_acronym           = ra_acr($rid);
	    $mid                  = sprintf "%u", hex($data[3]);
	    $full_x               = sprintf "%u", hex($data[11]);
	    $full_y               = sprintf "%u", hex($data[12]);
	    $exp_per_pos          = sprintf "%u", $data[55];
	    $data_volume = $full_x * $full_y;
	    $done = 1;
	    if($fname ne "") {
		write;
	    }
	}
	last if /^<\/pre>/;
    }
}


format STDOUT = 
@<<<<<<<<<<<<<<<<<<<<<<<<< @### @########  @######    @####     @#### @>>>> @>>>>  @####  @####          @# @######## @>>>>>>>>>>>>>>>>>>>>>>>>>
$fname, $packets_per_exposure, $number_of_exposures, $timeline_id, $raster_reps_req, $raster_reps_done, $rid, $mid, $full_x, $full_y, $exp_per_pos, $data_volume, $ra_acronym
.


sub ra_acr {
    my $key = shift;
#    print "Looking for [$key]\n";
#    print "FOO = ", $ra_db{100}, "\n";
#    foreach $k (sort keys %ra_db) {
#	my @l = @{$ra_db{$key}};
#	print "[$key] = ", $l[0], "\n";
#    }
#    exit;
###    if(defined($ra_db{$rid})) {
    if(defined($ra_db{$key})) {
	my @list = @{$ra_db{$key}};
#    print "list = ", @list, "\n";
	return $list[0];
    }
    return "Unknown";
}
