#!/usr/local/bin/perl

# exposure_count < md_hdrs_yyymmdd.html
# Loop through md_headers dump getting the packet count per exposure value for each ccsds file

print "# Filename                  Ppe  Num exps  Tl_id Reps_req Reps_done   Rid   Mid full_x full_y   ExpPerPos  Data_vol\n";

while(<>) {
    while(<>) {
        next if /^$/;
        last if /eis_md/;
    }

    chomp;
    $fname = $_;
    $fname = substr $fname, -26, 26;

    while(<>) {
        next if /^Type/;
        next if /^Pixel data/;
        last if /^Read/;
        last if /headers/;
        last if /ccsds/;
        @data = split;
#	$data_volume          = sprintf("%u", hex($data[1])) - 256;
        $packets_per_exposure = sprintf "%u", $data[6];
	$number_of_exposures  = sprintf "%u", hex($data[32]);
	$timeline_id          = sprintf "%u", hex($data[24]);
	$raster_reps_req      = sprintf "%u", hex($data[34]);
	$raster_reps_done     = sprintf "%u", hex($data[35]);
	$rid                  = $data[25];
	$rid =~ s/^0+// unless $rid eq "0000";
	$mid                  = $data[3];
	$mid =~ s/^0+// unless $mid eq "0000";
	$mid = 0 if $mid eq "0000";
	$full_x               = sprintf "%u", hex($data[11]);
	$full_y               = sprintf "%u", hex($data[12]);
	$exp_per_pos          = sprintf "%u", $data[55];
#	$data_volume = $full_x * $full_y * $exp_per_pos;	# * num exposures to be really accurate
	$data_volume = $full_x * $full_y;
    }

    if($fname ne "") {
#        print "$fname\t";
#        print "$packets_per_exposure\t$number_of_exposures\t$data_volume\t$timeline_id\t$raster_reps_req\t$raster_reps_done\t$rid\t$mid\t$full_x\t$full_y\n";
	write;
    }
}


format STDOUT = 
@<<<<<<<<<<<<<<<<<<<<<<<<< @### @########  @####    @####     @#### @>>>> @>>>>  @####  @####          @# @######## 
$fname, $packets_per_exposure, $number_of_exposures, $timeline_id, $raster_reps_req, $raster_reps_done, $rid, $mid, $full_x, $full_y, $exp_per_pos, $data_volume
.


