#!/usr/local/bin/perl -W

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

# Instead of die-ing would be better to report the error in a file somewhere
# and then exit. This applies to all instances of die of course. Todo.

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";
do "$EGSE_SW_LIB/pipeline.pl"      || die "Can't do pipeline.pl: $!\n";

my $sdate = "20110329";
my $bool  = 0;
my $msg   = "";

my @expected_exposures_list = exposures_list_from_orl($sdate, \$bool, \$msg);
print "$sdate: $bool, $msg, @expected_exposures_list\n";

sub exposures_list_from_orl {
    my $date = shift;
    my $bool_ref = shift;
    my $msg_ref = shift;

    my $src_file = "EIS_" . "$date" . "????.orl";
    my $file = `/bin/ls $orl_dir/$src_file`;
    if($file eq "") {
	$$msg_ref = "Can't find orl file for $date\n";
	return ();
    }
    chomp $file;
    if(!open(ORL, "< $file")) {
	$$msg_ref = "Can't open orl file $file\n";
	return ();
    }
#    print "Reading from $file\n";
    my $line = "";
    while(<ORL>) {
	next if /^[ \t]*$/;
	next if /^[ \t]*START:OPOG_UPLOAD_TI/;
	if(/^[ \t]*START/) {
	    # Read 3 more lines to skip past dump obstbl line
#	    <ORL>;
#	    <ORL>;
#	    <ORL>;
#	    print "Last skip: $_";
	    last;
	}
    }
#    print "FOO: $_";
    while(<ORL>) {
#	print "LINE = $_";
	last if /^[ \t]*\/\*\-/;
	next unless /^[ \t]*START/;
#	print "LINE1 = $_";
	chomp;
	decode($_);
    }
    close ORL;
#    print "Last line read: $_";
}

sub decode {
    my $line = shift;
    print "$line\n";
    my $num  = substr $line, -9, 3;
    print "$num\n";
    return;

}
