#!/usr/local/bin/perl
# Read ccsds_hdrs.yyyymmdd.txt file.
# Determine which exposures are damaged.
# Skip past first 2 lines

print "# Filename\t\t   Md_headers\n";

<>;
<>;

while(<>) {
    if(/eis_md/) {
        chomp;
        $fname = $_;
        $fname = substr $fname, -26, 26;
        $in_exposure = 0;
        $missing = 0;
        $md_header_count = 0;
        next;
    }
    next if /^Time/;
    @hdr = split(/,/, $_);
    if($hdr[5] == 1) {
        $in_exposure = 1;
        $missing = 0;
        next;
    }
    if(/Missing packets:/) {
        $missing = 1;
        next;
    }
    if($hdr[5] == 2) {
        ++$md_header_count if $missing == 0;
        $missing = 0;
        $in_exposure = 0;
        next;
    }
    if(/^$/) {
	write;
#        print "$fname\t$exposure_count\n";
        next;
    }
    next if /ccsds/;
    next if /^Number/;
}
write;

format STDOUT =
@<<<<<<<<<<<<<<<<<<<<<<<<<    @######
$fname, $md_header_count
.


