#!/bin/awk -f

function report(yyyymm, type, tot, factor) {
  if(tot != 0) {
    printf("%s %6s %8d %8.2f\n", type, yyyymm, tot, factor / tot)
      }
  else {
    printf("%s %6s %8d %8.2f\n", type, yyyymm, tot, tot)
      }
}

BEGIN {
 
}
 
/DPCM/ { ++dpcm_tot
           dpcm_factor += $5 }
 
/JPEG_98/ { ++jpeg98_tot
           jpeg98_factor += $5 }
 

/JPEG_95/ { ++jpeg95_tot
           jpeg95_factor += $5 }

/JPEG_92/ { ++jpeg92_tot
           jpeg92_factor += $5 }
 
/JPEG_90/ { ++jpeg90_tot
           jpeg90_factor += $5 }
 
/JPEG_85/ { ++jpeg85_tot
           jpeg85_factor += $5 }
 
/JPEG_75/ { ++jpeg75_tot
           jpeg75_factor += $5 }
 
/JPEG_65/ { ++jpeg65_tot
           jpeg65_factor += $5 }
 
/JPEG_50/ { ++jpeg50_tot
           jpeg50_factor += $5 }
 
 
END {
  report("dpcm", yyyymm, dpcm_tot, dpcm_factor)
  report("jpeg98", yyyymm, jpeg98_tot, jpeg98_factor)
  report("jpeg95", yyyymm, jpeg95_tot, jpeg95_factor)
  report("jpeg92", yyyymm, jpeg92_tot, jpeg92_factor)
  report("jpeg90", yyyymm, jpeg90_tot, jpeg90_factor)
  report("jpeg85", yyyymm, jpeg85_tot, jpeg85_factor)
  report("jpeg75", yyyymm, jpeg75_tot, jpeg75_factor)
  report("jpeg65", yyyymm, jpeg65_tot, jpeg65_factor)
  report("jpeg50", yyyymm, jpeg50_tot, jpeg50_factor)
}
