#!/usr/local/bin/perl

use Compress::Zlib;
use integer;
use Env qw(EGSE_SW_LIB);
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

my %header;
my %card_image;

my $has_extension = 0;


my @types = ("ADC Offset",
	     "Short Darks",
	     "Long Darks",
	     "Short Flats",
	     "Long Flats",
	     "Intensity Calibration",
	     "EUV",
	     "Flat Oscn",
	     "Dark Bottom",
	     "Dark Top",
	     "Reduced Long",
	     "Dark Prescan",
	     "Dark Daily",
	     "1exp_100ms",
	     "2exps_80ms",
	     "Dark Bottom 0s",
	     "Dark Top 0s",
#	     "Pointing and Alignment",
	     );

print "Filename                      TLID STID        STUDY ACRONYM                  TYPE         TARGET             DATE OBS             DATE END     DURATION DONE  REQ\n";

#$path = "$HOME/data/mission";
$path = "$HOME/work/localdata/pipeline/fits";
foreach $type (@types) {
    $filepath = $path . eng_path($type) . "*";
    @files = `ls $filepath`;
    next unless @files;
    foreach my $filename (@files) {
	chomp $filename;
	my $buffer;
	my $gzf = gzopen($filename, "rb") or die "Can't gzopen $filename: ", $gzf->gzerror;
	my $fname = $filename;
	$fname =~ s/\.gz//;
	$fname = substr $fname, -27, 27;
	my $going = 1;
	while($going) {
	    $bytes_read = $gzf->gzread($buffer, 2880);
	    for($i = 0; $i < 36; ++$i) {
		$record = substr($buffer, 80 * $i, 80);
		($keyword, $rest) = split '=', $record;
		$keyword =~ s/ //g;
		next if $keyword =~ /^COMMENT/;
		next if $keyword =~ /^CONTINUE/;
		($value, $comment) = split '/', $rest;
		$value =~ s/\'//g;
		$value =~ s/^ //;
		$value =~ s/[ ]{2,}//;
		$value =~ s/[ ]+$//;
		if($keyword =~ /^END/) {
		    $going = 0;
		    last;
		}
		$has_extension = 1 if $record =~ /^EXTEND  =                    T/;
		$card_image{$keyword} = $value;
	    }
	}
	$card_image{"filename"} = $fname;

	%{$header{"Primary"}} = %card_image;
	%card_image = ();
	
	if($has_extension) {
	    $going = 1;
	    while($going) {
		$bytes_read = $gzf->gzread($buffer, 2880);
		for($i = 0; $i < 36; ++$i) {
		    $record = substr($buffer, 80 * $i, 80);
		    ($keyword, $rest) = split '=', $record;
		    $keyword =~ s/ //g;
		    next if $keyword =~ /^COMMENT/;
		    next if $keyword =~ /^CONTINUE/;
		    ($value, $comment) = split '/', $rest;
		    $value =~ s/\'//g;
		    $value =~ s/^ //;
		    $value =~ s/[ ]{2,}//;
		    $value =~ s/[ ]+$//;
		    if($keyword =~ /^END/) {
			$going = 0;
			last;
		    }
		    $header_name = $value if $keyword =~ /^EXTNAME/;
		    $card_image{$keyword} = $value;
		}
	    }
	    $header_name =~ s/\'//g;
	    $header_name =~ s/ //g;
	    %{$header{$header_name}} = %card_image;
	}

	$gzf->gzclose();

#    print keys %header, "\n";
#    header();
	dump_hdr($type, %header);

    }
    print "\n";
}

sub value_for_key {
    my $hdr = shift;
    my $key = shift;
    return ${%{$header{$hdr}}}{$key};
}

sub value_for_primary_key {
    my $key = shift;
    return value_for_key("Primary", $key);
}

sub dump_hdr {
    my $type = shift;
    my %dict = shift;
    my $fname = value_for_primary_key("filename");
    my $seq_nr = value_for_key("Primary", "SEQ_NR");
    my $study_id = value_for_key("Primary", "STUDY_ID");
    my $rast_id = value_for_key("Primary", "RAST_ID");
    my $tl_id = value_for_key("Primary", "TL_ID");
    my $stud_acr = value_for_key("Primary", "STUD_ACR");
    my $rast_acr = value_for_key("Primary", "RAST_ACR");
    my $target = value_for_key("Primary", "TARGET");
#    $target =~ s/ $//;
    $target =~ s/ /_/ if $target =~ / /;
    my $date_obs = value_for_key("Primary", "DATE_OBS");
    my $date_end = value_for_key("Primary", "DATE_END");

    $date_obs =~ s/\.000//;
    $date_end =~ s/\.000//;

    my $rast_req = value_for_key("Primary", "RAST_REQ");
#    my $rast_pfd = value_for_key("Primary", "RREP_PFD");
    my $nexp = value_for_key("Primary", "NEXP");
#    my $nraster = value_for_key("Primary", "NRASTER");
    my $duration = duration($date_obs, $date_end);

    my($ccda_tmin, $ccda_tmax, $ccdb_tmin, $ccdb_tmax) = get_ccd_temperatures();

#    format = 
#@>>>>>>>>>>>>>>>>>>>>>>>>>>@>>> @>>>> @>>>>>>>>>>>>>>>>>>>  @>>>>>>>>>>>>>>>>>>>  @>>>>>>>>>>>>>  @>>>>>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>>>>>>>>>>>>>   @>>>>>>>>>>> @>>>>@>>>>
#$fname, $seq_nr, $rast_id, $stud_acr, $rast_acr, $target, $date_obs, $date_end, $duration, $nexp, $rast_req
#.
#    write;

    format = 
@>>>>>>>>>>>>>>>>>>>>>>>>>>@>>>>>>@>>>> @>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>>> @>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>@>>>>@>>>> @###.## @###.## @###.## @###.##
$fname, $tl_id, $study_id, $stud_acr, $type, $target, $date_obs, $date_end, $duration, $nexp, $rast_req, $ccda_tmin, $ccda_tmax, $ccdb_tmin, $ccdb_tmax
.
    write;
}

#sub header {
#    format = 
#@<<<<<<<<<<<<<<<<<<<<<<<<<<@>>> @>>>> @>>>>>>>>>>>>>>>>>>>  @>>>>>>>>>>>>>>>>>>>  @>>>>>>>>>>>>>  @>>>>>>>>>>>>>>>>>>>>>>> @>>>>>>>>>>>>>>>>>>>>>>>   @>>>>>>>>>>> @>>>>@>>>>
#"Filename", "SEQ", "RAST", "STUDY ACRONYM", "RASTER ACRONYM", "TARGET", "START DATE", "END DATE", "DURATION", "DONE", "REQ"
#.
#    write;
#}

# Input: "2007-06-29T23:44:44.000"
# Input: "2007-06-30T00:44:44.000"

# Input: "2007-06-30T23:44:44.000"
# Input: "2007-07-01T00:44:44.000"
sub duration {
    my $start_str = shift;
    my $end_str = shift;

    my $start_mth  = sprintf("%u", substr($start_str, 5, 2));
    my $start_day  = sprintf("%u", substr($start_str, 8, 2));
    my $start_hr   = sprintf("%u", substr($start_str, 11, 2));
    my $start_min  = sprintf("%u", substr($start_str, 14, 2));
    my $start_sec  = sprintf("%u", substr($start_str, 17, 2));

    my $end_mth  = sprintf("%u", substr($end_str, 5, 2));
    my $end_day  = sprintf("%u", substr($end_str, 8, 2));
    my $end_hr   = sprintf("%u", substr($end_str, 11, 2));
    my $end_min  = sprintf("%u", substr($end_str, 14, 2));
    my $end_sec  = sprintf("%u", substr($end_str, 17, 2));

    $end_hr += 24 if $end_day > $start_day;
    $end_hr += 24 if $end_mth > $start_mth;

    my $time_start = (($start_hr * 3600) + ($start_min * 60) + $start_sec);
    my $time_end   = (($end_hr   * 3600) + ($end_min   * 60) + $end_sec);
    my $diff       = $time_end - $time_start;

    my $output = "";
    my $days = sprintf("%02u", $diff / 86400);
    $diff = $diff - ($days * 86400);
    $output .= ("$days" . "d") if $days != 0;

    my $hours = sprintf("%02u", ($diff / 3600));
    $diff = $diff - ($hours * 3600);
    $output .= ("$hours" . "h") if $hours != 0;

    my $mins = sprintf("%02u", ($diff / 60));
    $diff = $diff - ($mins * 60);
    $output .= ("$mins" . "m");

    my $secs = sprintf("%02u", $diff);
    $output .= ("$secs" . "s");

    return $output;

    return "$diff" . "s";
}

sub get_ccd_temperatures {
    my $ccda_key = key_for_value("DATA", "CCDAT_TI");
    my $ccdb_key = key_for_value("DATA", "CCDBT_TI");

    return(999.99, 999.99, 999.99, 999.99) if $ccda_key eq "";
    return(999.99, 999.99, 999.99, 999.99) if $ccdb_key eq "";

    $ccda_key =~ s/^TTYPE//;
    $ccdb_key =~ s/^TTYPE//;

    my $a_min = value_for_key("DATA", "TDMIN$ccda_key");
    my $a_max = value_for_key("DATA", "TDMAX$ccda_key");
    my $b_min = value_for_key("DATA", "TDMIN$ccdb_key");
    my $b_max = value_for_key("DATA", "TDMAX$ccdb_key");

    return($a_min, $a_max, $b_min, $b_max);
}

sub key_for_value {
    my $hdr   = shift;
    my $value = shift;
    my $key;

    foreach $key (keys %{$header{$hdr}}) {
	return $key if $value eq value_for_key($hdr, $key);
    }
    return "";
}
