#!/usr/bin/perl

# ./fits_header_dump /soda/hinode/eis/level0/2014/10/01/eis_l0_20141001_221140.fits.gz
# ./fits_header_dump /soda/hinode/eis/level0/2014/10/01/eis_l0*

use Compress::Zlib;

my %header;
my %card_image;

my $has_extension = 0;

foreach my $filename (@ARGV) {
    my $buffer;
    my $gzf = gzopen($filename, "rb") or die "Can't gzopen $filename: $gzerro\n";

    print STDOUT "$filename\n";

    my $going = 1;
    while($going) {
	$bytes_read = $gzf->gzread($buffer, 2880);
	for($i = 0; $i < 36; ++$i) {
	    $record = substr($buffer, 80 * $i, 80);
	    ($keyword, $rest) = split '=', $record;
	    $keyword =~ s/ //g;
	    
	    next if $keyword =~ /^COMMENT/;
#	    next if $keyword =~ /^CONTINUE/;

	    ($value, $comment) = split '/', $rest;
	    $value =~ s/\'//g;
	    $value =~ s/^ //;
#	    $value =~ s/[ ]*//;
	    $value =~ s/[ ]{2,}//;
#	    print "keyword = [$keyword]\tvalue = [$value]\tcomment = [$comment]\n";

	    if($keyword =~ /^CONTINUE\'\'/) {
		if(($previous_keyword eq 'SCI_OBJ') || ($previous_keyword eq 'OBSTITLE' || ($previous_keyword eq 'OBS_DEC'))) {
		    $keyword = $previous_keyword;
		    $previous_value .= $value;
		    $value = $previous_value;
		}
	    }

	    $previous_keyword = $keyword;
	    $previous_value = $value;

	    if($keyword =~ /^END/) {
		$going = 0;
		last;
	    }
	    $has_extension = 1 if $record =~ /^EXTEND  =                    T/;
	    $card_image{$keyword} = $value;
	} # End of for($i = 0; $i < 36; ++$i) {

#	print STDERR "$buffer\n";
	goto temp_skip;
	print STDOUT "Primary:\n";
	foreach $k (sort keys %card_image) {
	    print STDOUT $k, "=", $card_image{$k}, "\n";
	}
	print "\n";
temp_skip:
    }
###    next;

#    print "Has extension: $has_extension\n";

    %{$header{"Primary"}} = %card_image;

    foreach $k (sort keys %{$header{"Primary"}}) {
#	print "$k=", ${%{$header{"Primary"}}}{$k}, "\n";
	print "$k=", $header{"Primary"}->{$k}, "\n";
    }
    print "\n";

#    goto skip_data;
    %card_image = ();
#    goto skip;
    if($has_extension) {
	$going = 1;
	while($going) {
	    $bytes_read = $gzf->gzread($buffer, 2880);
	    for($i = 0; $i < 36; ++$i) {
		$record = substr($buffer, 80 * $i, 80);
		($keyword, $rest) = split '=', $record;
		$keyword =~ s/ //g;

		next if $keyword =~ /^COMMENT/;

		($value, $comment) = split '/', $rest;
		$value =~ s/\'//g;
		$value =~ s/^ //;
#		$value =~ s/[ ]*//;
		$value =~ s/[ ]{2,}//;
#		print "keyword = [$keyword]\tvalue = [$value]\tcomment = [$comment]\n";

		if($keyword =~ /^CONTINUE/) {
		    if(($previous_keyword eq 'SCI_OBJ') || ($previous_keyword eq 'OBSTITLE' || ($previous_keyword eq 'OBS_DEC'))) {
			$keyword = $previous_keyword;
			$previous_value .= $value;
			$value = $previous_value;
		    }
		}

		$previous_keyword = $keyword;
		$previous_value = $value;

		if($keyword =~ /^END/) {
#		    print "Found END\n";
		    $going = 0;
		    last;
		}
		$header_name = $value if $keyword =~ /^EXTNAME/;
		$card_image{$keyword} = $value;
	    }

	}
	$header_name =~ s/\'//g;
	$header_name =~ s/ //g;
	%{$header{$header_name}} = %card_image;
#	print STDOUT "Header: $header_name\n";
	goto skip_working_bit;
	foreach $k (sort keys %card_image) {
	    print STDOUT $k, "=", $card_image{$k}, "\n";
	}
skip_working_bit:
    }
skip_data:;
skip:
    $gzf->gzclose();

#    print keys %header, "\n";
#    foreach $h (keys %header) {
#	print "$h header keys:\n";
#	foreach $k (sort keys %{$header{"$h"}}) {
#	    print "$k\t", ${%{$header{"$h"}}}{$k}, "\n";
#	}
#	print "\n";
#    }

#    print "Primary header keys:\n";
#    foreach $k (sort keys %{$header{"Primary"}}) {
#	print "$k\t", ${%{$header{"Primary"}}}{$k}, "\n";
#    }
#    print "\n";

    print "DATA header keys:\n";
#    goto skip1;
    foreach $k (sort keys %{$header{"DATA"}}) {
	print "$k=", $header{"DATA"}->{$k}, "\n";
    }
    print "--- END ---\n";
skip1:

#    print "SAA = ", value_for_key("Primary", "SAA"), "\n";
#    print "STUD_ACR = ", value_for_key("Primary", "STUD_ACR"), "\n";
#    print "DATE_OBS = ", value_for_key("Primary", "DATE_OBS"), "\n";
#    print "DATE_END = ", value_for_key("Primary", "DATE_END"), "\n";
#    print "TFORM1 = ", value_for_key("DATA", "TFORM1"), "\n";
#    print "\n";

#    $ccdat_key = key_for_value("DATA", "CCDAT_TI");
#    print "Key for CCDAT_TI = $ccdat_key\n";
#    if($ccdat_key ne "") {
##	$ccdat_num = substr $ccdat_key, -1; 
#	$ccdat_key =~ s/^TTYPE//;
#	print "ccdat_key = $ccdat_key\n";
#	$foo = value_for_key("DATA", "TDMIN" . "$ccdat_key");
#	print "TDMIN", $ccdat_key, "\t", value_for_key("DATA", "TDMIN" . "$ccdat_key"), "\n";
#	print "TDMAX$ccdat_key\t", value_for_key("DATA", "TDMAX$ccdat_key"), "\n";
#    }
    print "\n";
}


sub value_for_key {
    my $hdr = shift;
    my $key = shift;
    return ${%{$header{$hdr}}}{$key};
}

sub value_for_primary_key {
    my $key =shift;
    return value_for_key("Primary", $key);
}

sub key_for_value {
    my $hdr   = shift;
    my $value = shift;
    my $key;

    foreach $key (keys %{$header{$hdr}}) {
	return $key if $value eq value_for_key($hdr, $key);
    }
    return "";
}
