#!/usr/bin/perl

# ./fits_header_dump1 /soda/hinode/eis/level0/2014/10/01/eis_l0_20141001_221140.fits.gz
# ./fits_header_dump1 /soda/hinode/eis/level0/2014/10/01/eis_l0*
# ./fits_header_dump1 /soda/hinode/eis/level0/2023/01/02/eis_l0_20230102_012501.fits.gz | sort | uniq
# ./fits_header_dump1 /soda/hinode/eis/level0/2023/01/02/eis_l0_20230102_012501.fits.gz | sort | uniq | awk '{$2=$4=""; print $0}'

use Compress::Zlib;

my %header;
my %card_image;

my $has_extension = 0;
my ($previous_keyword, $previous_value, $previous_comment);

foreach my $filename (@ARGV) {
    my $gzf = gzopen($filename, "rb") or die "Can't gzopen $filename: $gzerro\n";

    print STDOUT "$filename\n";

    my $repeat = dump_header($gzf);
    dump_header($gzf) if $repeat;
    $gzf->gzclose();
    print STDOUT "\n";
}

sub dump_header {
    my $gzf = shift;
    my $buffer;

    my $first = 1;
    my $going = 1;
    my $continue = 0;
    while($going) {
	$bytes_read = $gzf->gzread($buffer, 2880);
	for($i = 0; $i < 36; ++$i) {
	    $record = substr($buffer, 80 * $i, 80);
	    ($keyword, $rest) = split '=', $record;
	    
	    # Assigning to previous makes them out of order (interleaved)
	    if (($keyword =~ 'COMMENT') || ($keyword =~ 'HISTORY')) {
		$previous_keyword = substr $keyword, 0, 7;
		$previous_comment = substr $record, 8, -1;
		$previous_value = '';
		write STDOUT; #"\n$keyword\n";
		next;
	    }

#	    if ($keyword =~ 'HISTORY') { print STDOUT "\n$keyword\n\n"; next; }

	    if ($keyword =~ 'CONTINUE') {
		$continue = 1;
		$keyword = substr $record, 0, 8;
		$rest = substr $record, 9, -1;
		($value, $comment) = split ' / ', $rest;
		chop $previous_value;
		chop $previous_value;
		$value =~ s/'//;
		$previous_value .= $value;
		$previous_comment = $comment;
#		print STDOUT "\n$keyword, $previous_keyword : $value, $previous_value : $previous_comment\n";
##		print STDOUT "\nCONTINUE : $previous_keyword, $previous_value, $previous_comment\n";
	    }
	    
	    $keyword =~ s/ //g;

	    ($value, $comment) = split ' / ', $rest unless $keyword =~ 'CONTINUE';
###	    ($value, $comment) = split ' / ', $rest unless $continue;
	    
#	    if ($keyword eq 'TUNIT46') { print "KEYWORD = $keyword, value = $value\n"; }
	    
#		$value =~ s/\'//g;
		$value =~ s/^ //;
##		$value =~ s/[ ]*//;
#		$value =~ s/[ ]{2,}//;
	    
	    if (!(($keyword eq 'TARGET') || ($keyword eq 'SCI_OBJ') || ($keyword eq 'OBS_DEC') ||
		  ($keyword eq 'ST_AUTH') || ($keyword eq 'OBSERVER') || ($keyword eq 'PLANNER') ||
		  ($keyword eq 'TOHBANS'))) {
		$value =~ s/[ ]*//g;
	    }
	    $value =~ s/[ ]{2,}//g;

	    $comment =~ s/^\s//;
	    $comment =~ s/\s+$//;

	    if ($first) {
		$previous_keyword = $keyword;
		$previous_value   = $value;
		$previous_comment = $comment;
		$first = 0;
		next;
	    }

###		print STDOUT "keyword = [$keyword]\tvalue = [$value]\tcomment = [$comment]\n";
	    write STDOUT;

	    if ($continue) {
		$continue = 0;
		$first = 1;
#		next;
	    }

	    $previous_keyword = $keyword;
	    $previous_value   = $value;
	    $previous_comment = $comment;

	    $has_extension = 1 if $record =~ /^EXTEND  =                    T/;
	    if($keyword =~ /^END/) {
		$going = 0;
		last;
	    }
	}
    }
    return $has_extension;
}

format STDOUT =
@<<<<<<<<= @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< : @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$previous_keyword, $previous_value, $previous_comment
.
