#!/usr/bin/perl
 
use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

if($#ARGV == 0) {
    $search_name = shift;
}
elsif($#ARGV == 1) {
    $opt = shift;
    $search_name = shift;
}
else {
    print "Usage: fits_name [-e] ccsds_file_name\n";
    exit;
}

#$dbase_path = "$pipeline_log/mission_name_dbase";
#$dbase_path = "$pipeline_log/engineering_name_dbase" if $opt eq "-e";

$dbase_name = "mission_name_dbase";
$dbase_name = "engineering_name_dbase" if $opt eq "-e";
$dbase = "$pipeline_log/$dbase_name";

#if(dbmopen(%trans, "$pipeline_log/mission_name_dbase", undef)) {
if(dbmopen(%dbase, $dbase, undef)) {
    $fits_file = $dbase{$search_name};
    if($fits_file) {
	print STDOUT "$search_name => $fits_file\n";
    }
    else {
	print STDOUT "No translation for $search_name in $dbase_name\n";
    }
    dbmclose(%dbase);
}
else {
    print STDERR "Can't open or find the database $dbase_name\n";
}


