#!/usr/bin/perl

use Env qw(EGSE_SW_LIB);
do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

#use Parse::RecDescent;
#use PDL;

die;

$date_string = "20080808";
$year = "2008";
$month = "08";
$day = "08";

# Log locations during processing
$sdtp_fetch_log         = "$pipeline_log/md_fetch_$date_string.txt";

$md_hdr_check_log       = "$merge_dir/md_hdr_check.txt";
$ccsds_packet_check_log = "$merge_dir/ccsds_hdr_check.txt";
#$shutter_log            = "$hutter_log/shutter.txt";
$plan_file              = "$darts_staging/eis_plan/eis_plan_$year$month$day.txt";
$missing_file           = "$darts_mission/$year/$month/packet_check/ccsds_hdrs.$year$month$day.txt";

$md_decompress_log      = "$pipeline_log/md_decompress_$date_string.txt";
$md_decompress_log_slim = "$darts_staging/logs/decompression/md_decompress_$date_string.txt";

$fits_reformat_log      = "$pipeline_log/md_reformat_$date_string.txt";

$rescue_decomp_log      = "";
$rescue_reformat_log    = "";

# Locations on DARTS
$darts_md_hdr_check_log       = "$darts_mission/$year/$month/packet_check/md_hdrs.$year$month$day.html";
$darts_ccsds_packet_check_log = "$darts_mission/$year/$month/packet_check/ccsds_hdrs.$year$month$day.txt";
$darts_shutter_log            = "$staging/logs/";



print "\$sdtp_fetch_log         = $sdtp_fetch_log\n";

print "\$md_hdr_check_log       = $md_hdr_check_log\n";
print "\$ccsds_packet_check_log = $ccsds_packet_check_log\n";
print "\$shutter_log            = $shutter_log\n";
print "\$plan_file              = $plan_file\n";
print "\$missing_file           = $missing_file\n";

print "\$md_decompress_log      = $md_decompress_log\n";
print "\$md_decompress_log_slim = $md_decompress_log_slim\n";

print "\$fits_reformat_log      = $fits_reformat_log\n";

print "\$rescue_decomp_log      = $rescue_decomp_log\n";
print "\$rescue_reformat_log    = $rescue_reformat_log\n";

# Locations on DARTS
print "\$darts_md_hdr_check_log       = $darts_md_hdr_check_log\n";
print "\$darts_ccsds_packet_check_log = $darts_ccsds_packet_check_log\n";
print "\$darts_shutter_log            = $darts_shutter_log\n";


