/*
 * 2010/03/18 Revison 33
 *   modified by Keiichi Matsuzaki
 */

#include <stdio.h>
#include <math.h>
#include <string.h>
// using memcpy
#include "DePacketizeBody.h"

// #define dbg(...) (printf("%s(%u) %s(): ",__FILE__,__LINE__,__func__),printf(__VA_ARGS__),printf("\n"))
#define dbg(...)

/*
 * Maximum number of RSTn + EOI markers 
 * 
 * In the extreme case following combination of parameter is allowed in the interface
 *   PartImageSizeX = 64, PartImageSizeY = 4k
 * For DPCM, restart_pixel will be 4k which is the maximum. 
 * Note: The real instrument of EIS does not produce such data.
 *
 * added by KM notice *6
 */
#define MAX_RST 4096

#define NUM_APID 8

static int before_sq_flag_array[NUM_APID] = {-1,-1,-1,-1,-1,-1,-1,-1};     //CCSDSV[PXtO  (O̒lƂĕێj
static int before_sq_count_array[NUM_APID]= {-1,-1,-1,-1,-1,-1,-1,-1};     //CCSDSV[PXJEg(O̒lƂĕێj
static int status_array[NUM_APID] = {                                      // state of DePacketizeBody
  NOT_JPEG_DATA,                                                           // shall be one of BUFF_NOW, NOT_JPEG_DATA, JPEG_IRRETRIEVABLE
  NOT_JPEG_DATA,
  NOT_JPEG_DATA,
  NOT_JPEG_DATA,
  NOT_JPEG_DATA,
  NOT_JPEG_DATA,
  NOT_JPEG_DATA,
  NOT_JPEG_DATA,
};

/*
 * obt@̓Yʒu
 *
 * only valid if status = BUFF_NOW
 * initialized @ GetSciHead()
 * updated @ add_rst(), add_eoi(), trunc_recovered(), fill_gap(), 
 *           insert_dct_header(), insert_dpcm_header()
 */
static int buff_pos_array[NUM_APID] = {0};

static int restart_pixel_arrayXXX[NUM_APID]; // CÂ *2 ɊւāAԂςȂߍ폜ȂB
static int num_segment_arrayXXX[NUM_APID];   // CÂ *2 ɊւāAԂςȂߍ폜ȂB

/*
 * only valid if status = BUFF_NOW
 * should have valid value for indexes [0] .. [buff_pos-1]
 * initizlized by initialization of buff_pos
 *
 * KM does not understand meaning of 1024*1024 although the result seems correct.
 * 256K pixel * 2byte/pixel * 2 (maximum compression factor, i.e. failed compression)
 */
static unsigned char buffer_array[NUM_APID][MAX_COMP_LEN];   //Ɨpobt@

/*
 * JPEGf[^CtO@1:C
 * 
 * only valid if status = BUFF_NOW
 * cleared @ GetSciHead
 * set @ add_rst(), add_eoi()
 *
 * { rst_tbl[*].flg ̗LȒl̉ꂩ 1 邱ƂƓ`łׂƎvA
 * CÂ *3) ɋL悤 pPbg EOI ǂݍ񂾏ꍇA
 * CÂ *4) ɋL悤 X^[g}[JVɑ}ȂꍇA
 * ݂ȂƎvȀꍇvȂB
 */
static int restored_flag_array[NUM_APID] = {0};           
static int _apidXXX;                                      //CÂ *2 ɊւāAԂςȂߍ폜ȂB
static int apid_flag;                                     //͂ꂽCCSDSpPbgAPIDɑΉzԍ
static int ptnflg4_10_arrayXXX[NUM_APID] = {0};           //CÂ *2 ɊւāAԂςȂߍ폜ȂB

/*
 * ܂łɓ͂ RSTn ̌
 * only valid if status = BUFF_NOW
 * initialized @ GetSciHead()
 * upadated @ add_rst(), fill_gap(), DePacketizeBody()
 */
static int num_RST_array[NUM_APID] = {0};                 

/*
 * 摜 data ̐擪ʒu
 *
 * only valid if status = BUFF_NOW  first packet ̎̃pPbgMȍ~
 * initialized @ header_insert A͐ packet M
 * ȈӖŌ 16384 pPbgꍇ fail safe l
 * only valid if status = BUFF_NOW
 * initialized @ GetSciHead()
 * upadated @ add_rst(), fill_gap(), DePacketizeBody()
 */
static int ECS0_start_array[NUM_APID]={0};

struct sci_head_t _sci_head_array[NUM_APID];
static unsigned char _chk_tbl_arrayYYY[6][1024*1024]; // CÂ *2 ɊւāAԂςȂߍ폜ȂB
static unsigned char _chk_tbl[MAX_PIXELS]; 
static unsigned char _chk_tbl_arrayXXX[1][1024*1024]; // CÂ *2 ɊւāAԂςȂߍ폜ȂB

/*
 * 摜f[^C`FbNtO
 *
 * [].pos should have valid value for indexes [0] .. [num_RST-1]
 * [].No  should have valid value for indexes [0] .. [num_RST-1]
 * [].flg should have valid value for indexes [0] .. [num_RST]
 *
 * only valid if status = BUFF_NOW
 * initialized by initialization of num_RST
 * upadated @ add_rst(), add_eoi(), fill_gap(), DePacketizeBody()
 *
 * CÂ *3) ɋL悤 pPbg EOI ǂݍ񂾏ꍇA
 * [num_RST].flg slɂȂƎvB
 */
static struct rst_tbl_t rst_tbl_array[NUM_APID][MAX_RST];

// CÂ *2 ɊւāAԂςȂ static t^ȂB
struct bin_head_t _bin_head_array[NUM_APID];             // JPEG f[^̃oCiwb_
// CÂ *2 ɊւāAԂςȂ static t^ȂB
struct jpg_time_t _jpg_time_array[NUM_APID];             // JPEG f[^̑1pPbgҏW

// CÂ *2 ɊւāAԂςȂ static t^ȂB
const int datainfo_len_array[NUM_APID]={                 // length of data information for each data type
  48, 48, 48, 48, 64, 64, 224, 224
};

/*
  Modified: rst_tbl, buff_pos, buffer, Output: restored_flag
 */

static void add_rst(int p1, int p2, int p3) {

  /* defintiion of file internal variable refferences */

  int *num_RST              = &(num_RST_array         [apid_flag]);    // output
  struct rst_tbl_t *rst_tbl   = &(rst_tbl_array       [apid_flag][0]); // modified
  int *buff_pos             = &(buff_pos_array        [apid_flag]);    // modified
  unsigned char *buffer     =   buffer_array          [apid_flag];     // modified
  int *restored_flag        = &(restored_flag_array   [apid_flag]);    // output

  /* */

  int i, j, n;

  j = p1;
  for ( i=p2 ; i < p3 ; i++ ) {
    j++;
    n = j % 8;
    rst_tbl[i].pos = *buff_pos;
    rst_tbl[i].No  = n;
    rst_tbl[i].flg = 1; // recovery flag for RSTn
    buffer[(*buff_pos)++] = 0xFF;
    buffer[(*buff_pos)++] = 0xD0 | n;
  }
  //  (*num_RST) = i;

  *restored_flag = 1;
}

/*
  Input: num_RST, Modified: rst_tbl, buff_pos, buffer
 */

static void add_eoi(){

  /* defintiion of file internal variable refferences */

  int *num_RST              = &(num_RST_array  [apid_flag]);    // input
  struct rst_tbl_t *rst_tbl = &(rst_tbl_array  [apid_flag][0]); // modified
  int *buff_pos             = &(buff_pos_array [apid_flag]);    // modified
  unsigned char *buffer     =   buffer_array   [apid_flag];     // modified
  int *restored_flag        = &(restored_flag_array   [apid_flag]);    // output

  /* */

  buffer[(*buff_pos)++] = 0xFF;
  buffer[(*buff_pos)++] = 0xD9;
  rst_tbl[*num_RST].flg = 1; // recovery flag for EOI

  *restored_flag = 1;
}

/*
  Input: _sci_head.num_segment, Modified: num_RST, rst_tbl, buff_pos, buffer
 */

static void fill_tail()
{
  /* defintiion of file internal variable refferences */
  const struct sci_head_t _sci_head =  _sci_head_array   [apid_flag];     // input
  int *num_RST                      = &(num_RST_array    [apid_flag]);    // modified
  struct rst_tbl_t *rst_tbl         = &(rst_tbl_array    [apid_flag][0]); // modified

  /* */

  const int num_segment =  _sci_head.num_segment;

  /* */
  
  dbg("%d %d %d\n", rst_tbl[*num_RST-1].No, *num_RST, num_segment-1);

  add_rst(rst_tbl[*num_RST-1].No, *num_RST, num_segment-1);
  // Modified: rst_tbl, buff_pos, buffer, Output: restored_flag

  if( *num_RST < num_segment-1 ) *num_RST = num_segment-1; // [KM51][KM54][KM55]

  add_eoi();
  // Input: num_RST, Modified: rst_tbl, buff_pos, buffer
}

/*
  @return 0:succeed, not 0:failed

  Input: _sci_head.num_segment, Modified: num_RST, rst_tbl, buff_pos, buffer
 */

static int trunc_recovered()
{
  /* defintiion of file internal variable refferences */
  const struct sci_head_t _sci_head =  _sci_head_array   [apid_flag];     // input
  int *num_RST                      = &(num_RST_array    [apid_flag]);    // modified
  struct rst_tbl_t *rst_tbl         = &(rst_tbl_array    [apid_flag][0]); // modified
  int *buff_pos                     = &(buff_pos_array   [apid_flag]);    // modified

  /* */

  const int num_segment =  _sci_head.num_segment;

  /* */

  int i, wk;

  /* ǉꏊ̌ */
  wk = -1;
  for (i=0; i<*num_RST; i++) {
    if (rst_tbl[i].flg == 1) {
      wk = i;
      break;
    }
  }

  if (wk == -1) {
    return -1;
  }

  /* ǉꏊȍ~폜 */
  *buff_pos = rst_tbl[wk].pos;

  add_rst(rst_tbl[wk].No - 1, wk, num_segment-1);
  // Modified: rst_tbl, buff_pos, buffer, Output: restored_flag

  *num_RST = num_segment-1;

  add_eoi();
  // Input: num_RST, Modified: rst_tbl, buff_pos, buffer

  return 0;
}

/*
  Input: ECS0_start, Modified: num_RST, rst_tbl, buff_pos, buffer
 */

void fill_gap(const unsigned char *packet, int data_length, int packetpos, int rst2ndNo)
{
  /* defintiion of file internal variable refferences */
  int ECS0_start              =   ECS0_start_array    [apid_flag];     // input
  int *num_RST                = &(num_RST_array       [apid_flag]);    // modified
  struct rst_tbl_t *rst_tbl   = &(rst_tbl_array       [apid_flag][0]); // modified
  int *buff_pos               = &(buff_pos_array      [apid_flag]);    // modified
  unsigned char *buffer       =   buffer_array        [apid_flag];     // modified

  /* */

  int packet_first_rstNo;
  int buff_end_rstNo;
  int markpos;
  int i;

  packet_first_rstNo = rst2ndNo;                             //CCSDSpPbg̍ŏɌ
  //RSTԍ
  if (*num_RST > 0) {
    /* obt@RSTnꍇ */
    buff_end_rstNo = rst_tbl[*num_RST-1].No;  //obt@̍ŌRST̔ԍ
    *buff_pos = rst_tbl[*num_RST-1].pos; //obt@̍ŌRST̈ʒu
    *buff_pos += 2;
  } else {
    /* obt@RSTnȂꍇ */
    buff_end_rstNo = -1;
    *buff_pos = ECS0_start;
  }
#if 0
  if (packet_first_rstNo < buff_end_rstNo) {
#else
    // KM notice *4 from here
  if (packet_first_rstNo <= buff_end_rstNo) {
    // KM notice *4 until here
#endif
    packet_first_rstNo += 8;
  }
  /* RSTobt@ɒǉ */

  const int num_RST1 = *num_RST + packet_first_rstNo - buff_end_rstNo;
  add_rst(buff_end_rstNo, *num_RST, num_RST1);
  // Modified: rst_tbl, buff_pos, buffer, Output: restored_flag

  *num_RST = num_RST1; // [KM53][KM56] KM note *5)
  
  /*
   *********************************************
   *
   *@CCSDSpPbg̍ŏRST̃f[^
   *@obt@ɒǉ
   *
   *********************************************
   */
  
  markpos = -1;
  for (i=packetpos+2; i<data_length; i++) {
    const unsigned char octet = packet[i+10];

    buffer[*buff_pos] = octet;
    if (octet == 0xFF) {
      markpos = *buff_pos;
    } else {
      if (markpos >= 0) {
	const int rst2nd = octet & RST2ND_MASK; 
	rst2ndNo = octet & RSTNO_MASK;
	if (rst2nd == 0xD0) {                //RSTn
	  rst_tbl[*num_RST].pos = markpos;
	  rst_tbl[*num_RST].No  = rst2ndNo;
	  rst_tbl[*num_RST].flg = 0;
	  (*num_RST)++;
	}
      }
      markpos = -1; 
    }
    (*buff_pos)++;
  }
}


/*
  Output: _chk_tbl
*/

static void clear_chktbl() {
  memset(_chk_tbl, 0, sizeof(_chk_tbl));
}

/*
  摜f[^CɃtOP𗧂Ă

  Input: _sci_head, num_RST, rst_tbl, output: _chk_tbl
 */

static void fill_chktbl() {

  /* defintiion of file internal variable refferences */

  const struct sci_head_t _sci_head =   _sci_head_array     [apid_flag];     // input
  const int num_RST                 =   num_RST_array       [apid_flag];     // input
  const struct rst_tbl_t *rst_tbl   = &(rst_tbl_array       [apid_flag][0]); // input

  /* */

  const int restart_pixel           =   _sci_head.restart_pixel;

  /* */

  int dpcm_col, dpcm_row;
  int i;

  int tmp=0; //////

  const int partx = _sci_head.PartImageSizeX;
  const int party = _sci_head.PartImageSizeY;

  switch(_sci_head.ImageCompMode) {
  case COMP_MODE_DCT12:                      //DPCMk
    dpcm_col = 8*64;
    dpcm_row = 8;
    break;
  case COMP_MODE_DPCM12:
    dpcm_col = partx;
    dpcm_row = restart_pixel / partx;
    break;
  }
  
  dbg("head = %d %d %d", _sci_head.PartImageSizeX, restart_pixel, num_RST);

  for (i=0; i<num_RST+1; i++) {

    int ii, jj;
    int wk;

    dbg("rst = %d", i);

    int OffsetX = i * dpcm_col;
    int OffsetY = 0;

    OffsetY += (OffsetX/partx)*dpcm_row;
    OffsetX %=          partx;

    if (rst_tbl[i].flg == 1) {
      wk = 1;
    } else {
      wk = 0;
    }

    for (ii=0; ii < dpcm_row; ii++) {
      for (jj=0; jj < dpcm_col; jj++) {

	int x = OffsetX + jj;
	int y = OffsetY + ii;

	y += (x/partx)*dpcm_row;
	x %=    partx;

	if ( y < party ) {

	  const int k = y * partx + x;
	  _chk_tbl[k] = wk;

	  tmp += (1 - wk); //////
	}
      }
    }
  }
  dbg("pixel = %d\n", tmp);
}

const unsigned char DQT_Pattern0[128] =                       //ʎqe[u`O
{
    0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,
    0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,
    0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x02,0x00,0x02,0x00,0x02,
    0x00,0x01,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x03,0x00,0x02,0x00,0x02,0x00,0x02,
    0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
    0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x04,0x00,0x04,0x00,0x03,
    0x00,0x03,0x00,0x03,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x03,0x00,0x04,0x00,0x05,
    0x00,0x05,0x00,0x04,0x00,0x04,0x00,0x05,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04
};

const unsigned char DQT_Pattern1[128] =                      //ʎqe[u`P
{
    0x00,0x03,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x03,0x00,0x03,
    0x00,0x03,0x00,0x03,0x00,0x04,0x00,0x04,0x00,0x03,0x00,0x04,0x00,0x04,0x00,0x06,
    0x00,0x05,0x00,0x05,0x00,0x05,0x00,0x05,0x00,0x06,0x00,0x0A,0x00,0x09,0x00,0x08,
    0x00,0x06,0x00,0x08,0x00,0x09,0x00,0x0A,0x00,0x0D,0x00,0x0C,0x00,0x0B,0x00,0x0B,
    0x00,0x0B,0x00,0x0B,0x00,0x0C,0x00,0x0D,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x0E,
    0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x11,0x00,0x13,0x00,0x13,0x00,0x11,
    0x00,0x0F,0x00,0x10,0x00,0x15,0x00,0x15,0x00,0x15,0x00,0x10,0x00,0x13,0x00,0x17,
    0x00,0x17,0x00,0x13,0x00,0x13,0x00,0x18,0x00,0x13,0x00,0x14,0x00,0x14,0x00,0x14
};

const unsigned char DQT_Pattern2[128] =                      //ʎqe[u`Q
  {
    0x00,0x08,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x08,0x00,0x07,
    0x00,0x07,0x00,0x08,0x00,0x0B,0x00,0x09,0x00,0x08,0x00,0x09,0x00,0x0B,0x00,0x10,
    0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x10,0x00,0x19,0x00,0x17,0x00,0x13,
    0x00,0x0F,0x00,0x13,0x00,0x17,0x00,0x19,0x00,0x21,0x00,0x1F,0x00,0x1C,0x00,0x1B,
    0x00,0x1B,0x00,0x1C,0x00,0x1F,0x00,0x21,0x00,0x25,0x00,0x25,0x00,0x26,0x00,0x22,
    0x00,0x26,0x00,0x25,0x00,0x25,0x00,0x26,0x00,0x2A,0x00,0x30,0x00,0x30,0x00,0x2A,
    0x00,0x26,0x00,0x28,0x00,0x34,0x00,0x34,0x00,0x34,0x00,0x28,0x00,0x2F,0x00,0x3B,
    0x00,0x3B,0x00,0x2F,0x00,0x30,0x00,0x3C,0x00,0x30,0x00,0x33,0x00,0x33,0x00,0x32
  };

const unsigned char DQT_Pattern3[128] =                      //ʎqe[u`R
  {
    0x00,0x10,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0F,0x00,0x0E,
    0x00,0x0E,0x00,0x0F,0x00,0x15,0x00,0x12,0x00,0x10,0x00,0x12,0x00,0x15,0x00,0x20,
    0x00,0x18,0x00,0x17,0x00,0x17,0x00,0x18,0x00,0x20,0x00,0x32,0x00,0x2E,0x00,0x26,
    0x00,0x1D,0x00,0x26,0x00,0x2E,0x00,0x32,0x00,0x42,0x00,0x3E,0x00,0x38,0x00,0x36,
    0x00,0x36,0x00,0x38,0x00,0x3E,0x00,0x42,0x00,0x4A,0x00,0x4A,0x00,0x4C,0x00,0x44,
    0x00,0x4C,0x00,0x4A,0x00,0x4A,0x00,0x4C,0x00,0x54,0x00,0x5F,0x00,0x5F,0x00,0x54,
    0x00,0x4C,0x00,0x50,0x00,0x67,0x00,0x68,0x00,0x67,0x00,0x50,0x00,0x5E,0x00,0x75,
    0x00,0x75,0x00,0x5E,0x00,0x60,0x00,0x78,0x00,0x60,0x00,0x66,0x00,0x66,0x00,0x63
  };

const unsigned char DQT_Pattern4[128] =                      //ʎqe[u`S
  {
    0x00,0x02,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x02,0x00,0x01,
    0x00,0x01,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x03,
    0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x03,0x00,0x05,0x00,0x05,0x00,0x04,
    0x00,0x03,0x00,0x04,0x00,0x05,0x00,0x05,0x00,0x07,0x00,0x06,0x00,0x06,0x00,0x05,
    0x00,0x05,0x00,0x06,0x00,0x06,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x08,0x00,0x07,
    0x00,0x08,0x00,0x07,0x00,0x07,0x00,0x08,0x00,0x08,0x00,0x0A,0x00,0x0A,0x00,0x08,
    0x00,0x08,0x00,0x08,0x00,0x0A,0x00,0x0A,0x00,0x0A,0x00,0x08,0x00,0x09,0x00,0x0C,
    0x00,0x0C,0x00,0x09,0x00,0x0A,0x00,0x0C,0x00,0x0A,0x00,0x0A,0x00,0x0A,0x00,0x0A
  };

const unsigned char DQT_Pattern5[128] =                      //ʎqe[u`T
  {

    0x00,0x03,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,
    0x00,0x02,0x00,0x02,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x05,
    0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x05,0x00,0x08,0x00,0x07,0x00,0x06,
    0x00,0x05,0x00,0x06,0x00,0x07,0x00,0x08,0x00,0x0B,0x00,0x0A,0x00,0x09,0x00,0x09,
    0x00,0x09,0x00,0x09,0x00,0x0A,0x00,0x0B,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0B,
    0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0D,0x00,0x0F,0x00,0x0F,0x00,0x0D,
    0x00,0x0C,0x00,0x0D,0x00,0x10,0x00,0x11,0x00,0x10,0x00,0x0D,0x00,0x0F,0x00,0x13,
    0x00,0x13,0x00,0x0F,0x00,0x0F,0x00,0x13,0x00,0x0F,0x00,0x10,0x00,0x10,0x00,0x10
  };

const unsigned char DQT_Pattern6[128] =                      //ʎqe[u`U
  {
    0x00,0x05,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x05,0x00,0x04,
    0x00,0x04,0x00,0x05,0x00,0x06,0x00,0x05,0x00,0x05,0x00,0x05,0x00,0x06,0x00,0x0A,
    0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x0A,0x00,0x0F,0x00,0x0E,0x00,0x0B,
    0x00,0x09,0x00,0x0B,0x00,0x0E,0x00,0x0F,0x00,0x14,0x00,0x13,0x00,0x11,0x00,0x10,
    0x00,0x10,0x00,0x11,0x00,0x13,0x00,0x14,0x00,0x16,0x00,0x16,0x00,0x17,0x00,0x14,
    0x00,0x17,0x00,0x16,0x00,0x16,0x00,0x17,0x00,0x19,0x00,0x1D,0x00,0x1D,0x00,0x19,
    0x00,0x17,0x00,0x18,0x00,0x1F,0x00,0x1F,0x00,0x1F,0x00,0x18,0x00,0x1C,0x00,0x23,
    0x00,0x23,0x00,0x1C,0x00,0x1D,0x00,0x24,0x00,0x1D,0x00,0x1F,0x00,0x1F,0x00,0x1E
  };

const unsigned char DQT_Pattern7[128] =                      //ʎqe[u`V
  {
    0x00,0x0B,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x0B,0x00,0x0A,
    0x00,0x0A,0x00,0x0B,0x00,0x0F,0x00,0x0D,0x00,0x0B,0x00,0x0D,0x00,0x0F,0x00,0x16,
    0x00,0x11,0x00,0x10,0x00,0x10,0x00,0x11,0x00,0x16,0x00,0x23,0x00,0x20,0x00,0x1B,
    0x00,0x14,0x00,0x1B,0x00,0x20,0x00,0x23,0x00,0x2E,0x00,0x2B,0x00,0x27,0x00,0x26,
    0x00,0x26,0x00,0x27,0x00,0x2B,0x00,0x2E,0x00,0x34,0x00,0x34,0x00,0x35,0x00,0x30,
    0x00,0x35,0x00,0x34,0x00,0x34,0x00,0x35,0x00,0x3B,0x00,0x43,0x00,0x43,0x00,0x3B,
    0x00,0x35,0x00,0x38,0x00,0x48,0x00,0x49,0x00,0x48,0x00,0x38,0x00,0x42,0x00,0x52,
    0x00,0x52,0x00,0x42,0x00,0x43,0x00,0x54,0x00,0x43,0x00,0x47,0x00,0x47,0x00,0x45
  };

const unsigned char DHTDC_Pattern[32] =                     //nt}e[u`icbjNo.0
  {
    0x00,0x01,0x05,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F
  };

const unsigned char DHTAC_Pattern1[258] =                   //nt}e[u`i`bjNo.1
  {
    0x00,0x02,0x01,0x02,0x04,0x03,0x06,0x03,0x04,0x07,0x02,0x03,0x00,0x00,0x02,0xCB,
    0x01,0x02,0x03,0x04,0x11,0x00,0x05,0x06,0x21,0x07,0x12,0x31,0x08,0x13,0x22,0x41,
    0x51,0x61,0x09,0x71,0x81,0x14,0x32,0x91,0xA1,0x0A,0x15,0x23,0x42,0xB1,0xC1,0xF0,
    0xD1,0xE1,0x16,0x24,0x33,0x52,0x72,0xF1,0x17,0x43,0x62,0x82,0x92,0xA2,0xB2,0x18,
    0x19,0x25,0x34,0x53,0x54,0x73,0x83,0x93,0x26,0x27,0x36,0x44,0x55,0x63,0xC2,0xD2,
    0x35,0x45,0x64,0x76,0x84,0x94,0xA3,0xB3,0x29,0x65,0x74,0xD3,0xE2,0x0B,0x0C,0x0D,
    0x0E,0x0F,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x28,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x37,
    0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,
    0x4E,0x4F,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,0x66,0x67,0x68,0x69,
    0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x75,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
    0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,0x95,0x96,0x97,0x98,0x99,
    0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,
    0xAE,0xAF,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC3,0xC4,
    0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,0xD4,0xD5,0xD6,0xD7,0xD8,
    0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,
    0xEC,0xED,0xEE,0xEF,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,
    0xFE,0xFF
  };

const unsigned char DHTAC_Pattern2[258] =                  //nt}e[u`i`bjNo.2
  {
    0x00,0x01,0x02,0x04,0x03,0x02,0x07,0x05,0x07,0x08,0x09,0x09,0xB9,0x00,0x00,0x00,
    0x01,0x02,0x11,0x00,0x03,0x04,0x21,0x05,0x12,0x31,0x22,0x41,0x06,0x13,0x51,0x61,
    0x71,0x81,0x91,0x14,0x32,0xA1,0xB1,0xF0,0x07,0x23,0x42,0x72,0x92,0x93,0xC1,0x15,
    0x52,0x62,0x82,0xA2,0xB2,0xD1,0xE1,0x16,0x24,0x33,0x43,0x44,0x53,0x83,0xA3,0xF1,
    0x08,0x17,0x26,0x34,0x54,0x63,0x73,0x84,0xB3,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
    0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x25,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,
    0x2E,0x2F,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x45,0x46,0x47,
    0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,
    0x5D,0x5E,0x5F,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x74,
    0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x85,0x86,0x87,0x88,0x89,
    0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,
    0x9E,0x9F,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB4,0xB5,
    0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,
    0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,
    0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,
    0xEC,0xED,0xEE,0xEF,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,
    0xFE,0xFF
  };

static void insert_dct_header(){
  const struct sci_head_t _sci_head = _sci_head_array       [apid_flag];

  unsigned char *start = &(buffer_array[apid_flag][0]);
  unsigned char *p = start, tmp = 0;
  int i;

  *p++ = 0xFF;                          //SOIZOg
  *p++ = 0xD8;    
  *p++ = 0xFF;                          //DQTZOg
  *p++ = 0xDB;
  *p++ = 0x00;
  *p++ = 0x83;
  switch (_sci_head.QTNo) {
  case DQT0: tmp = 0x10; break;
  case DQT1: tmp = 0x11; break;
  case DQT2: tmp = 0x12; break;
  case DQT3: tmp = 0x13; break;
  case DQT4: tmp = 0x14; break;
  case DQT5: tmp = 0x15; break;
  case DQT6: tmp = 0x16; break;
  case DQT7: tmp = 0x17;
  }
  *p++ = tmp;
  for (i=0; i<128; i++) {
    switch (_sci_head.QTNo) {
    case DQT0: tmp = DQT_Pattern0[i]; break;
    case DQT1: tmp = DQT_Pattern1[i]; break;
    case DQT2: tmp = DQT_Pattern2[i]; break;
    case DQT3: tmp = DQT_Pattern3[i]; break;
    case DQT4: tmp = DQT_Pattern4[i]; break;
    case DQT5: tmp = DQT_Pattern5[i]; break;
    case DQT6: tmp = DQT_Pattern6[i]; break;
    case DQT7: tmp = DQT_Pattern7[i];
    }
    *p++ = tmp;
  }
  *p++ = 0xFF;                          //DRIZOg
  *p++ = 0xDD;
  *p++ = 0x00;
  *p++ = 0x04;
  *p++ = 0x00;
  *p++ = 0x40;
  *p++ = 0xFF;                          //SOFZOg
  *p++ = 0xC1;
  *p++ = 0x00;                          //SOF_SIZE
  *p++ = 0x0B;
  *p++ = 0x0C;                          //
  *p++ = (_sci_head.PartImageSizeY >> 8) & 0xFF; //ImageSizeX
  *p++ =  _sci_head.PartImageSizeY       & 0xFF; //ImageSizeX
  *p++ = (_sci_head.PartImageSizeX >> 8) & 0xFF; //ImageSizeY
  *p++ =  _sci_head.PartImageSizeX       & 0xFF; //ImageSizeY
  *p++ = 0x01;                          //
  *p++ = 0x01;                          //ID 
  *p++ = 0x11;                          //ETvOl
  *p++ = _sci_head.QTNo;     //ʎqe[uԍ
  *p++ = 0xFF;                          //DHTZOg
  *p++ = 0xC4;
  *p++ = 0x01;                          //DHT_SIZE
  *p++ = 0x26;
  *p++ = 0x01;
  for (i=0; i < 32; i++) {
    *p++ = DHTDC_Pattern[i];
  }
  switch (_sci_head.HTACNo) {
  case DHTAC1: tmp = 0x11; break;
  case DHTAC2: tmp = 0x12; 
  } 
  *p++ = tmp;
  for (i=0; i < 258; i++) {
    switch (_sci_head.HTACNo) {
    case DHTAC1: tmp = DHTAC_Pattern1[i]; break;
    case DHTAC2: tmp = DHTAC_Pattern2[i]; break;
    }        
    *p++ = tmp;
  }
  *p++ = 0xFF;                          //SOSZOg
  *p++ = 0xDA;
  *p++ = 0x00;                          //SOS_SIZE
  *p++ = 0x08;
  *p++ = 0x01;                          //
  *p++ = 0x01;                          //ID
  *p++ = (_sci_head.HTDCNo << 4) | (_sci_head.HTACNo);              //DCnt}e[uԍ
  *p++ = 0x00;                          //ʎqWJnԍ
  *p++ = 0x3F;                          //ʎqWIԍ
  *p++ = 0x00;                          //ʂSrbgFÕXĽWlVtgʁiŏ̃XL͂Oj
  //ʂSrbgFWlVtg
  buff_pos_array[apid_flag] = p - start;                                //obt@͈ʒu
} 

static void insert_dpcm_header() {
  const struct sci_head_t  _sci_head =  _sci_head_array       [apid_flag];

  const int restart_pixel = _sci_head.restart_pixel;

  unsigned char *start = &(buffer_array[apid_flag][0]);
  unsigned char *p = start;
  int i;

  *p++ = 0xFF;                          //SOIZOg
  *p++ = 0xD8;
  *p++ = 0xFF;                          //DRIZOg
  *p++ = 0xDD;
  *p++ = 0x00;
  *p++ = 0x04;
  *p++ = (restart_pixel >> 8) & 0xFF;
  *p++ =  restart_pixel       & 0xFF;
  *p++ = 0xFF;                          //SOFZOgiXXj
  *p++ = 0xC3;
  *p++ = 0x00;                          //ZOg
  *p++ = 0x0B;
  *p++ = 0x0C;                          //
  *p++ = (_sci_head.PartImageSizeY >> 8) & 0xFF; //ImageSizeY
  *p++ =  _sci_head.PartImageSizeY       & 0xFF; //ImageSizeY
  *p++ = (_sci_head.PartImageSizeX >> 8) & 0xFF; //ImageSizeX
  *p++ =  _sci_head.PartImageSizeX       & 0xFF; //ImageSizeX
  *p++ = 0x01;                         //
  *p++ = 0x01;                         //ID
  *p++ = 0x11;                         //ETvOl
  *p++ = _sci_head.QTNo;               //ʎqe[uԍ
  *p++ = 0xFF;                         //DHTZOg
  *p++ = 0xC4;
  *p++ = 0x00;                         //ZOg
  *p++ = 0x23;
  *p++ = 0x01;
  for (i=0; i<32; i++) {                                 //DCnt}e[u
    *p++ = DHTDC_Pattern[i];
  }
  *p++ = 0xFF;                         //SOSZOg
  *p++ = 0xDA;
  *p++ = 0x00;
  *p++ = 0x08;
  *p++ = 0x01;                         //
  *p++ = 0x01;                         //ID
  *p++ = 0x10;                         //DCnt}e[uԍ
  *p++ = 0x01;                         //ʎqWJnԍ
  *p++ = 0x00;                         //ʎqWIԍ
  *p++ = 0x00;                         //ʂSrbgFÕXĽWlVtgʁiŏ̃XL͂Oj
  //ʂSrbgFWlVtg
  buff_pos_array[apid_flag] = p - start;                                //obt@͈ʒu
}

/* internal function prototype */
static struct sci_head_t GetSciHead(const unsigned char *packet, const int64_t *utime_pkt);

/*
*******************************************************************************************
*
*   \bh
*   @DePacketizeBody_init
*
*   @\Tv
*   @obt@B
*
*   @@
*   @Ȃ
*   
*   ߂l
*   @Ȃ
*
*******************************************************************************************
*/
void DePacketizeBody_init(void) {
  int i;

  for (i=0; i<NUM_APID; i++) {
    status_array[i] = JPEG_INIT;
  }
}


/*
*********************************************************************************************
*
* @brief construct JPEG stream and science header from Hinode mission packets.
*        In the construction, partial re-construction of JPEG image is tried
*        utilizing restart marker if there are missing packtes.

* @param[in]  packet    pointer for a CCSDS packet
* @param[in]  utime_pkt time of the packet in the unit of usec.
* @param[in]  apid      APID extracted from the packet
* @param[out] sci_head  science header for the extracted jpeg image
* @param[out] jpg_data  interface area for the extracted jpeg image
* @param[out] jpg_size  size of the extracted jpeg image
* @param[out] chk_tbl   recovery flag for the extracted jpeg image
* @param[out] jpg_time  time of the first packet for the extracted jpeg image
* @param[out] bin_head  header packet for the extracted jpeg image
*
*           If non-zero pointer 
*             sci_head, jpg_data, jpg_size, chk_tbl, jpg_time, bin_head
*           is supplied and return value is either    
*             JPEG_EXTRACT, JPEG_RESTORED, RESTORED_IRRETRIEVABLE
*           refference of the pointer  
*             *sci_head, jpg_data[], *jpg_size, chk_tbl[], *jpg_time, *bin_head
*           is updated.
*
*  @return processing status
*           BUFF_NOW               buffering jpeg image
*           JPEG_EXTRACT           extracted jpeg image (no missing packets)
*           JPEG_RESTORED          extracted jpeg image (recovered)
*           RESTORED_IRRETRIEVABLE extracted jpeg image (recovered)
*           NOT_APID               apid never containis jpeg image
*           NOT_JPEG_DATA          not jpeg data (i.e. uncompressed)
*           JPEG_IRRETRIEVABLE     discard a jpeg image
*          
*********************************************************************************************
*/

int DePacketizeBody(/*in*/ const unsigned char packet[], 
		    /*in*/ const int64_t *utime_pkt, 
		    /*out*/ int *apid,
                    /*out*/ struct sci_head_t *sci_head,
                    /*out*/ unsigned char jpg_data[MAX_COMP_LEN], 
		    /*out*/ int *jpg_size, 
                    /*out*/ unsigned char chk_tbl[MAX_PIXELS],
                    /*out*/ struct jpg_time_t *jpg_time, 
		    /*out*/ struct bin_head_t *bin_head) { 

  int _apid;          // SpacePacket APID
  int sequence_flag;  // SpacePacket Sequence Counter
  int sequence_count; // SpacePacket Sequence Flag
  int packet_length;
  int rst2ndNo=0;
  int i, wk;

  // CÂ *2 ɊւāAԂςȂ const static t^ȂB
  int apid_tbl[NUM_APID] = { // Ώۃf[^̃e[u
    APID_FLT_OBS_1, APID_FLT_OBS_2,
    APID_SPP_OBS_1, APID_SPP_OBS_2,
    APID_XRT_OBS_1, APID_XRT_OBS_2,
    APID_EIS_OBS_1, APID_EIS_OBS_2
  };

  /*
   ********************************************
   *
   * CCSDSwb_e擾
   *
   ********************************************
   */

  _apid          = ((packet[0] & 0x07) << 8)
    +              ((packet[1] & 0xff) << 0); //APID擾
  sequence_flag  = ((packet[2] & 0xc0) >> 6); //V[PXtO擾
  sequence_count = ((packet[2] & 0x3f) << 8)
    +              ((packet[3] & 0xff) << 0); //V[PXJEg擾
  packet_length  = ((packet[4] & 0xff) << 8)
    +              ((packet[5] & 0xff) << 0); //pPbgTCY擾

  /*
   *******************************************
   *
   * Ώۃf[^菈
   *
   *******************************************
   */

  apid_flag = -1;
  for (i=0; i<NUM_APID; i++) {
    if (_apid == apid_tbl[i]) {
      apid_flag = i;
      break;
    }
  }
  *apid = _apid;                          //APID
  if (apid_flag == -1) {
    return NOT_APID;                   //ΏۂAPIDł͂Ȃ
  }
                       
  /* by KM from here */
  int *before_sq_flag          = &(before_sq_flag_array  [apid_flag]);
  int *before_sq_count         = &(before_sq_count_array [apid_flag]);
  int *status                  = &(status_array          [apid_flag]);

  struct sci_head_t *_sci_head = &(_sci_head_array       [apid_flag]);
  /* by KM until here */

  if (*status != BUFF_NOW) {

    /* 1. waiting for start of next image */

    if (sequence_flag == PACKET_START) {
      *_sci_head = GetSciHead(packet, utime_pkt);
      // Input: datainfo_len, Output: _bin_head, _jpg_time, 
      //    num_RST, restored_flag, buff_pos, ECS0_start

      if (_sci_head->ImageCompMode != 0) { // JPEG data
	*status = BUFF_NOW;
	*before_sq_count = sequence_count;
	*before_sq_flag  = sequence_flag;
      } else { // not JPEG data
	*status = NOT_JPEG_DATA;
      }
    }

    if( *status == JPEG_INIT ) return JPEG_IRRETRIEVABLE; // KM note *12

    return *status;

    /* end of 1. */
    
  } else {
       
    /* 2. Processing of image */

    /* by KM from here */
    int *buff_pos                = &(buff_pos_array        [apid_flag]);
    unsigned char *buffer        =   buffer_array          [apid_flag];
    int *ECS0_start              = &(ECS0_start_array      [apid_flag]);

    int *num_RST                 = &(num_RST_array         [apid_flag]);
    struct rst_tbl_t *rst_tbl    = &(rst_tbl_array         [apid_flag][0]);
    int *restored_flag           = &(restored_flag_array   [apid_flag]);

    struct bin_head_t *_bin_head = &(_bin_head_array       [apid_flag]);
    struct jpg_time_t *_jpg_time = &(_jpg_time_array       [apid_flag]);
    /* by KM until here */

    if (sequence_flag == PACKET_START) {

      /* 2.1. ̓pPbgPpPbg̏ꍇ */

      /* finalize process of accumulated image */

      int iret = 99; // invalid, determined soon

      if (*before_sq_flag == PACKET_START) {

	/* 2.1.1. Processing of designed pattern 8 */

	dbg("KM71");

	iret = JPEG_IRRETRIEVABLE; // discard accumlated image
               
      } else {
                    
	/* 2.1.2. Processing of designed pattern 4, 10 */

	fill_tail();  // recover RSTn, EOI [KM51]
	// Input: _sci_head.num_segment, Modified: num_RST, rst_tbl, buff_pos, buffer

	dbg("KM51 num_RST=%d num_segment=%d\n", *num_RST, _sci_head->num_segment);

	if (*num_RST != _sci_head->num_segment-1) { // check number of RSTn
	  
	  // KM's note
	  // value of *num_RST is force updated to
	  // *num_segment-1 in the call of add_rst.
	  // This block seem to be never executed.

	  /* recovery failed, retry recovery */
	  wk = trunc_recovered(); // [KM52], KM note *9)
	  // Input: _sci_head.num_segment, Modified: num_RST, rst_tbl, buff_pos, buffer

	  dbg("KM52 wk=%d num_RST=%d num_segment=%d\n", wk, *num_RST, _sci_head->num_segment);

	  if (wk != 0) {
	    dbg("KM72");

	    return *status = JPEG_IRRETRIEVABLE; // discard accumlated image
	    // KM: why return here ??
	  }
	}

	/* recovery succeeded */

	clear_chktbl(); ////// 
	fill_chktbl();
	// Input: _sci_head, num_RST, rst_tbl, output: _chk_tbl

	if (jpg_data != NULL) { memcpy(jpg_data, buffer, *buff_pos); }
	if (jpg_size != NULL) {	*jpg_size  = *buff_pos; }
	if (sci_head != NULL) { *sci_head  = *_sci_head; }
	if (chk_tbl  != NULL) { memcpy(chk_tbl, _chk_tbl, sizeof(_chk_tbl)); }
	if (jpg_time != NULL) { *jpg_time=*_jpg_time; }
	if (bin_head != NULL) { *bin_head=*_bin_head; }

	dbg("KM61");

	iret = JPEG_RESTORED;

	/* end of 2.1.2. */
      }

      /* start process of image begin with the recent packet */

      *_sci_head = GetSciHead(packet, utime_pkt);
      // Input: datainfo_len, Output: _bin_head, _jpg_time, 
      //    num_RST, restored_flag, buff_pos, ECS0_start
                    
      if (_sci_head->ImageCompMode != 0) { // JPEG data
	*status = BUFF_NOW;
	*before_sq_flag = sequence_flag;
	*before_sq_count= sequence_count;
      } else { // not JPEG data
	*status = NOT_JPEG_DATA;
      }

      return iret;

      /* end of 2.1. */

    } else {

      /* 2.2. ̓pPbgPpPbgȊȌꍇ */

      int istatus = BUFF_NOW; 
      // istatus shall be one of
      // BUFF_NOW,JPEG_RESTORED RESTORED_IRRETRIEVABLE,JPEG_EXTRACT
      int istart_flag = 1; // valid if istatus != BUFF_NOW
      
      const int data_length = packet_length + 1 - 4;              //摜f[^TCY
      //CCSDSpPbgremaining bytes-1
      //ݒ肳̂1B
      //SecondaryHeader4oCg
      //̂JPEGf[^̃TCYB

      const int sq_count_diff = (sequence_count - *before_sq_count + ALIGN) % ALIGN;

      if ( sq_count_diff >= MAX_SQDIFF) { 
	/* 2.2.1. too large counter skip */
	
	if (*before_sq_flag == PACKET_START) {
	  dbg("KM73");

	  return *status = JPEG_IRRETRIEVABLE; // discard accumulated image

	} else {
	  fill_tail(); // recover RSTn, EOI [KM54] KM note *10)
	  // Input: _sci_head.num_segment, Modified: num_RST, rst_tbl, buff_pos, buffer
	  dbg("KM73a");

	  istatus = RESTORED_IRRETRIEVABLE; // finish accumulation of image
	  istart_flag = 0;
	}

	/* end of 2.2.1. */
      } else if ( sq_count_diff > 1) { 
	/* 2.2.2. not too large counter skip */

	/* ͂pPbgRSTň */
	int packetpos = -1;
#if 0
 	for (i=0; i<data_length; i++) {
#else
	  // KM notice *7 from here 
	for (i=0; i<data_length-1; i++) {
	  // KM notice *7 until here 
#endif
	  if (packet[i+10] == 0xFF) {
	    const int rst2nd = packet[i+11] & RST2ND_MASK;
	    rst2ndNo = packet[i+11] & RSTNO_MASK;
	    if (rst2nd == 0xD0) {
	      packetpos = i;          //CCSDSpPbgRST̍ŏ̈ʒu
	      break;
	    }
	  }
	}

	if ( packetpos == -1 ) { 
	  /* 2.2.2.1. no RSTn found */

	  if (sequence_flag != PACKET_END) { 
	    return *status = BUFF_NOW; // discard packet, continue accumulation
	    // do not update before_sq_count, before_sq_flag

	  } else {

	    if (*before_sq_flag == PACKET_START) {

	      dbg("KM74");

	      return *status = JPEG_IRRETRIEVABLE; // discard accumulated image of image

	    } else {
	      fill_tail(); // recover RSTn, EOI [KM55] KM note *10)
	      // Input: _sci_head.num_segment, Modified: num_RST, rst_tbl, buff_pos, buffer

	      dbg("KM62");

	      istatus = JPEG_RESTORED; // finish accumulation of image
	      istart_flag = 0;
	    }
	  }

	  /* end of 2.2.2.1. */
	} else { 
	  /* 2.2.2.2. RSTn found */

	  if (*before_sq_flag == PACKET_START) {

	    if (_sci_head->ImageCompMode == COMP_MODE_DCT12) {
	      insert_dct_header();
	    } else if (_sci_head->ImageCompMode == COMP_MODE_DPCM12) {
	      insert_dpcm_header();
	    }

	    *ECS0_start = *buff_pos;               //obt@̍ŏI|C^
	  }

	  fill_gap(packet, data_length, packetpos, rst2ndNo); // recover RSTn, add packet [KM53, KM56]
	  // Input: ECS0_start, Modified: num_RST, rst_tbl, buff_pos, buffer
	  
	  if (sequence_flag == PACKET_END) {
	    dbg("KM63");

	    istatus = JPEG_RESTORED; // finsish accumulation of image
	    istart_flag = 0;
	  } else {
	    // istatus = BUFF_NOW; // continue accumlation of image
	  }

	  /* end of 2.2.2.2. */
	}

	/* end of 2.2.2. */
      } else { 
	/* 2.2.3. no counter skip */

	int markpos = -1;
	// KM notice *8 from here
	if ( buffer[*buff_pos-1] == 0xFF ){
	  markpos = *buff_pos-1;
	}
	// KM notice *8 until here
	for (i=0; i < data_length; i++) {
	  const unsigned char octet = packet[i+10];
	  buffer[*buff_pos] = octet;
	  if (octet == 0xFF) {
	    markpos = *buff_pos;
	  } else {
	    if (markpos >= 0) {
	      const int rst2nd = octet & RST2ND_MASK;
	      rst2ndNo = octet & RSTNO_MASK;
	      if (rst2nd == 0xD0) {                //RSTn
		rst_tbl[*num_RST].pos = markpos;
		rst_tbl[*num_RST].No  = rst2ndNo;
		rst_tbl[*num_RST].flg = 0;
		(*num_RST)++;
	      } else if (octet == 0xDA) { // SOS 
		*ECS0_start=*buff_pos+9; // 摜f[^̊JnʒúASOS }[ĴQoCgڂAXoCgɂB
	// KM notice *3 from here
	      } else if (octet == 0xD9) { // EOI
		rst_tbl[*num_RST].flg = 0;
	// KM notice *3 until here
	      }
	    }
	    markpos = -1;
	  }
	  (*buff_pos)++;
	}

	if (sequence_flag == PACKET_END) {
	  //// dbg("KM64");

	  istatus = JPEG_RESTORED; // finsish accumulation of image
	  istart_flag = 0;
	} else {
	  // istatus = BUFF_NOW; // continue accumlation of image
	}

	/* end of 2.2.3. */
      }

      /* JPEGC`FbN */

      if ( istatus != BUFF_NOW ) {
	clear_chktbl();
	// Output: _chk_tbl
      }

      if ( istatus == JPEG_RESTORED && istart_flag == 0 ) {
	
	if (*restored_flag == 0) {
	  istatus = JPEG_EXTRACT;
	  
	} else {
	  
	  if (*num_RST != _sci_head->num_segment-1) { // check number of RSTn
	    
	    /* recovery failed, retry recovery */
	    wk = trunc_recovered(); // [KM57]
	    // Input: _sci_head.num_segment, Modified: num_RST, rst_tbl, buff_pos, buffer
	    if (wk != 0) {
	      dbg("KM75");

	      return *status = JPEG_IRRETRIEVABLE; // discard accumlated image
	    }
	    dbg("KM75a");
	    
	    istatus = RESTORED_IRRETRIEVABLE; // finish accumulation of image
	  }

	  /* recovery succeeded */
	  
	  clear_chktbl(); //////
	  fill_chktbl();
	  // Input: _sci_head, num_RST, rst_tbl, output: _chk_tbl
	}
      }
      
      if ( istatus != BUFF_NOW ) {
	/* JPEG_EXTRACT or JPEG_RESTORED or RESTORED_IRRETRIEVABLE */
	/* JPEG f[^i[obt@̃|C^Ԃ */
	
	if (jpg_data != NULL) { memcpy(jpg_data, buffer, *buff_pos); }
	if (jpg_size != NULL) { *jpg_size  = *buff_pos; }
	if (sci_head != NULL) {	*sci_head  = *_sci_head; }
	if (chk_tbl  != NULL) { memcpy(chk_tbl, _chk_tbl, sizeof(_chk_tbl)); }
	if (jpg_time != NULL) { *jpg_time=*_jpg_time; }
	if (bin_head != NULL) { *bin_head=*_bin_head; }
	
      } else {
	/* BUFF_NOW */
	/* NULL Ԃ */
	if (jpg_size != NULL) { *jpg_size = 0; }
	
	*before_sq_count = sequence_count;
	*before_sq_flag  = sequence_flag;
      }
      
      switch ( istatus ) {
      case JPEG_EXTRACT:
      case JPEG_RESTORED: 
	*status = (istart_flag == 0) ? NOT_JPEG_DATA : BUFF_NOW; 
	break;
      case RESTORED_IRRETRIEVABLE:
	*status = (istart_flag == 0) ? JPEG_IRRETRIEVABLE : BUFF_NOW; 
	break;
      case BUFF_NOW:
	*status = BUFF_NOW;
	break;
      default:
	fprintf(stderr, "DePacketizeBody(): fatal logic error (1266)\n");
      }
      
      return istatus;
      
      /* end of 2.2. */
    } 

    /* end of 2. */
  }
}

/*
 ***************************************************************
 *
 *@\bh
 *  @GetSciHead
 *  Tv
 *@@TCGXwb_擾EX^[gԊuvZ\bh (֐)
 *  
 *    packet          CCSDS pPbg
 *    utime_pkt       packet edition time (SIRIUS) / ground receive time (data distributor)
 * 
 *@߂l
 *@  wk              \̂Ԃ
 *

 Input: datainfo_len, Output: _bin_head, _jpg_time, 
   num_RST, restored_flag, buff_pos, ECS0_start

 ***************************************************************
 */ 
struct sci_head_t GetSciHead(const unsigned char *packet, const int64_t *utime_pkt) {
  struct sci_head_t wk;

  /* defintiion of file internal variable refferences */

  const int datainfo_len       =   datainfo_len_array  [apid_flag];  // input

  struct bin_head_t *_bin_head = &(_bin_head_array     [apid_flag]); // output
  struct jpg_time_t *_jpg_time = &(_jpg_time_array     [apid_flag]); // output

  int *num_RST                 = &(num_RST_array       [apid_flag]); // output
  int *restored_flag           = &(restored_flag_array [apid_flag]); // output
  int *buff_pos                = &(buff_pos_array      [apid_flag]); // output
  int *ECS0_start              = &(ECS0_start_array    [apid_flag]); // output

  /* */

  wk.DataType       = ((packet[18] & 0xff) << 0); //DataType擾
  wk.PacketSize     = ((packet[19] & 0xff) << 16) 
    +                 ((packet[20] & 0xff) << 8)
    +                 ((packet[21] & 0xff) << 0); //PacketSize擾
  wk.SerialPacketNo = ((packet[22] & 0xff) << 24)
    +                 ((packet[23] & 0xff) << 16)
    +                 ((packet[24] & 0xff) << 8) 
    +                 ((packet[25] & 0xff) << 0); //SerialPacketNo擾
  wk.MainID =         ((packet[26] & 0xff) << 8)
    +                 ((packet[27] & 0xff) << 0); //MainID擾
  wk.MainSQFlag =     ((packet[28] & 0xc0) >> 6); //MainSequenceFlag擾
  wk.MainSQCount =    ((packet[28] & 0x3f) << 8)
    +                 ((packet[29] & 0xff) << 0); //MainSequenceCount擾
  //                    packet[30] ̏ 2 bit  reserved
  wk.NumOfPacket =    ((packet[30] & 0x3f) << 2) 
    +                 ((packet[31] & 0xc0) >> 6); //NumberOfPacket擾
  wk.NumOfFrame =     ((packet[31] & 0x3f) << 0); //NumberOfFrame擾
  wk.SubID =          ((packet[32] & 0xff) << 8)
    +                 ((packet[33] & 0xff) << 0); //SubID擾
  wk.SubSQFlag =      ((packet[34] & 0xc0) >> 6); //SequenceFlag擾
  wk.SubSQCount =     ((packet[34] & 0x3f) << 8)
    +                 ((packet[35] & 0xff) << 0); //SequenceCount擾
  wk.FullImageSizeX = ((packet[36] & 0xff) << 8)
    +                 ((packet[37] & 0xff) << 0); //FullImageSizeX擾
  wk.FullImageSizeY = ((packet[38] & 0xff) << 8)
    +                 ((packet[39] & 0xff) << 0); //FullImageSizeY擾
  wk.BasePointCoorX = ((packet[40] & 0xff) << 8)
    +                 ((packet[41] & 0xff) << 0); //BasePointCoorX擾
  wk.BasePointCoorY = ((packet[42] & 0xff) << 8)
    +                 ((packet[43] & 0xff) << 0); //BasePointCoorY擾
  wk.PartImageSizeX = ((packet[44] & 0xff) << 8)
    +                 ((packet[45] & 0xff) << 0); //PartImageSizeX擾
  wk.PartImageSizeY = ((packet[46] & 0xff) << 8)
    +                 ((packet[47] & 0xff) << 0); //PartImageSizeY擾
  //                    packet[48] ̏ 1 bit  reserved
  wk.BitCompMode =    ((packet[48] & 0x78) >> 3); //k[hibit)擾
  wk.ImageCompMode =  ((packet[48] & 0x07) << 0); //k[hiImage)擾
  //                    packet[49] ̏ 1 bit  reserved
  wk.HTACNo =         ((packet[49] & 0x60) >> 5); //nt}ACNo擾
  wk.HTDCNo =         ((packet[49] & 0x18) >> 3); //nt}DCNo擾
  wk.QTNo =           ((packet[49] & 0x07) << 0); //ʎqe[uNo擾
   
  memset(wk.DataInfo, 0, sizeof(wk.DataInfo));
  memcpy(wk.DataInfo, &packet[50], datainfo_len);

  if (utime_pkt != NULL) {
    _jpg_time->utime = *utime_pkt;       // packet edition time (SIRIUS) / ground receive time (DATA distributor)
  } else {
    _jpg_time->utime=0;
  }
  _jpg_time->ti_time = (packet[6] << 24)    
    +                  (packet[7] << 16)
    +                  (packet[8] << 8)
    +                  (packet[9] << 0); // packet edition time (CCSDS secondary header)
  memcpy(_bin_head->verinfo, &packet[10], 8);   // version information of MDP compression table 
  memcpy(_bin_head->mdphead, &packet[18], 32);  // first 32 byte of the science data header
  memset(_bin_head->datainfo, 0, sizeof(_bin_head->datainfo));
  memcpy(_bin_head->datainfo, &packet[50], datainfo_len);
  _bin_head->datainfo_len=datainfo_len;

  /*
   ***********************************
   *
   * X^[gԊǔvZ
   *
   ***********************************
   */ 

  {
    int restart_pixel = 99; // invalid
    int num_segment = 99; // invalid

    switch (wk.ImageCompMode) {
    case COMP_MODE_DPCM12:                      //DPCMk
      for (restart_pixel = wk.PartImageSizeX; restart_pixel % 64 != 0;) { //X^[gԊu
	restart_pixel = restart_pixel * 2;
      }
      num_segment = (int) ceil(1.0 * wk.PartImageSizeX * wk.PartImageSizeY / restart_pixel);
      break;

    case COMP_MODE_DCT12:                       //DCTk
      restart_pixel = 8 * 8 * 64;  //X^[gԊu
      num_segment = (int) ceil(1.0 * wk.PartImageSizeX * wk.PartImageSizeY / restart_pixel);
      break;
      
    default:
      wk.ImageCompMode = 0;
    }

    wk.restart_pixel = restart_pixel;
    wk.num_segment = num_segment;
  }

  *num_RST       = 0;
  *restored_flag = 0;
  *buff_pos      = 0;
  *ECS0_start    = 0;

  return wk;
}

