/*
***********************************************************
*
*   W[
*      DePacketizeBody.h
*  
*    Tv
*    @JPEGf[^CW[pwb_
*
***********************************************************
*/ 

#include <stdint.h>

/*
*******************************************
*
*   }N`
*
*******************************************
*/

#define APID_FLT_OBS_1             0x14C           //FLT_OBS_1APID
#define APID_FLT_OBS_2             0x14D           //FLT_OBS_2APID
#define APID_SPP_OBS_1             0x14E           //SPP_OBS_1APID
#define APID_SPP_OBS_2             0x14F           //SPP_OBS_2APID
#define APID_XRT_OBS_1             0x1AA           //XRT_OBS_1APID
#define APID_XRT_OBS_2             0x1AB           //XRT_OBS_2APID
#define APID_EIS_OBS_1             0x1CA           //EIS_OBS_1APID
#define APID_EIS_OBS_2             0x1CB           //EIS_OBS_2APID

#define BUFF_NOW                       0           //obt@O
#define JPEG_EXTRACT                   1           //o
#define JPEG_RESTORED                  2           //C
#define RESTORED_IRRETRIEVABLE         3           //CĔj
#define NOT_APID                      -1           //ΏۂAPIDł͂Ȃ
#define NOT_JPEG_DATA                 -2           //JPEGf[^ł͂Ȃ
#define JPEG_IRRETRIEVABLE            -3           //f[^j
#define JPEG_INIT                     -4           //initial value

#define PACKET_CONTINUE                0           //CCSDSpPbǧp
#define PACKET_START                   1           //CCSDSpPbg̊Jn
#define PACKET_END                     2           //CCSDSpPbg̏I

#define RST2ND_MASK                 0xF8           //RSTʂPoCgo}XN
#define RSTNO_MASK                  0x07           //RSTNoʂPoCgo}XN

#define DQT0                           0           //ʎqe[uԍFO
#define DQT1                           1           //ʎqe[uԍFP
#define DQT2                           2           //ʎqe[uԍFQ
#define DQT3                           3           //ʎqe[uԍFR
#define DQT4                           4           //ʎqe[uԍFS
#define DQT5                           5           //ʎqe[uԍFT
#define DQT6                           6           //ʎqe[uԍFU
#define DQT7                           7           //ʎqe[uԍFV

#define DHTDC1                         1           //DCnt}e[uԍFP
#define DHTAC1                         1           //ACnt}e[uԍFP
#define DHTAC2                         2           //ACnt}e[uԍFQ

#define COMP_MODE_DPCM12               3           //DPCMkl
#define COMP_MODE_DCT12                7           //DCTkl

#define ALIGN                    0x10000           //V[PXJEg̍Zoۂ
#define MAX_SQDIFF                   999           //V[PXJEg̍ől
                                                   //vZʂ 2byte ȂɐK


/*
*******************************************
*
* \̐錾
*
******************************************* 
*/
struct sci_head_t {     /* science data header */
    int DataType;
    int PacketSize;
    int SerialPacketNo;
    int MainID;
    int MainSQFlag;
    int MainSQCount;
    int NumOfPacket;
    int NumOfFrame;
    int SubID;
    int SubSQFlag;
    int SubSQCount;
    int FullImageSizeX;
    int FullImageSizeY;
    int BasePointCoorX;
    int BasePointCoorY;
    int PartImageSizeX;
    int PartImageSizeY;
    int BitCompMode;
    int ImageCompMode;
    int HTACNo;
    int HTDCNo;
    int QTNo;
    unsigned char DataInfo[256];

    int restart_pixel; // number of pixels for restart, valid if ImageCompMode != 0
    int num_segment;   // number of restart segment in a image, valid if ImageCompMode != 0
};

struct jpg_time_t {     /* packet edition time of the first packet for the JPEG image data */
    int64_t utime;      /* micro seconds elapsed from 2000/01/01 00:00:00 (UT) */
    int     ti_time;    /* Solar-B S/C low resolution TI (CCSDS secondary header) */
};

struct bin_head_t {             /* binary information of the JPEG image data */
    unsigned char verinfo[8];   /* version information of MDP compression tables */
    unsigned char mdphead[32];  /* first 32 byte of the science data header */
    unsigned char datainfo[256];/* Data information in the science data header */
    int           datainfo_len; /* length of the data information */
};

struct rst_tbl_t {
    int pos;
    int No;
    int flg;
};

/*
 *******************************************
 *  ֐vg^Cv錾
 *******************************************
 */ 

/*
 * Maximum image pixel from the telescopes
 *
 * Maximum image size @ MDP = 256k pixel (for EIS), 64K (for SOT and XRT)
 */
#define MAX_PIXELS (256*1024)

/*
 * Maximum compressed size of a image
 *
 * 2 (bytes / pixel)
 * 2 maximum compression factor
 *   note size of the image will increase 
 *   in the worst case
 */
#define MAX_COMP_LEN (MAX_PIXELS*4)

/* Initialization function */
void DePacketizeBody_init(void);
/* JPEG restoring function */
int DePacketizeBody(/*in*/ const unsigned char packet[], 
		    /*in*/ const int64_t *utime_pkt, 
		    /*out*/ int *apid,
                    /*out*/ struct sci_head_t *sci_head, 
                    /*out*/ unsigned char jpg_data[MAX_COMP_LEN], 
		    /*out*/ int *jpg_size, 
		    /*out*/ unsigned char chk_tbl[MAX_PIXELS],
                    /*out*/ struct jpg_time_t *jpg_time, 
		    /*out*/ struct bin_head_t *bin_head);
