#include <stdlib.h>
#include <libgen.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <errno.h>
#include "DePacketizeBody.h"
#include "recv_packet.h"
#include <arpa/inet.h>
// using htonl()

#define MAX_PACKET (1024 * 1024)

int main(int argc, char *argv[]) {

  // Needed by DePacketizeBody
  unsigned char		packet[MAX_PACKET];
  const int		proc_apid  = 459; // 0x1CB

  if(argc != 3) {
    fprintf(stderr, "Need 2 args\n");
    exit(-1);
  }

  // Open the input ccsds file
  FILE *fpIN = fopen(argv[1], "r");
  if(fpIN == NULL) {
    fprintf(stderr, "Can't open input file : %s\n", strerror(errno));
    exit(1);
  }
  char *filename = basename(strdup(argv[1]));
  
  // Open the output image data file
  FILE *fpOUT1 = fopen(argv[2], "w");
  if(fpOUT1 == NULL) {
    fprintf(stderr, "Can't open output file : %s\n", strerror(errno));
    exit(2);
  }
  
  // Open the output check file
#if 1
  char chk_path[255] = "/chk/";
  char *dname = dirname(strdup(argv[2]));
  char dir_portion[255];
  (void)strcpy(dir_portion, dname);
  char *chk_file = strcat(dir_portion, strcat(chk_path, filename));
  FILE *fpOUT2 = fopen(chk_file, "w");
  if(fpOUT2 == NULL) {
    fprintf(stderr, "Can't open chk file : %s\n", strerror(errno));
    exit(3);
  }
#endif
  //  FILE *fpOUT2 = fopen("./hello_kitty.foo", "w");

  DePacketizeBody_init();
  
  int iret, res;
  unsigned long ptr;
  ptr = 0;
  //    if(feof(fpIN)) break;
    
  while((res = recv_packet(packet, &ptr, fpIN)) != PACKET_END) {

    int    	        apid;
    struct sci_head_t   sci_head;
    unsigned char	jpg_data[MAX_COMP_LEN];
    int		        jpg_size;
    char	        chk_tbl[MAX_PIXELS];
    struct jpg_time_t   jpg_time;
    struct bin_head_t   bin_head;

    ptr = 0;
    //    printf("res = %u\n", res);
    
    iret = DePacketizeBody(packet, NULL, &apid, &sci_head, jpg_data, &jpg_size, chk_tbl, &jpg_time, &bin_head);

    switch(iret) {
    case BUFF_NOW : continue;
    case JPEG_EXTRACT :
    case JPEG_RESTORED :
    case RESTORED_IRRETRIEVABLE :
      if(apid == proc_apid) {

	// User supplied processing on newly restored data. 

#if 1
	// In EIS we will just re-created space packets into file.
	// sci_head and chk_tbl is not used

#define MDP_MAX_PACKET_SIZE 2042
#define CCSDS_PRIMARY_HEADER_LENGTH 6
#define HINODE_SECONDARY_HEADER_LENGTH 4
#define HINODE_SPACE_PACKET_HEADER_LENGTH \
	  (CCSDS_PRIMARY_HEADER_LENGTH+HINODE_SECONDARY_HEADER_LENGTH)
#define JPEG_MAX_SEGMENT_LENGTH (MDP_MAX_PACKET_SIZE-HINODE_SPACE_PACKET_HEADER_LENGTH)

	int sq_flag;
	const int sq_count = 0x0000; /* do not use sequence counter */
	uint8_t header[HINODE_SPACE_PACKET_HEADER_LENGTH];
	int offset;

	{
	  const int verinfo_len =  8;
	  const int mdphead_len = 32;
	  const int mdhead_len  = verinfo_len + mdphead_len + bin_head.datainfo_len;
	  const int packet_data_length = mdhead_len + HINODE_SECONDARY_HEADER_LENGTH - 1;

	  sq_flag = 1; /* first segment of user data */

	  header[0] = 0x08 /* version=000b, packet_type=0b, seconary_header_flag=1b */
	    |         ((proc_apid          >>  8) & 0x07);
	  header[1] = ((proc_apid          >>  0) & 0xFF);
	  header[2] = ((sq_flag            <<  6) & 0xC0) 
	    |         ((sq_count           >>  8) & 0x3F); // fake
	  header[3] = ((sq_count           >>  0) & 0xFF); // fake 
	  header[4] = ((packet_data_length >>  8) & 0xFF);
	  header[5] = ((packet_data_length >>  0) & 0xFF);
	  header[6] = ((jpg_time.ti_time   >> 24) & 0xFF); // the same as telemetry
	  header[7] = ((jpg_time.ti_time   >> 16) & 0xFF); // the same as telemetry
	  header[8] = ((jpg_time.ti_time   >>  8) & 0xFF); // the same as telemetry
	  header[9] = ((jpg_time.ti_time   >>  0) & 0xFF); // the same as telemetry


	  fwrite(header, sizeof(header[0]), HINODE_SPACE_PACKET_HEADER_LENGTH, fpOUT1);
	  fwrite(bin_head.verinfo,  sizeof(bin_head.verinfo[0]), verinfo_len, fpOUT1);
	  fwrite(bin_head.mdphead,  sizeof(bin_head.mdphead[0]), mdphead_len, fpOUT1);
	  fwrite(bin_head.datainfo, sizeof(bin_head.datainfo[0]),bin_head.datainfo_len, fpOUT1);
	}

	for ( offset=0 ; offset<jpg_size ; offset += JPEG_MAX_SEGMENT_LENGTH ) {

	  int length = jpg_size - offset ;
	  int packet_data_length;

	  if ( length > JPEG_MAX_SEGMENT_LENGTH ) {
	    length = JPEG_MAX_SEGMENT_LENGTH;
	    sq_flag = 0; /* continuation segment of user data */
	  } else {
	    sq_flag = 2; /* last segment of user data */
	  }

	  packet_data_length = length + HINODE_SECONDARY_HEADER_LENGTH - 1;

	  header[0] = 0x08 /* version=000b, packet_type=0b, seconary_header_flag=1b */
	    |         ((proc_apid          >>  8) & 0x07);
	  header[1] = ((proc_apid          >>  0) & 0xFF);
	  header[2] = ((sq_flag            <<  6) & 0xC0) 
	    |         ((sq_count           >>  8) & 0x3F); // fake
	  header[3] = ((sq_count           >>  0) & 0xFF); // fake
	  header[4] = ((packet_data_length >>  8) & 0xFF);
	  header[5] = ((packet_data_length >>  0) & 0xFF);
	  header[6] = ((jpg_time.ti_time   >> 24) & 0xFF); // fake
	  header[7] = ((jpg_time.ti_time   >> 16) & 0xFF); // fake
	  header[8] = ((jpg_time.ti_time   >>  8) & 0xFF); // fake
	  header[9] = ((jpg_time.ti_time   >>  0) & 0xFF); // fake

	  fwrite(header, sizeof(header[0]), HINODE_SPACE_PACKET_HEADER_LENGTH, fpOUT1);
	  fwrite(jpg_data+offset, sizeof(jpg_data[0]), length, fpOUT1);
	}

#else
	// another program to store complete information of the restortion library
	//
        // 4 byte           : mehead_len
	// mehead_len byte  : mehead
        // 4 byte           : jpgdata_len
	// jpgdata_len byte : jpgdata

	uint32_t mdhead_len  = 8 + 32 + bin_head.datainfo_len;
	uint32_t jpgdata_len = jpg_size;

	mdhead_len  = htonl( mdhead_len );
	jpgdata_len = htonl( jpgdata_size );
	ckttbl_len  = htonl( chktbl_len );

	fwrite(&mdhead_len, 1, 4, fpOUT1);
	fwrite(bin_head.verinfo,  sizeof(bin_head[0]), 8, fpOUT1);
	fwrite(bin_head.mdphead,  sizeof(bin_head[0]), 32, fpOUT1);
	fwrite(bin_head.datainfo, sizeof(bin_head[0]), bin_head.datainfo_len, fpOUT1);

	fwrite(&jpgdata_len, 1, 4, fpOUT1);
	fwrite(jpg_data, sizeof(jpg_data[0]), jpg_size, fpOUT1);

#endif
	// second file contains chktbl, 
	// length of the chktbl should be determined with science data from of the space packet stream
	//
	// chktbl_len byte  : chktbl

	fwrite(chk_tbl,  sizeof(chk_tbl[0]), sci_head.PartImageSizeX*sci_head.PartImageSizeY, fpOUT2);
      }
    default :
      continue;
    }
  }
  //  printf("res = %u\n", res);
  fclose(fpIN);
  fclose(fpOUT1);
  fclose(fpOUT2);
  exit(0);
}
