#!/usr/bin/env perl

#
# This program is scheduled to run on pg4
#

# crontab entry
# 30 9 * * fri $HOME/bin/pass_list_cron.pl
#
# So every friday at 09:30 get the pass list from the eisco machine
#
# crontab entry on eisco
# 0 9 * * fri $HOME/bin/pass_list_cron.csh

#
# Copy today's orl file on eisco to the orl_list directory
#

use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

my $count = 0;
my @lines;
if (open(FOO, "< $HOME/track/sat_rot_pending.txt")) {
    while(<FOO>) {
	chomp;
	push @lines, $_;
	++$count;
    }
    close FOO;
    system("/bin/unlink $HOME/track/sat_rot_pending.txt");
    system("/bin/touch $HOME/track/sat_rot_pending.txt");

    if ($count > 0) {
	while(@lines) {
	    my $line = shift @lines;
	    system("$HOME/bin/sat_rot_cron $line");
	}
    }
}

system("$HOME/bin/sat_rot_cron");
