#!/usr/local/bin/perl                                                                                                                                                      

# ./make_raster_summary_table.pl file  > file.html
# studies{acronym} => [times run, incomplet count, author]

if($#ARGV != 0) {
    print STDERR "Usage: make_raster_summary_table.pl file.txt > file.html\n";
    die;
}
$filename = shift;
$filename1 = $filename;
$filename =~ s/_summary\.txt//;
#print "$filename\n";

$tablename = "Details for $filename";

$highlight = 0;
$date_string = shift;
$total_studies = 10;

html_header($filename);
html_body($filename);
para(2);
#header(3, "Studies");

$num_item_groups = 0;
@items = ();
$first = 1;
die "Can't open $filename1: $!" unless open(F, "<$filename1");
while(<F>) {
#    next if /^Date/;
    next if /Date/;
    chomp;
    if($first) {
	@items1 = split;
	$first = 0 if $items1[1] != 0;
	@items = ($items1[2], $items1[1], $items1[3], $items1[4], $items1[5], $items1[6]);
    }
    ($date, $id, $acronym, $fx, $fy, $vol, $ppe, $exexp, $recexp, $elos, $clos, $num) = split;
    $entry{$date} = [$exexp, $recexp, $elos, $clos, $num];
}
close F;
@stitles = ("Raster Acronym", "Raster Id", "Full X", "Full Y", "Pixels Per Exposure", "Mission Data Packets Per Exposure");
@titles  = ("Expected Exposures", "Received Exposures", "Exposure Loss (%)", "Ccsds Packet Loss (%)", "Number Of Files");
table_header($tablename, \@stitles, \@items, \@titles);
#table_footer("5 files expected, 4 ccsds received, 3 fits generated", scalar(@titles));
table_body(\%entry);
table_end();
para(2);
html_end();
exit;

sub table_header {
    my $title = shift;
    my $s = shift;
    my $v = shift;
    my $i = shift;
    my $th;
    my @items;

#    print @$v, "\n";

    $ind = 0;
    foreach $thing (@$s) {
#	@items = split / /, $thing;
        $stitle .= "<tr><th class=\"st\" colspan=\"5\">$thing</th>\n";
        $stitle .= "<th>" . $$v[$ind] . "</th></tr>\n" if $ind == 0;
        $stitle .= "<th class=\"number\">" . $$v[$ind] . "</th></tr>\n" if $ind != 0;
	++$ind;
    }
    $th = "<tr><th colspan=\"6\"> </th></tr>\n<th>Month</th>\n";

    foreach $thing (@$i) {
	$th .= "<th>$thing</th>\n";
    }

    my $table = <<HERE;
    <table width="50%" summary="$title" border="1" cellpadding="2" cellspacing="0">
    <caption>$title</caption>
    <thead>
            $stitle
	<tr>
            $th
        </tr>
    </thead>
HERE
print "$table\n";
}

sub table_footer {
    my $str = shift;
    my $colspan = shift;
    --$colspan;
    $colspan = 8;
    print "<tfoot>\n<tr>\n";
    print "<td colspan=\"6\"> </td><td colspan=\"2\">Totals</td><td class=\"number\">80</td><td class=\"number\">70</td><td class=\"number\">80</td><td class=\"number\">70</td><td class=\"number\">11100</td><td class=\"number\">110</td><td class=\"number\">10</td></tr>\n";
    print "<tr>\n";
    print "<td colspan=\"6\">$str</td><td colspan=\"2\">Percent missing</td><td> </td><td class=\"number\">70</td><td> </td><td class=\"number\">1</td><td> </td><td class\
=\"number\">2.5</td><td> </td></tr>\n";
    print "</tfoot>\n";
}

sub table_body {
    my $rhash = shift;

    print "<tbody>\n";

    foreach $date (sort keys %$rhash) {
#	@items = split / /, $$rhash{$date};
	@items = $$rhash{$date};
#	print "@items\n";
	print "<tr class=\"lo\">\n" if $highlight == 0;
	print "<tr class=\"hi\">\n" if $highlight == 1;
	$highlight = 1 - $highlight;
	print "<td>$date</td>\n";
	foreach $item (@items) {
	    foreach $item1 (@{$item}) {
		print "<td class=\"number\">$item1</td>\n";
	    }
	}
	print "</tr>\n";
    }
    print "</tbody>\n";
}

sub table_end {
    print "</table>\n";
}

sub html_header {
    my $raster = shift;
    my $hdr;

    $hdr = <<HERE;
    <!--
    <?xml version="1.0" encoding="ISO-8859-1" ?>
    -->

    <!DOCTYPE HTML PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

    <head>
    <meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />

    <title>
    Hinode EIS raster summary for $raster
    </title>

    <LINK REL=StyleSheet HREF="../style.css" TYPE="text/css" MEDIA=screen>

    </head>
HERE
    print "$hdr\n";
}

sub html_body {
    my $raster = shift;
    my $today = scalar(localtime);
    my $body = <<HERE;
<!--    <body bgcolor=#FFFFFF onload="stripe('foo', '#fff', '#edf3fe');"> -->
    <body bgcolor=#FFFFFF>
    <h1>
    Hinode EIS raster summary for $raster
    </h1>
    <center>
    Generated on $today
    </center>
HERE
print "$body\n";
}

# $list[0] = table title
# rest of list are table headers
sub table_start {
    my $title = shift;
    my $s = shift;
    my $i = shift;
    my $th;

    foreach $thing (@$s) {
        @items = split / /, $thing;
	$stitle .= "<th colspan=\"$items[1]\">$items[0]</th>\n";
    }

    foreach $thing (@$i) {
        $th .= "<th>$thing</th>\n";
    }
#    while($i = shift) {
#       $th .= "<th>$i</th>\n";
#    }
    my $table = <<HERE;
    <table id="foo" width="50%" summary="$title" border="1" cellpadding="2" cellspacing="0">
    <caption>$title</caption>
    <thead>
        <tr>
            $stitle
        </tr>
    </thead>
    <thead>
    <tr>
        $th
    </tr>
    </thead>
    <tbody>
HERE
return $table;
}

sub table_end1 {
    my $str = shift;
    my $colspan = shift;
    --$colspan;
    $colspan = 8;
    print "</tbody>\n";
    print "<tfoot><tr><td colspan=\"$colspan\">$str</td><td class=\"number\">80</td><td class=\"number\">70</td><td></td><td></td><td>11100</td><td>110</td><td>10</td></t\
r></tfoot>\n";
    print "</table>\n";
}

sub table_items {
#    my @items = @_;
    my $arg = shift;
    my @items = split(/:/, $arg);
#    print STDERR "table_items \@items = @items\n";
    print "<tr>";
    foreach $item (@items) {
        print "<td>$item</td>";
    }
    print "</tr>\n";
}

sub para {
    my $num = shift;
    while($num--) {
        print "<p />\n";
    }
}

sub header {
    my $num = shift;
    my $hdr = shift;

    print "<h$num>$hdr</h$num>\n";
}

sub html_end {
    print "</body>\n</html>\n";
}

