#!/usr/bin/perl                                                                                                                                                      

# ./make_tables.pl 'January 2007'  > ~/studies_list_200612.html
# studies{acronym} => [times run, incomplet count, author]

if($#ARGV != 0) {
    print STDERR "Usage: study_metrics 'Month yyyy' < file > output\n";
    die;
}
$highlight = 0;
$date_string = shift;
$total_studies = 10;

html_header();
html_body($date_string);
para(2);
#header(3, "Studies");

$num_item_groups = 0;
@items = ();

while(<>) {
    last if !/^\+table/;
    last if /-table/;
    while(<>) {
	last if /-name/;
        next if /\+name/;
        chomp;
        $table_name = $_;
    }
    while(<>) {
        last if /-supertitles/;
	next if /\+supertitles/;
        chomp;
	push @stitles, $_;
    }
    while(<>) {
        last if /-titles/;
        next if /\+titles/;
	chomp;
        push @titles, $_;
    }
    while(<>) {
	last if /-table/;
        chomp;
        if(/\+items/) {
            next;
	}
        if(/-items/) {
            $items{$num_item_groups} = join ':', @items;
            ++$num_item_groups;
            next;
	}
        push @items, "$_";
    }
}

table_header($table_name, \@stitles, \@titles);
table_footer("5 files expected, 4 ccsds received, 3 fits generated", scalar(@titles));
table_body($num_item_groups, @items);
table_end();
para(2);
html_end();
exit;

sub table_header {
    my $title = shift;
    my $s = shift;
    my $i = shift;
    my $th;
    my @items;

    foreach $thing (@$s) {
	@items = split / /, $thing;
        $stitle .= "<th colspan=\"$items[1]\">$items[0]</th>\n";
    }

    foreach $thing (@$i) {
	$th .= "<th>$thing</th>\n";
    }
    my $table = <<HERE;
    <table id="foo" width="50%" summary="$title" border="1" cellpadding="2" cellspacing="0">
    <caption>$title</caption>
    <thead>
        <tr>
            $stitle
        </tr>
	<tr>
            $th
        </tr>
    </thead>
HERE
print "$table\n";
}

sub table_footer {
    my $str = shift;
    my $colspan = shift;
    --$colspan;
    $colspan = 8;
    print "<tfoot>\n<tr>\n";
    print "<td colspan=\"6\"> </td><td colspan=\"2\">Totals</td><td class=\"number\">80</td><td class=\"number\">70</td><td class=\"number\">80</td><td class=\"number\">70</td><td class=\"number\">11100</td><td class=\"number\">110</td><td class=\"number\">10</td></tr>\n";
    print "<tr>\n";
    print "<td colspan=\"6\">$str</td><td colspan=\"2\">Percent missing</td><td> </td><td class=\"number\">70</td><td> </td><td class=\"number\">1</td><td> </td><td class\
=\"number\">2.5</td><td> </td></tr>\n";
    print "</tfoot>\n";
}

sub table_body {
    my $arg = shift;
#    my @items = split(/:/, $arg);
    my @items = @_;
#    print STDERR "$arg, @items\n";

    print "<tbody>\n";
    for($i = 0; $i < $arg; ++$i) {
#	print "<tr>\n";
	print "<tr class=\"lolite\">\n" if $highlight == 0;
	print "<tr class=\"hilite\">\n" if $highlight == 1;
	$highlight = 1 - $highlight;
        for($e = 0; $e < 15; ++$e) {
#       foreach $item (@items) {
#           print "<td>$item</td>";
            $item = shift @items;
	    if(($e == 5) || ($e == 6) || ($e == 8) || ($e == 9) || ($e == 12) || ($e == 13) || ($e == 14)) {
		print "<td class=\"number\">$item</td>";
	    }
	    else {
		print "<td>$item</td>";
	    }
        }
        print "</tr>\n";
    }
    print "</tbody>\n";
}

sub table_end {
    print "</table>\n";
}

sub html_header {
    my $date = shift;
    my $hdr;

    $hdr = <<HERE;
    <!--
    <?xml version="1.0" encoding="ISO-8859-1" ?>
    -->

    <!DOCTYPE HTML PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

    <head>
    <meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />

    <title>
    Hinode EIS reformat summary for eis_plan_$date_string
    </title>

    <LINK REL=StyleSheet HREF="style.css" TYPE="text/css" MEDIA=screen>
    <style type="text/css" media="Screen">
    /* <![CDATA[ */

    table {
        border-top: 1px solid #C9C9C9;                                                                                                                                 
        border-left: 1px solid #C9C9C9;                                                                                                                                
    }

    table {
	border: 1px solid #666666;                                                                                                                                     
    }

    h1 {
	text-align: center;
    }

    h2 {
	text-align: center;
    }

    th {
        border-bottom: 1px solid #C9C9C9;                                                                                                                              
        border-right: 1px solid #C9C9C9;                                                                                                                               
	font: 80% Verdana, Arial, sans-serif;
        padding-left: 5px;
        /*  padding-left: 10%; */
    }

    td {
        border-bottom: 1px solid #C9C9C9;                                                                                                                              
        border-right: 1px solid #C9C9C9;                                                                                                                               
	font: 80% Verdana, Arial, sans-serif;
        text-align: left;
        padding-left: 5px;
        padding-right: 5px;
        /*  padding-left: 10%; */
    }

    caption {
	padding: 0 0 10px;
	font: bold 120% Arial, sans-serif;
	text-transform: uppercase;
	text-align: left;
    }

    th {
	background: #bababa;                                                                                                                                           
	text-align: center;
	font-weight: bold;
        border-bottom: 1px solid #666666;                                                                                                                              
    }

    thead {
	text-align : center;
    }

    tfoot {
        /*               background-color: #666666;*/
        /*               background-color: 0; */
        background-color: #dddddd;                                                                                                                                     
        /*                 color: #dddddd; */
	/*               font-size: 80%; */
	/*                   color : green; */
	font-weight: bold;
        /*text-transform: uppercase;*/
    }

    tfoot {
	border-bottom: 0;
	border-right: 0;
    }

    a {
	color : blue;
    }

    /*
    #error a {                                                                                                                                                         
	 color : red;
	 font-weight: bold;
    }
    */

    .error {
	 color : red;
	 font-weight: bold;
    }

    .ool {
	 color : red;
	 font-weight : bold;
    }

    .in_range {
	 color : yellow;
    }

    td.number {
	 text-align: right;
	 /*        color : red; */
	 /*        font-weight : bold; */
    }

    tr.lolite td {
        background-color: #FFFFFF; color: black;
    }

    tr.hilite td {
	background-color: #EDF3FE; color: black;
    }

    .title {
	 text-align : center;
    }

          /*  ]]> */
    </style>
    </head>
HERE
    print "$hdr\n";
}

sub html_body {
    my $date_string = shift;
    my $today = scalar(localtime);
    my $body = <<HERE;
<!--    <body bgcolor=#FFFFFF onload="stripe('foo', '#fff', '#edf3fe');"> -->
    <body bgcolor=#FFFFFF>
    <h1>
    Hinode EIS reformat summary for eis_plan_$date_string
    </h1>
    <center>
    Generated on $today
    </center>
HERE
print "$body\n";
}

# $list[0] = table title
# rest of list are table headers
sub table_start {
    my $title = shift;
    my $s = shift;
    my $i = shift;
    my $th;

    foreach $thing (@$s) {
        @items = split / /, $thing;
	$stitle .= "<th colspan=\"$items[1]\">$items[0]</th>\n";
    }

    foreach $thing (@$i) {
        $th .= "<th>$thing</th>\n";
    }
#    while($i = shift) {
#       $th .= "<th>$i</th>\n";
#    }
    my $table = <<HERE;
    <table id="foo" width="50%" summary="$title" border="1" cellpadding="2" cellspacing="0">
    <caption>$title</caption>
    <thead>
        <tr>
            $stitle
        </tr>
    </thead>
    <thead>
    <tr>
        $th
    </tr>
    </thead>
    <tbody>
HERE
return $table;
}

sub table_end1 {
    my $str = shift;
    my $colspan = shift;
    --$colspan;
    $colspan = 8;
    print "</tbody>\n";
    print "<tfoot><tr><td colspan=\"$colspan\">$str</td><td class=\"number\">80</td><td class=\"number\">70</td><td></td><td></td><td>11100</td><td>110</td><td>10</td></t\
r></tfoot>\n";
    print "</table>\n";
}

sub table_items {
#    my @items = @_;
    my $arg = shift;
    my @items = split(/:/, $arg);
#    print STDERR "table_items \@items = @items\n";
    print "<tr>";
    foreach $item (@items) {
        print "<td>$item</td>";
    }
    print "</tr>\n";
}

sub para {
    my $num = shift;
    while($num--) {
        print "<p />\n";
    }
}

sub header {
    my $num = shift;
    my $hdr = shift;

    print "<h$num>$hdr</h$num>\n";
}

sub html_end {
    print "</body>\n</html>\n";
}

