#!/usr/local/bin/perl
 
use Time::Local;
use Date::Calc;
use Env qw(EGSE_SW_LIB);

do "$EGSE_SW_LIB/date_calc.pl"     || die "Can't do date_calc.pl: $!\n";
do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

my %fits;

if($#ARGV == 0) {
    $search_name = shift;
}
elsif($#ARGV == 1) {
    $opt = shift;
    $search_name = shift;
}
else {
    print "Usage: fits_name [-e] ccsds_file_name\n";
    exit;
}

#$dbase_path = "$pipeline_log/mission_name_dbase";
#$dbase_path = "$pipeline_log/engineering_name_dbase" if $opt eq "-e";

$dbase_name = "mission_name_dbase";
$dbase_name = "engineering_name_dbase" if $opt eq "-e";
$dbase = "$pipeline_log/$dbase_name";

#if(dbmopen(%trans, "$pipeline_log/mission_name_dbase", undef)) {
if(dbmopen(%dbase, $dbase, undef)) {
    @keys = keys %dbase;
#    print "Number of keys: ", scalar(@keys), "\n";
    foreach $key (@keys) {
	$val = $dbase{$key};
	$fits{$val} = $key;
    }

    @keys1 = keys %fits;
#    print "Number of keys: ", scalar(@keys1), "\n";

    $md_file = $fits{$search_name};
    if($md_file) {
	print STDOUT "$search_name => $md_file\n";
    }
    else {
	print STDOUT "No translation for $search_name in $dbase_name\n";
    }
    dbmclose(%dbase);
}
else {
    print STDERR "Can't open or find the database $dbase_name\n";
}


